/* File: dmamemtest.c */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/mman.h>
#include <asm/io.h>
#include <asm/page.h>
#include <linux/ps2/dev.h>

#ifndef PS2LINUX_ADD_FUNCTIONS_REV_MAJOR
#error "Need special patch version linux kernel\n"
#endif

void *dmamem_alloc(unsigned int pagesize)
{
	int fd;
	void *m;

	fd = open(PS2_DEV_MEM, O_RDWR);
	if (fd <0) {
		printf("maptest: open error\n");
		return (void *)-1;
	}

	m = mmap(0, pagesize * getpagesize(),
		PROT_READ | PROT_WRITE, MAP_PRIVATE, fd, 0);
	if (m==(void*)-1) {
		printf("maptest: mmap error\n");
		close(fd);
		return (void *)-1;
	}
	close(fd);
	return m;
}

int main( int argc, char **argv )
{
	int *m, i, ct;

	printf("Current settings : start = %x size=%x\n",
		PS2_RESERVE_MEMORY_START, PS2_RESERVE_MEMORY_SIZE);
	m = dmamem_alloc( PS2_RESERVE_MEMORY_SIZE / getpagesize() );
	ct = 0;
	printf("\nPass-1\n\n");
	for (i = 0; i < PS2_RESERVE_MEMORY_SIZE/4; i++) {
		if (i % (1024*1024/4) == 0)
			printf("%d: passed.\n", i*4);
		if (m[i] != i && ct < 20) {
			printf("%d(%d*4): skip -> %d\n", i*4, i, m[i]);
			ct++;
		}
		m[i] = i;
	}
	printf("\nPass-2\n\n");
	for (i = 0; i < PS2_RESERVE_MEMORY_SIZE/4; i++) {
		if (i % (1024*1024/4) == 0)
			printf("%d: passed.\n", i*4);
		if (m[i] != i)
			printf("%d(%d*4): error -> %d\n", i*4, i, m[i]);
	}
	printf("\nEnd\n");

	return 0;
}
