/* File: input.h */

#ifndef __INPUT_H_INCLUDED
#define __INPUT_H_INCLUDED

#define GRP_GAMEDEV_MAX			2
#define GRP_GAMEDEV_ANALOG_ERROR_DIST	60

#define GRP_KEYLEFT	PS2PAD_BUTTON_LEFT
#define GRP_KEYRIGHT	PS2PAD_BUTTON_RIGHT
#define GRP_KEYUP	PS2PAD_BUTTON_UP
#define GRP_KEYDOWN	PS2PAD_BUTTON_DOWN
#define GRP_KEYA	PS2PAD_BUTTON_CIRCLE
#define GRP_KEYB	PS2PAD_BUTTON_CROSS
#define GRP_KEYC	PS2PAD_BUTTON_SQUARE
#define GRP_KEYD	PS2PAD_BUTTON_TRIANGLE
#define GRP_KEYL1	PS2PAD_BUTTON_L1
#define GRP_KEYL2	PS2PAD_BUTTON_L2
#define GRP_KEYL3	PS2PAD_BUTTON_L3
#define GRP_KEYR1	PS2PAD_BUTTON_R1
#define GRP_KEYR2	PS2PAD_BUTTON_R2
#define GRP_KEYR3	PS2PAD_BUTTON_R3
#define GRP_KEYSTART	PS2PAD_BUTTON_START
#define GRP_KEYSELECT	PS2PAD_BUTTON_SELECT

/* key results */
extern int grp_key_digital1_v[GRP_GAMEDEV_MAX];
extern int grp_key_digital1_h[GRP_GAMEDEV_MAX];
extern int grp_key_analog1_v[GRP_GAMEDEV_MAX];
extern int grp_key_analog1_h[GRP_GAMEDEV_MAX];
extern int grp_key_analog2_v[GRP_GAMEDEV_MAX];
extern int grp_key_analog2_h[GRP_GAMEDEV_MAX];
extern unsigned int grp_key_buttons[GRP_GAMEDEV_MAX];
extern unsigned int grp_key_triggers[GRP_GAMEDEV_MAX];

/* prototypes */
extern int __grp_gameport_init( void );
extern int grp_gameport_read( void );

#endif /* __INPUT_H_INCLUDED */
