/* File: def_dma.h */

#ifndef __DEF_DMA_H_INCLUDED
#define __DEF_DMA_H_INCLUDED

typedef unsigned int VIF_UNIT;

enum VIF_unpack_mode {
	VIF_UNPACK_S_32  = PS2_VIF_UNPACK | 0x00U,
	VIF_UNPACK_S_16  = PS2_VIF_UNPACK | 0x01U,
	VIF_UNPACK_S_8   = PS2_VIF_UNPACK | 0x02U,
	VIF_UNPACK_V2_32 = PS2_VIF_UNPACK | 0x04U,
	VIF_UNPACK_V2_16 = PS2_VIF_UNPACK | 0x05U,
	VIF_UNPACK_V2_8  = PS2_VIF_UNPACK | 0x06U,
	VIF_UNPACK_V3_32 = PS2_VIF_UNPACK | 0x08U,
	VIF_UNPACK_V3_16 = PS2_VIF_UNPACK | 0x09U,
	VIF_UNPACK_V3_8  = PS2_VIF_UNPACK | 0x0aU,
	VIF_UNPACK_V4_32 = PS2_VIF_UNPACK | 0x0cU,
	VIF_UNPACK_V4_16 = PS2_VIF_UNPACK | 0x0dU,
	VIF_UNPACK_V4_8  = PS2_VIF_UNPACK | 0x0eU,
	VIF_UNPACK_V4_5  = PS2_VIF_UNPACK | 0x0fU
};

#define DMA_UNIT_BYTE	(sizeof(unsigned int)*4)
#define DMA_UNIT_BITS	4
#define DMAsizeof( _X )	((sizeof(_X)+DMA_UNIT_BYTE-1) >> DMA_UNIT_BITS)

#define _gps2_setdma_skip_16( _N )	__grl_ps2gdma_buf_p += (_N) << 2
#define _gps2_setdma_skip_8( _N )	__grl_ps2gdma_buf_p += (_N) << 1
#define _gps2_setdma_skip_4( _N )	__grl_ps2gdma_buf_p += (_N)

#define _gps2_setdma_32( _V ) \
	*__grl_ps2gdma_buf_p++ = (_V);

#define _gps2_setdma_f32( _F ) \
	*((float *)__grl_ps2gdma_buf_p)++ = (_F);

#define _gps2_setdma_64( _V ) \
	*((u_long64 *)__grl_ps2gdma_buf_p)++ = (u_long64)(_V);

#define _gps2_setdma_32323232( _V1, _V2, _V3, _V4 ) { \
		__grl_ps2gdma_buf_p[0] = (_V1); \
		__grl_ps2gdma_buf_p[1] = (_V2); \
		__grl_ps2gdma_buf_p[2] = (_V3); \
		__grl_ps2gdma_buf_p[3] = (_V4); \
		_gps2_setdma_skip_4(4); \
	}

#define _gps2_setdma_323232nd( _V1, _V2, _V3 ) { \
		__grl_ps2gdma_buf_p[0] = (_V1); \
		__grl_ps2gdma_buf_p[1] = (_V2); \
		__grl_ps2gdma_buf_p[2] = (_V3); \
		_gps2_setdma_skip_4(4); \
	}

#define _gps2_setdma_3232ndnd( _V1, _V2 ) { \
		__grl_ps2gdma_buf_p[0] = (_V1); \
		__grl_ps2gdma_buf_p[1] = (_V2); \
		_gps2_setdma_skip_4(4); \
	}

#define _gps2_setdma_f32323232( _F1, _F2, _F3, _F4 ) { \
		((float *)(__grl_ps2gdma_buf_p))[0] = (_F1); \
		((float *)(__grl_ps2gdma_buf_p))[1] = (_F2); \
		((float *)(__grl_ps2gdma_buf_p))[2] = (_F3); \
		((float *)(__grl_ps2gdma_buf_p))[3] = (_F4); \
		_gps2_setdma_skip_4(4); \
	}

#define _gps2_setdma_f323232nd( _F1, _F2, _F3 ) { \
		((float *)(__grl_ps2gdma_buf_p))[0] = (_F1); \
		((float *)(__grl_ps2gdma_buf_p))[1] = (_F2); \
		((float *)(__grl_ps2gdma_buf_p))[2] = (_F3); \
		_gps2_setdma_skip_4(4); \
	}

#define _gps2_setdma_6464( _V1, _V2 ) { \
		*(u_long64 *)(&__grl_ps2gdma_buf_p[0]) = (u_long64)(_V1); \
		*(u_long64 *)(&__grl_ps2gdma_buf_p[2]) = (u_long64)(_V2); \
		_gps2_setdma_skip_8(2); \
	}

#define _gps2_setdma_6464ul( _V1, _V2 ) { \
		*(u_long64 *)(&__grl_ps2gdma_buf_p[0]) = (u_long64)(_V2); \
		*(u_long64 *)(&__grl_ps2gdma_buf_p[2]) = (u_long64)(_V1); \
		_gps2_setdma_skip_8(2); \
	}

#define _gps2_setdma_128( _VALUE ) { \
		*(u_long128 *)__grl_ps2gdma_buf_p = (u_long128)(_VALUE); \
		_gps2_setdma_skip_16(1); \
	}

#define _gps2_setdma_128p( _VALUE ) { \
		*(u_long128 *)__grl_ps2gdma_buf_p = *(u_long128 *)(_VALUE); \
		_gps2_setdma_skip_16(1); \
	}

#if defined(REDUCE_DMATAG) && !defined(USE_VIF1DMA_TTE1)
#define _gps2_close_dma() \
	if (__grl_dma_ptr[grd_get_currentdrawpath()]) { \
		*__grl_dma_ptr[grd_get_currentdrawpath()] |= \
			__grl_dma_ct[grd_get_currentdrawpath()]; \
		__grl_dma_ct[grd_get_currentdrawpath()]  = 0; \
		__grl_dma_ptr[grd_get_currentdrawpath()] = NULL; \
	}

#define _gps2_set_reducedma_cnt(_N, _D3) \
	if (__grl_dma_ptr[grd_get_currentdrawpath()]) { \
		if (__grl_dma_ct[grd_get_currentdrawpath()] + (_N) > 0xffffU) { \
			_gps2_close_dma(); \
			__grl_dma_ct[grd_get_currentdrawpath()]  = (_N); \
			__grl_dma_ptr[grd_get_currentdrawpath()] = __grl_ps2gdma_buf_p; \
			_gps2_setdma_32323232( 0 | 0x10000000, 0, 0, (_D3) ); \
		} else \
			__grl_dma_ct[grd_get_currentdrawpath()] += (_N); \
	} else { \
		__grl_dma_ct[grd_get_currentdrawpath()]  = (_N); \
		__grl_dma_ptr[grd_get_currentdrawpath()] = __grl_ps2gdma_buf_p; \
		_gps2_setdma_32323232( 0 | 0x10000000, 0, 0, (_D3) ); \
	}
#else
#define _gps2_set_reducedma_cnt(_N, _D3) { \
		_gps2_setdma_32323232( (_N) | 0x10000000, 0, 0, (_D3) ); \
	}

#define _gps2_close_dma()
#endif /* REDUCE_DMATAG && !USE_VIF1DMA_TTE1 */

#ifdef USE_VIF1DMA_TTE1
#define _gps2_setdma_dma( _LOOP, _REGS ) { \
		_gps2_setdma_32323232( \
			 ((_LOOP)*(_REGS)+1) | 0x10000000U, \
			0, 0, \
		PS2_VIF_SET_CODE( (_LOOP)*(_REGS)+1, 0, PS2_VIF_DIRECT, 0 ) ); \
	}
#else
#define _gps2_setdma_dma( _LOOP, _REGS ) { \
		_gps2_set_reducedma_cnt( (_LOOP)*(_REGS)+1+1, 0 ); \
		_gps2_setdma_32323232( 0, 0, 0, \
			PS2_VIF_SET_CODE( (_LOOP)*(_REGS)+1, 0, PS2_VIF_DIRECT, 0 ) ); \
	}
#endif

#define _gps2_setdma_gif( _LOOP, _REGS, _V1, _V2 ) { \
		_gps2_setdma_6464( GIF_NLOOP((_LOOP)) | GIF_NREG((_REGS)) \
			| (u_long64)((_V1)), (u_long64)((_V2)) ); \
	}

#define _gps2_setdma_dmagif( _LOOP, _REGS, _V1, _V2 ) { \
		_gps2_setdma_dma( (_LOOP), (_REGS) ); \
		_gps2_setdma_gif( (_LOOP), (_REGS), (_V1), (_V2) ); \
	}

#ifdef USE_VIF1DMA_TTE1
#define _gps2_setdma_vif1( _VIFDATA ) \
	_gps2_setdma_32323232( 0 | 0x10000000, 0, 0, (_VIFDATA) );

#define _gps2_setdma_vif1_2( _LEN, _VIFDATA1, _VIFDATA2 ) \
	_gps2_setdma_32323232( (_LEN) | 0x10000000, \
		0, (_VIFDATA1), (_VIFDATA2) );
#else /* USE_VIF1DMA_TTE1 (NO) */
#define _gps2_setdma_vif1( _VIFDATA ) \
	if (!__grl_ps2gdma_path) { \
		_gps2_set_reducedma_cnt( 1, 0 ); \
		_gps2_setdma_32323232( 0, 0, 0, (_VIFDATA) ); \
	}

#define _gps2_setdma_vif1_2( _LEN, _VIFDATA1, _VIFDATA2 ) \
	if (!__grl_ps2gdma_path) { \
		_gps2_set_reducedma_cnt( 1+(_LEN), 0 ); \
		_gps2_setdma_32323232( 0, 0, (_VIFDATA1), (_VIFDATA2) ); \
	}
#endif

#ifdef USE_PHSYADR_DMA
#define _gps2_setdma_dmaref( _P, _LEN ) { \
		_gps2_setdma_32323232( (_LEN) | 0x30000000, \
			(unsigned int)(_P) - (unsigned int)__grl_ps2_dmamem_p + PS2_RESERVE_MEMORY_START, \
			0, 0 ); \
	}
#else
#define _gps2_setdma_dmaref( _P, _LEN ) { \
		_gps2_close_dma(); \
		_gps2_setdma_32323232( (_LEN) | 0x30000000, \
			(unsigned int)(_P), 0, 0 ); \
	}
#endif

#ifdef USE_VIF1DMA_TTE1
#define _gps2_setdma_dmaref_vif1( _P, _LEN, _VIF ) \
	_gps2_setdma_32323232( (_LEN) | 0x30000000, \
		(unsigned int)(_P) - (unsigned int)__grl_ps2_dmamem_p + PS2_RESERVE_MEMORY_START, \
		0, (_VIF) );
#else /* USE_VIF1DMA_TTE1 (NO) */
#define _gps2_setdma_dmaref_vif1( _P, _LEN, _VIF ) { \
		if (!__grl_ps2gdma_path) { \
			_gps2_set_reducedma_cnt( 1, 0 ); \
			_gps2_setdma_32323232( 0, 0, 0, (_VIF) ); \
		} \
		_gps2_close_dma(); \
		_gps2_setdma_dmaref( _P, _LEN ); \
	}
#endif /* USE_VIF1DMA_TTE1 */

#define _gps2_setdma_dmaref_vif1direct( _P, _LEN ) { \
		_gps2_setdma_dmaref_vif1( (_P), (_LEN), \
			PS2_VIF_SET_CODE( (_LEN), 0, PS2_VIF_DIRECT, 0 ) ); \
	}

#define _gps2_setdma_vpudata_r_tag( _ADR, _LEN ) { \
		_gps2_setdma_vif1_2( (_LEN), \
			PS2_VIF_SET_CODE( 0x0404, 0, PS2_VIF_STCYCL, 0 ), \
			PS2_VIF_SET_CODE( (_ADR) | 0x8000U, (_LEN), VIF_UNPACK_V4_32, 0 ) ); \
	}

#define _gps2_setdma_vpudata_body( _P, _LEN ) { \
		memcpy( __grl_ps2gdma_buf_p, (_P), (_LEN) << DMA_UNIT_BITS ); \
		_gps2_setdma_skip_16(_LEN); \
	}

#define _gps2_setdma_vpudata_r( _ADR, _P, _LEN ) { \
		_gps2_setdma_vpudata_r_tag( (_ADR), (_LEN) ); \
		_gps2_setdma_vpudata_body( (_P), (_LEN) ); \
	}

#define _gps2_setdma_vpudata( _ADR, _P, _LEN ) { \
		_gps2_setdma_vif1_2( (_LEN), \
			PS2_VIF_SET_CODE( 0x0404, 0, PS2_VIF_STCYCL, 0 ), \
			PS2_VIF_SET_CODE( (_ADR), (_LEN), VIF_UNPACK_V4_32, 0 ) ); \
		_gps2_setdma_vpudata_body( (_P), (_LEN) ); \
	}

#endif /* __DEF_DMA_H_INCLUDED */
