/* File: prim3d.c */

#include "config.h"

#include <math.h>

#include "common.h"
#include "matrix.h"
#include "geometry.h"
#include "draw.h"
#include "prim.h"
#include "prim3d.h"
#include "context.h"

void grd_3d_vpoint( GRVector4 *posvec_p, GRVector4 *colvec_p, int opt )
{
	int wclip;
	GRVector4 tvec;

	grg_rotperstrans_hm_wclip( &tvec, posvec_p, &grg_screen, wclip );
	if (!wclip)
		grd_draw_vpoint( &tvec, colvec_p, opt );
	return;
}

void grd_3d_vgline( GRVector4 *posvec1_p, GRVector4 *posvec2_p,
	GRVector4 *colvec1_p, GRVector4 *colvec2_p, int opt )
{
	int wclip1, wclip2;
	GRVector4 tvec1, tvec2;

	grg_rotperstrans_hm_wclip( &tvec1, posvec1_p, &grg_screen, wclip1 );
	grg_rotperstrans_hm_wclip( &tvec2, posvec2_p, &grg_screen, wclip2 );
	if (!wclip1 && !wclip2)
		grd_draw_vgline( &tvec1, &tvec2, colvec1_p, colvec2_p, opt );
	return;
}

void grd_3d_vsprite( GRVector4 *posvec_p, GRVector4 *colvec_p,
	GRVector4 *stqvec1_p, GRVector4 *stqvec2_p,
	GRVector4 *multvec_p, int opt )
{
	int wclip;
	float q;
	GRVector4 tvec1, tvec2, mvec;

	grg_rotperstrans_hm_wclip_q( &tvec1, posvec_p, &grg_screen, wclip, q );
	if (!wclip) {
		mvec.x = multvec_p->x * q;
		mvec.y = multvec_p->y * q;
		mvec.z = 0.0f;
		mvec.w = 0.0f;
		grm_vector4_a_vector4( &tvec2, &tvec1, &mvec );
		grm_vector4_s_vector4( &tvec1, &tvec1, &mvec );
		grd_draw_vtsprite( &tvec2, &tvec1, colvec_p, stqvec1_p, stqvec2_p, opt );
	}
	return;
}

void grd_3d_vgtriangle( GRVector4 *posvec1_p, GRVector4 *posvec2_p, GRVector4 *posvec3_p,
	GRVector4 *colvec1_p, GRVector4 *colvec2_p, GRVector4 *colvec3_p, int opt )
{
	int wclip1, wclip2, wclip3;
	GRVector4 tvec1, tvec2, tvec3;

	grg_rotperstrans_hm_wclip( &tvec1, posvec1_p, &grg_screen, wclip1 );
	grg_rotperstrans_hm_wclip( &tvec2, posvec2_p, &grg_screen, wclip2 );
	grg_rotperstrans_hm_wclip( &tvec3, posvec3_p, &grg_screen, wclip3 );
	if (!wclip1 && !wclip2 && !wclip3)
		grd_draw_vgtriangle( &tvec1, &tvec2, &tvec3, colvec1_p, colvec2_p, colvec3_p, opt );
	return;
}

void grd_3d_vgtriangles( int n, GRVector4 *posvec_p, GRVector4 *colvec_p, int opt )
{
	int i, wclip1, wclip2, wclip3;
	GRVector4 tvec;

	wclip1 = wclip2 = TRUE;
	grd_draw_vgtriangle_s( n, GS_PRIM_TRIANGLE_STRIP | opt );
	for (i = 0; i < n; i++) {
		wclip3 = wclip2;
		wclip2 = wclip1;
		grg_rotperstrans_hm_wclip( &tvec, posvec_p, &grg_screen, wclip1 );
		grd_draw_vgtriangle_w( &tvec, colvec_p,
			(wclip1 || wclip2 || wclip3) );
		posvec_p++;
		colvec_p++;
	}
	return;
}

void grd_3d_vgttriangle( GRVector4 *posvec1_p, GRVector4 *posvec2_p, GRVector4 *posvec3_p,
	GRVector4 *colvec1_p, GRVector4 *colvec2_p, GRVector4 *colvec3_p,
	GRVector4 *stqvec1_p, GRVector4 *stqvec2_p, GRVector4 *stqvec3_p,
	int opt )
{
	int wclip1, wclip2, wclip3;
	GRVector4 tvec1, tvec2, tvec3;
	GRVector4 tstq1, tstq2, tstq3;

	grg_rotperstrans_hm_tex_wclip( &tvec1, posvec1_p, &tstq1, stqvec1_p, &grg_screen, wclip1 );
	grg_rotperstrans_hm_tex_wclip( &tvec2, posvec2_p, &tstq2, stqvec2_p, &grg_screen, wclip2 );
	grg_rotperstrans_hm_tex_wclip( &tvec3, posvec3_p, &tstq3, stqvec3_p, &grg_screen, wclip3 );
	if (!wclip1 && !wclip2 && !wclip3)
		grd_draw_vgttriangle( &tvec1, &tvec2, &tvec3, colvec1_p, colvec2_p, colvec3_p, &tstq1, &tstq2, &tstq3, opt );
	return;
}

void grd_3d_vgttriangles( int n, GRVector4 *posvec_p,
	GRVector4 *colvec_p, GRVector4 *stqvec_p, int opt )
{
	int i, wclip1, wclip2, wclip3;
	GRVector4 tvec, tstq;

	wclip1 = wclip2 = TRUE;
	grd_draw_vgttriangle_s( n, GS_PRIM_TRIANGLE_STRIP | opt );
	for (i = 0; i < n; i++) {
		wclip3 = wclip2;
		wclip2 = wclip1;
		grg_rotperstrans_hm_tex_wclip( &tvec, posvec_p, &tstq, stqvec_p, &grg_screen, wclip1 );
		grd_draw_vgttriangle_w( &tvec, colvec_p, &tstq,
			(wclip1 || wclip2 || wclip3) );
		posvec_p++;
		colvec_p++;
		stqvec_p++;
	}
	return;
}
