/* File: vpu1.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "common.h"
#include "tex.h"
#include "memory.h"
#include "draw.h"
#include "vpu1.h"

static VPUFILE *__grl_ps2_vfd[__PS2_VPU1_VPUFILE_MAX];
static void *__grl_ps2_vucode_ptr[__PS2_VPU1_VPUFILE_MAX];
static int __grl_ps2_vucode_size[__PS2_VPU1_VPUFILE_MAX];

static void *__grl_ps2_vpu1_current_code;
static int __grl_ps2_vpu1_initialized = FALSE;

void __grl_ps2_vpu1_init( void )
{
	memset( __grl_ps2_vfd, 0, sizeof(__grl_ps2_vfd[__PS2_VPU1_VPUFILE_MAX]) );
	__grl_ps2_vpu1_current_code = NULL;
	__grl_ps2_vpu1_initialized  = FALSE;
	return;
}

void __grl_ps2_vpu1_shutdown( void )
{
	int i;

	for (i = 0; i < __PS2_VPU1_VPUFILE_MAX; i++) {
		if (__grl_ps2_vfd[i]) {
			vpuobj_close(__grl_ps2_vfd[i]);
			__grl_ps2_vfd[i] = NULL;
		}
	}
	return;
}

int grd_ps2_vpu1_unload( int id )
{
	if (__grl_ps2_vfd[id]) {
		vpuobj_close(__grl_ps2_vfd[id]);
		__grl_ps2_vfd[id] = NULL;
		return TRUE;
	} else
		return FALSE;
}

int grd_ps2_vpu1_load( char *fn )
{
	int i;
	void *tp;

	for (i = 0; i < __PS2_VPU1_VPUFILE_MAX; i++) {
		if (!__grl_ps2_vfd[i]) {
			__grl_ps2_vfd[i] = vpuobj_open( fn, O_DATA_PS2MEM );
			if (!__grl_ps2_vfd[i]) {
				ERRMSG("can't open the file \"%s\"\n", fn);
				return -2;
			}
			vpuobj_data( __grl_ps2_vfd[i], &tp, &__grl_ps2_vucode_size[i] );
			__grl_ps2_vucode_ptr[i] = DMEMALIGN( 16, __grl_ps2_vucode_size[i] );
			if (!__grl_ps2_vucode_ptr[i]) {
				vpuobj_close(__grl_ps2_vfd[i]);
				__grl_ps2_vfd[i] = NULL;
				ERRMSG("can't open the file \"%s\" (DMALLOC error)\n", fn);
				return -2;
			}
			memcpy( __grl_ps2_vucode_ptr[i], tp, __grl_ps2_vucode_size[i] );
			return i;
		}
	}
	return -1;
}

static void grd_ps2_vpu1_trans( int id )
{
	/* int i; */
	int size;
	unsigned int *ptr;

	__grl_ps2_vpu1_current_code = __grl_ps2_vfd[id];
	__grl_ps2_vpu1_initialized  = FALSE;

	ptr = __grl_ps2_vucode_ptr[id];
	ptr += 4;
	size = ((__grl_ps2_vucode_size[id] + 15) >> 4) - 1;
	TRACE( "transfer VPU1 code %08x(len = %d)\n", (unsigned int)ptr, size );
	_gps2_setdma_vif1( PS2_VIF_SET_CODE(0, 0, PS2_VIF_FLUSHA, 0) );
	_gps2_setdma_dmaref_vif1( (unsigned int)ptr, size - 1,
		PS2_VIF_SET_CODE( 0, (size - 1)*2, PS2_VIF_MPG, 0 ) );
#if 0
	for (i = 0; i < 20*4; i+=4) {
		TRACE("%4d: %08x %08x %08x %08x\n", i,
			ptr[i], ptr[i+1], ptr[i+2], ptr[i+3]);
	}
#endif
	return;
}

int grd_ps2_vpu1_use( int id, int auto_initialize, int force_transfer )
{
	int flag = FALSE;

	if (!__grl_ps2_vfd[id])
		return -1;
	if ((__grl_ps2_vpu1_current_code != __grl_ps2_vfd[id]) || force_transfer) {
		grd_ps2_vpu1_trans( id );
		flag = TRUE;
	}
	if (auto_initialize) {
		grd_ps2_vpu1_exec( 0 /* VPU1_ENTRY_INIT */ );
		__grl_ps2_vpu1_initialized  = TRUE;
	}
	return flag;
}
