/* File: debug.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <errno.h>
#include <unistd.h>

#include "common.h"
#include "fileio.h"
#include "draw.h"
#include "prim2d.h"
#include "context.h"
#include "debug.h"

int grif_enable_dumpframebuffer = FALSE;
int grif_enable_dumpframebuffer_alpha = FALSE;

/* draw.c */
extern int __grl_ps2sm_interlace;
extern int __grl_ps2sm_psm;
extern int __grl_ps2sm_refrate_n;
extern int __grl_ps2_fdgs;
extern ps2_vpu *__grl_ps2_vpu0, *__grl_ps2_vpu1;

static int framedump_ct = 0;
static unsigned char *frame_tp = NULL;
static unsigned char *frame_ap = NULL;

void __grl_debug_init( void )
{
	__grl_debug_profframest();
	return;
}

/* dump */
void __grl_debug_framedump( void )
{
	int i, j, k, l, flag;
	char fnbuf[256];
	unsigned char *p;
	struct ps2_image imagearg;

	if (!frame_tp) {
		frame_tp = DMEMALIGN( 16, SCREEN_SIZE_X*SCREEN_SIZE_IY*4 );
		if (!frame_tp) {
			ERRMSG("framedump() DMALLOC allocation error.\n");
			return;
		}
	} else
		memset( frame_tp, 0, SCREEN_SIZE_X*SCREEN_SIZE_IY*4 );
	if (!frame_ap) {
		frame_ap = MALLOC( SCREEN_SIZE_X*SCREEN_SIZE_Y*4 + 256 );
		if (!frame_ap) {
			ERRMSG("framedump() MALLOC allocation error.\n");
			return;
		}
	} else
		memset( frame_ap, 0, SCREEN_SIZE_X*SCREEN_SIZE_Y*4 + 256 );

	ioctl( ps2_vpu_fd(__grl_ps2_vpu1), PS2IOC_SENDQCT, 1 );
#ifdef USE_DRAWPATH_3
	ioctl( __grl_ps2_fdgs,             PS2IOC_SENDQCT, 1 );
#endif
	__grl_ps2_gsoddeven = ps2_gs_sync_v(0);

	imagearg.ptr = frame_tp;
	imagearg.fbw = __grl_ps2_gdb.draw01.frame1.FBW;
	imagearg.psm = __grl_ps2sm_psm;
	imagearg.x = 0;
	imagearg.y = 0;
	imagearg.w = SCREEN_SIZE_X;
	imagearg.h = SCREEN_SIZE_IY;
	flag = (((__grl_ps2_gsframe & 1) ? __grl_ps2_gdb.draw11.xyoffset1.OFY : __grl_ps2_gdb.draw01.xyoffset1.OFY)-((SCREEN_CENTER_POSY-(SCREEN_CENTER_IY >> 1)) << 4)) >> 3;

	/* raw save */
	for (k = 0; k < __grl_ps2sm_interlace+1; k++) {
		imagearg.fbp = (((__grl_ps2_gsframe+flag+k) & 1) ? __grl_ps2_gdb.draw11.frame1.FBP : __grl_ps2_gdb.draw01.frame1.FBP) << (VWORD2048SFT-VWORD64SFT);
		ps2_gs_store_image( &imagearg );

		p = frame_ap;
		for (l = 0; l < SCREEN_SIZE_IY; l++) {
			i = l * (__grl_ps2sm_interlace + 1) + k;
			for (j = 0; j < SCREEN_SIZE_X; j++) {
				if (grif_enable_dumpframebuffer_alpha) {
					p[(i*SCREEN_SIZE_X+j)*4  ] = frame_tp[(l*SCREEN_SIZE_X+j)*4  ];
					p[(i*SCREEN_SIZE_X+j)*4+1] = frame_tp[(l*SCREEN_SIZE_X+j)*4+1];
					p[(i*SCREEN_SIZE_X+j)*4+2] = frame_tp[(l*SCREEN_SIZE_X+j)*4+2];
					p[(i*SCREEN_SIZE_X+j)*4+3] = frame_tp[(l*SCREEN_SIZE_X+j)*4+3];
				} else {
					p[(i*SCREEN_SIZE_X+j)*3  ] = frame_tp[(l*SCREEN_SIZE_X+j)*4  ];
					p[(i*SCREEN_SIZE_X+j)*3+1] = frame_tp[(l*SCREEN_SIZE_X+j)*4+1];
					p[(i*SCREEN_SIZE_X+j)*3+2] = frame_tp[(l*SCREEN_SIZE_X+j)*4+2];
				}
			}
		}
	}
	sprintf( fnbuf, "framedump_%04d.raw", framedump_ct );
	grp_fileio_openwrite( fnbuf, frame_ap, SCREEN_SIZE_X*SCREEN_SIZE_Y*(3+(grif_enable_dumpframebuffer_alpha ? 1 : 0)) );
	framedump_ct++;
	FREE( frame_ap );
	frame_ap = NULL;
	return;
}

/* profiler */
static struct V_debug_profiler_context {
	int overflow_flag;
	int index[2];
	int lasttime[2];
	unsigned int attr[2][GRD_DEBUG_PROF_BUFF_MAX];
	unsigned int buf[2][GRD_DEBUG_PROF_BUFF_MAX];
} __grl_debug_profcontext[GRD_DEBUG_PROF_MAX_NUM];

#ifdef USE_PHSYADR_DMA
#define __grl_debug_resettimer( TMODE ) { \
		*(int *)(__grl_ps2_genio_p + 0x10001010-PS2_DEV_GENIO_OFFSET) /* T2_MODE */ = 0x80 | (TMODE); \
		*(int *)(__grl_ps2_genio_p + 0x10001000-PS2_DEV_GENIO_OFFSET) /* T2_COUNT */ = 0; \
	}

#define __grl_debug_gettimer(X) *(X) = (*(int *)(__grl_ps2_genio_p + 0x10001000-PS2_DEV_GENIO_OFFSET) /* T2_COUNT */)

#define GRD_DEBUG_PROF_TIMER_UNIT	(294912000/2/256/__grl_ps2sm_refrate_n)
#define GRD_DEBUG_PROF_DIFF_VALUE	(150)
#else
static struct timeval __grl_debug_tv, __grl_debug_tv_bk;
static struct timezone __grl_debug_tz;

#define __grl_debug_resettimer( TMODE ) { \
		gettimeofday( &__grl_debug_tv, &__grl_debug_tz ); \
		__grl_debug_tv_bk = __grl_debug_tv; \
	}

#define __grl_debug_gettimer(X) { \
		gettimeofday( &__grl_debug_tv, &__grl_debug_tz ); \
		if (__grl_debug_tv.tv_usec > __grl_debug_tv_bk.tv_usec) \
			*(X) = __grl_debug_tv.tv_usec - __grl_debug_tv_bk.tv_usec; \
		else \
			*(X) = (1000000 + __grl_debug_tv.tv_usec) - __grl_debug_tv_bk.tv_usec; \
	}

#define GRD_DEBUG_PROF_TIMER_UNIT	(1000000/__grl_ps2sm_refrate_n)
#define GRD_DEBUG_PROF_DIFF_VALUE	(300)
#endif

void __grl_debug_profframest( void )
{
	int i;

	for (i = 0; i < GRD_DEBUG_PROF_MAX_NUM; i++) {
		__grl_debug_profcontext[i].overflow_flag = FALSE;
		__grl_debug_profcontext[i].index[__grl_ps2gdma_bufid] = 0;
		__grl_debug_profcontext[i].lasttime[__grl_ps2gdma_bufid] = 0;
	}
	__grl_debug_resettimer( GRD_DEBUG_PROF_TMODE_256 );
	return;
}

int grd_debug_profset( int prof_id, unsigned int color )
{
	int index;
	unsigned int t;

	__grl_debug_gettimer( &t );
	t = t + GRD_DEBUG_PROF_DIFF_VALUE;
	if (prof_id < 0 || prof_id >= GRD_DEBUG_PROF_MAX_NUM)
		return FALSE;
	index = __grl_debug_profcontext[prof_id].index[__grl_ps2gdma_bufid];
	if (index >= GRD_DEBUG_PROF_BUFF_MAX) {
		__grl_debug_profcontext[prof_id].overflow_flag = TRUE;
		__grl_debug_profcontext[prof_id].lasttime[__grl_ps2gdma_bufid] = t;
		return TRUE;
	}
	__grl_debug_profcontext[prof_id].attr[__grl_ps2gdma_bufid][index] = color;
	__grl_debug_profcontext[prof_id].buf[__grl_ps2gdma_bufid][index]  = t;
	__grl_debug_profcontext[prof_id].index[__grl_ps2gdma_bufid]++;
	__grl_debug_profcontext[prof_id].lasttime[__grl_ps2gdma_bufid]    = t;
	return TRUE;
}

void __grl_debug_profframeend( void )
{
	int i, t, profid, def_color_mode;
	int bk_pos_x, pos_x, frames;
	int nid = (__grl_ps2gdma_bufid + 1) % 2;

	t = __grl_debug_profcontext[0].lasttime[nid];
	for (i = 1; i < GRD_DEBUG_PROF_MAX_NUM; i++) {
		if (__grl_debug_profcontext[i].lasttime[nid] > t)
			t = __grl_debug_profcontext[i].lasttime[nid];
 	}
	frames = t / GRD_DEBUG_PROF_TIMER_UNIT + 1;

	grd_set_currentdrawpath( GRDRAW_PATH1 );
	grd_set_currentcontext( GRDRAW_CONTEXT1 );
	grd_set_drawmode_anormal_znotest_znoupdate( grd_get_currentcontext() );
	for (profid = 0; profid < GRD_DEBUG_PROF_MAX_NUM; profid++) {
		int r, g, b;

		/* frame bar */
		bk_pos_x = pos_x = 0;
		def_color_mode = FALSE;
		for (i = 0; i < __grl_debug_profcontext[profid].index[nid]; i++) {
			pos_x = (__grl_debug_profcontext[profid].buf[nid][i] * SCREEN_SIZE_X) / (GRD_DEBUG_PROF_TIMER_UNIT * frames);
			if (!__grl_debug_profcontext[profid].attr[nid][i]) {
				r = 0;
				g = 63+def_color_mode*64;
				b = 128;
				def_color_mode = !def_color_mode;
			} else {
				r = (__grl_debug_profcontext[profid].attr[nid][i] >> 16) & 0xff;
				g = (__grl_debug_profcontext[profid].attr[nid][i] >> 8)  & 0xff;
				b = __grl_debug_profcontext[profid].attr[nid][i]         & 0xff;
			}
			grd_2d_sprite(
				bk_pos_x, SCREEN_SIZE_Y-10-(GRD_DEBUG_PROF_MAX_NUM-1-profid)*8,
				pos_x,    SCREEN_SIZE_Y-10-(GRD_DEBUG_PROF_MAX_NUM-1-profid)*8+4,
				r, g, b, 100, GRDRAW_OPT_ALPHABLEND );
			bk_pos_x = pos_x;
		}

		/* frame line */
		for (i = 0; i <= frames; i++) {
			pos_x = i * SCREEN_SIZE_X / frames;
			if (pos_x > 0)
				pos_x = pos_x - 1;

			grd_2d_line(
				pos_x, SCREEN_SIZE_Y-10-(GRD_DEBUG_PROF_MAX_NUM-1-profid)*8-4,
				pos_x, SCREEN_SIZE_Y-10-(GRD_DEBUG_PROF_MAX_NUM-1-profid)*8+6,
				128, 128, 128, 128, 0 );
		}
	}
	return;
}
