/* File: draw.h */

#ifndef __DRAW_H_INCLUDED
#define __DRAW_H_INCLUDED

#include <asm/io.h>
#include <ps2vpu.h>
#include <ps2gs.h>
#include <ps2mem.h>
#include <ps2dma.h>
#include <ps2vpufile.h>
#include <linux/ps2/dev.h>

#ifdef PHDYADR_DMA
#ifndef PS2LINUX_ADD_FUNCTIONS_REV_MAJOR
#error "Requied special version linux kernel\n"
#endif
#endif

#include "matrix.h"
#include "context.h"
#include "def_gs.h"
#include "def_dma.h"

enum GRD_setresolution_mode {
	GRD_RESOLUTIONMODE_VESA = 0,
	GRD_RESOLUTIONMODE_NTSC,
	GRD_RESOLUTIONMODE_PAL,
	GRD_RESOLUTIONMODE_MAX_NUM
};

#define VWORD64		64
#define VWORD64SFT	6
#define VBYTE64		(64*4)		/* 256 */
#define VBYTE64SFT	8
#define VMASK64		0xffffffc0U
#define VWORD2048	2048
#define VWORD2048SFT	11
#define VBYTE2048	(2048*4)	/* 8192 */
#define VBYTE2048SFT	13
#define VMASK2048	0xffffe000U

#define SCREEN_CENTER_LEFT	(SCREEN_CENTER_POSX-SCREEN_CENTER_X)
#define SCREEN_CENTER_TOP	(SCREEN_CENTER_POSY-SCREEN_CENTER_IY)
#define SCREEN_CENTER_RIGHT	(SCREEN_CENTER_POSX+SCREEN_CENTER_X)
#define SCREEN_CENTER_BOTTOM	(SCREEN_CENTER_POSY+SCREEN_CENTER_IY)
#define SCREEN_2D_X(_X)		(SCREEN_CENTER_LEFT+(_X))
#define SCREEN_2D_Y(_X)		(SCREEN_CENTER_TOP+(_X)/(SCREEN_INTERLACE+1))
#define SCREEN_2D_MINUS_X(_X)	(SCREEN_CENTER_RIGHT-(_X))
#define SCREEN_2D_MINUS_Y(_X)	(SCREEN_CENTER_BOTTOM-(_X)/(SCREEN_INTERLACE+1))

#ifdef SCREEN_RES_FREE
extern int grd_screen_size_x;
extern int grd_screen_size_y;
extern int grd_screen_size_iy;
extern int grd_screen_center_x;
extern int grd_screen_center_y;
extern int grd_screen_center_iy;
extern int grd_screen_zbuf_min;
extern int grd_screen_zbuf_max;
extern int grd_screen_ratio;
extern float grd_screen_ratio_mfloat;
extern float grd_screen_x_div_y;
extern int grd_screen_interlace;

#define SCREEN_SIZE_X		grd_screen_size_x
#define SCREEN_SIZE_Y		grd_screen_size_y
#define SCREEN_SIZE_IY		grd_screen_size_iy
#define SCREEN_CENTER_X		grd_screen_center_x
#define SCREEN_CENTER_Y		grd_screen_center_y
#define SCREEN_CENTER_IY	grd_screen_center_iy
#define SCREEN_CENTER_POSX	2048
#define SCREEN_CENTER_POSY	2048
#define SCREEN_ZBUF_MIN		grd_screen_zbuf_min
#define SCREEN_ZBUF_MAX		grd_screen_zbuf_max
#define SCREEN_RATIO		grd_screen_ratio
#define SCREEN_RATIO_MFLOAT	grd_screen_ratio_mfloat
#define SCREEN_X_DIV_Y		grd_screen_x_div_y
#define SCREEN_INTERLACE	grd_screen_interlace
#else /* SCREEN_RES_FIXED */
#if defined(SCREEN_RES_VGA)
#define SCREEN_SIZE_X		640
#define SCREEN_SIZE_Y		480
#define SCREEN_SIZE_IY		(SCREEN_SIZE_Y)
#define SCREEN_CENTER_X		320
#define SCREEN_CENTER_Y		240
#define SCREEN_CENTER_IY	(SCREEN_CENTER_Y)
#define SCREEN_INTERLACE	0
#elif defined(SCREEN_RES_NTSC)
#define SCREEN_SIZE_X		640
#define SCREEN_SIZE_Y		448
#define SCREEN_SIZE_IY		(SCREEN_SIZE_Y/2)
#define SCREEN_CENTER_X		320
#define SCREEN_CENTER_Y		224
#define SCREEN_CENTER_IY	(SCREEN_CENTER_Y/2)
#define SCREEN_INTERLACE	1
#elif defined(SCREEN_RES_PAL)
#define SCREEN_SIZE_X		640
#define SCREEN_SIZE_Y		256
#define SCREEN_SIZE_IY		(SCREEN_SIZE_Y/2)
#define SCREEN_CENTER_X		320
#define SCREEN_CENTER_Y		128
#define SCREEN_CENTER_IY	(SCREEN_CENTER_Y/2)
#define SCREEN_INTERLACE	1
#endif
#define SCREEN_CENTER_POSX	2048
#define SCREEN_CENTER_POSY	2048
#define SCREEN_RATIO		2
#define SCREEN_RATIO_MFLOAT	0.5f
#define SCREEN_ZBUF_MIN		0x0000000UL
#define SCREEN_ZBUF_MAX		0x00fffffUL
#define SCREEN_X_DIV_Y		(0.75f)
#endif  /* SCREEN_RES_FIXED */

#define GDMA_PATH1	0
#define GRDRAW_PATH1	GDMA_PATH1
#ifdef USE_DRAWPATH_3
#define GDMA_PATH3	1
#define GRDRAW_PATH2	GDMA_PATH3
#else
#define GDMA_PATH3	0
#define GRDRAW_PATH2	GDMA_PATH1
#endif
#define GRDRAW_CONTEXT1	0
#define GRDRAW_CONTEXT2	1

typedef int __attribute__ ((mode (TI))) TItype;
typedef unsigned int __attribute__ ((mode (TI))) UTItype;
typedef int __attribute__((mode (TI))) long128;
typedef unsigned int __attribute__((mode (TI))) u_long128;
typedef long long long64;
typedef unsigned long long u_long64;

/* global variables */
extern int gri_resolution_mode;
extern int gri_resolution_x;
extern int gri_resolution_y;
extern int gri_grdrawpath1_dmabufsize;
extern int gri_grdrawpath2_dmabufsize;
extern int gri_dmalloc_mmapsize;
extern long gri_frame_ct;
extern int __grl_ps2_fdgenio;
extern char *__grl_ps2_genio_p;
extern int __grl_ps2_fddmamem;
extern char *__grl_ps2_dmamem_p;

/* variables for graphic data strem DMA */
extern unsigned int *__grl_ps2gdma_bufdata[2][2] __attribute__ ((aligned(16))); /* DMA Buffer */
extern unsigned int *__grl_ps2gdma_buf[2]        __attribute__ ((aligned(16))); /* Current writable pointer (Path-1/3) */
extern unsigned int *__grl_ps2gdma_buf_p;	/* Selected path pointer */
extern int __grl_ps2gdma_bufid;			/* Current buffer ID */
extern int __grl_ps2gdma_sysbuf;		/* Current setting draw path is system dma buffer ? */
#ifdef USE_DRAWPATH_3
extern int __grl_ps2gdma_path;			/* Current draw path number */
#else
#define __grl_ps2gdma_path	0
#endif
extern int __grl_ps2draw_context;		/* Current draw context number */
#ifdef REDUCE_DMATAG
extern int __grl_dma_ct[2];
extern unsigned int *__grl_dma_ptr[2];
#endif

/* GS double buffer definitions */
extern int __grl_ps2_gsoddeven;
extern int __grl_ps2_gsframe;
extern ps2_gs_dbuffdc __grl_ps2_gdb;
extern ps2_gs_finish __grl_ps2_gfinish;
extern int __grl_ps2_setdbuff_val;

void __grl_draw_init( void );
int grd_draw_setresolution( void );
void grd_draw_framestart( void );
void grd_draw_frameflip( void );

#endif /* __DRAW_H_INCLUDED */
