/* File: fire_sub.c */

#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "common.h"
#include "config_fire.h"
#include "main.h"
#include "draw.h"
#include "tex.h"
#include "matrix.h"
#include "geometry.h"
#include "prim.h"
#include "prim2d.h"
#include "prim3d.h"
#include "vpu1.h"
#include "fire.h"
#include "fire_sub.h"
#include "sprite.h"

static GRVector3 rotzero = { 0.0f, 0.0f, 0.0f };

#ifdef USE_FAKERAND
static int __rand_seed1 = 0;
static int __rand_seed2 = 0;

int inline static RAND( void )
{
	__rand_seed1 = __rand_seed1 * 311;
	__rand_seed2 = __rand_seed2 * 541 + 13427;
	//printf("%d\n", (__rand_seed1 + __rand_seed2) & RAND_MAX);
	return (__rand_seed1 + __rand_seed2) & RAND_MAX;
}
#endif

static GRVector4 fire1_vectors[3] = {
	{ FIRE_SPRITE_SIZE, FIRE_SPRITE_SIZE, 0.0f, 0.0f },
	{   0.0f,   0.0f, 1.0f, 0.0f },
	{   1.0f,   1.0f, 1.0f, 0.0f }
};

static int fire1_setup( void )
{
	int i, j, k, resttime, fire_num;
	GRVector4 rotvec, orgvec = { 0.0f, 0.0f, 0.0f, 0.0f };
	GRVector4 *col_p, nvec = { 0.0f, 0.0f, 1.0f, 1.0f };
	GRVector3 angles = { 0.0f, 0.0f, 0.0f };
	GRMatrix44 rot_matrix;
	FIRE_COMMON_STRUCT fcs, *fcp;
	FIRE1_STRUCT *fp;

#if 0
	fire_num = 0;
	for (i = 0; i < 16; i++) {
		for (j = 0; j < (16-(i-8)/2); j++) {
			fire_num++;
		}
	}
	TRACE("fire size = %d\n", fire_num);
#else
	fire_num = 260;
#endif

	memset( &fcs, 0, sizeof(fcs) );
	fcs.type = 1;
	fcs.n    = fire_num;
	fcs.max  = fire_num;
	fcs.tex  = (float)FIRE_TEXTURE_NUM*rand()/(RAND_MAX+1.0f);
	fcs.pasttime = 0;
	fcs.resttime = 3000;
#ifndef USE_FAKERAND
	fcs.pos.x = rand() % 1000 - 500;
	fcs.pos.y = rand() % 1000 - 500;
	fcs.pos.z = rand() % 1000 - 500;
#else
	fcs.pos.x = RAND() % 1000 - 500;
	fcs.pos.y = RAND() % 1000 - 500;
	fcs.pos.z = RAND() % 1000 - 500;
#endif
	fcs.pos.w = 0.0f;

	fcp = fire_new( &fcs, sizeof(FIRE1_STRUCT [fire_num]),
			sizeof(GRVector4 [fire_num * 2]) );
	if (!fcp)
		return FALSE;
	i = 0;
	j = 0;
	fp = fcp -> mem_p;
	for (k = 0; k < fire_num; k++) {
		j++;
		if (j >= 16-(i-8)/2) {
			j = 0;
			i++;
			if (i >= 16)
				i = 0;
		}
		col_p = &((GRVector4 *)(fcp -> dmem_p))[k*2+1];
#ifndef USE_FAKERAND
		col_p->x = 127.0f-32.0f*rand()/(RAND_MAX+1.0f);
		col_p->y = 127.0f-32.0f*rand()/(RAND_MAX+1.0f);
		col_p->z = 127.0f-32.0f*rand()/(RAND_MAX+1.0f);
		col_p->w = 127.0f-32.0f*rand()/(RAND_MAX+1.0f);
#else
		col_p->x = 127 - (RAND() & 31);
		col_p->y = 127 - (RAND() & 31);
		col_p->z = 127 - (RAND() & 31);
		col_p->w = 127 - (RAND() & 31);
#endif
		((GRVector4 *)(fcp -> dmem_p))[k*2] = nvec;
#ifndef USE_FAKERAND
		resttime = (int)(40.f+32.0f*rand() / (RAND_MAX+1.0f));
		angles.x = i*2.0f*((float)M_PI)/18.0f+(0.25f*(rand()/(RAND_MAX+1.0f))-0.125f);
		angles.y = j*2.0f*((float)M_PI)/(18.0f-(i/2))+(0.25f*(rand()/(RAND_MAX+1.0f))-0.125f);
		orgvec.z = 8.0f*rand()/(RAND_MAX+1.0f)+32.0f;
#else
		resttime = 40 + (RAND() & 31);
		angles.x = i*2.0f*((float)M_PI)/18.0f+(0.25f*(RAND()/(RAND_MAX+1.0f))-0.125f);
		angles.y = j*2.0f*((float)M_PI)/(18.0f-(i/2))+(0.25f*(RAND()/(RAND_MAX+1.0f))-0.125f);
		orgvec.z = 32 + (RAND() & 7);
#endif
		grm_rotmatrix44_vector3( &rot_matrix, &angles, GRM_XYZ );
		grm_vector4_m_matrix44( &rotvec, &orgvec, &rot_matrix );
		fp->resttime = resttime;
		fp->pasttime = 0;
		fp->move = rotvec;
		fp++;
	}
	return TRUE;
}

static void fire1_move( FIRE_COMMON_STRUCT *fcp )
{
	int i;
	float dotdot;
	FIRE1_STRUCT *fp;
	GRVector4 *col_p;

	fp = fcp -> mem_p;
	for (i = 0; i < fcp -> max; i++) {
		if (fp -> resttime <= 0) {
			fp++;
			continue;
		}
		dotdot = (float)((fp -> pasttime)*(fp -> pasttime))*0.003f;
		fp -> move.x *= 0.95f;
		fp -> move.y *= 0.95f;
		fp -> move.z *= 0.95f;
		grm_vector4_a_vector4( &((GRVector4 *)(fcp -> dmem_p))[i*2], &((GRVector4 *)(fcp -> dmem_p))[i*2], &(fp->move) );
		((GRVector4 *)(fcp -> dmem_p))[i*2].y += dotdot;
		(fp -> pasttime)++;
		--(fp -> resttime);
		col_p = &((GRVector4 *)(fcp -> dmem_p))[i*2+1];
		if (fp -> resttime <= 0) {
			--(fcp -> n);
			fp -> resttime = 0;
			col_p -> w = 0.0f;
		} else {
			if (fp -> resttime < 40)
				col_p -> w = (fp -> resttime) * 127.0f / 40.0f;
			else
				col_p -> w = 127.0f;
		}
		fp++;
	}
	return;
}

static void fire1_draw( FIRE_COMMON_STRUCT *fcp )
{
#ifndef USE_VPU1
	int i;
	FIRE1_STRUCT *fp;
	extern GRD_TEX_INFO texinfo[];

	fp = fcp -> mem_p;
	grg_setpos_hm( &fcp->pos, &rotzero );
	grd_tex_use( &texinfo[fcp->tex], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
	for (i = 0; i < fcp -> max; i++) {
		if (fp -> resttime <= 0)
			continue;
#ifdef USE_NOVPU1_POINT
		grd_3d_vpoint(
			&((GRVector4 *)(fcp -> dmem_p))[i*2],
			&((GRVector4 *)(fcp -> dmem_p))[i*2+1], GRDRAW_OPT_ALPHABLEND );
#else
		grd_3d_vsprite(
			&((GRVector4 *)(fcp -> dmem_p))[i*2],
			&((GRVector4 *)(fcp -> dmem_p))[i*2+1],
			&fire1_vectors[1], &fire1_vectors[2], &fire1_vectors[0],
			GRDRAW_OPT_ALPHABLEND );
#endif
	}
#else
	int i;
	FIRE1_STRUCT *fp;
	extern GRD_TEX_INFO texinfo[];
	int next_adr, n_data;

	fp = fcp -> mem_p;
	grg_setpos_hm( &fcp->pos, &rotzero );
	_gps2_tex_use_trans( &texinfo[fcp->tex], 0 );

	_gps2_setdma_vpudata_r_tag( 0, DMAsizeof(GRVector4)*(7+4) );
	/* 7 */
	_gps2_setdma_32323232( VPU1_ENTRY_MATRIX, 0, 0, 0 );
	_gps2_setdma_vpudata_body( &grg_screen,    DMAsizeof(GRMatrix44) );
	_gps2_setdma_vpudata_body( &grg_hm_scale,  DMAsizeof(GRVector4) );
	_gps2_setdma_vpudata_body( &grg_hm_offset, DMAsizeof(GRVector4) );
	/* 4 */
	_gps2_setdma_32323232( VPU1_ENTRY_DIRECT, 0, 0, 0 );
	_gps2_setdma_gif( 2, 1, GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) );
	_gps2_tex_use_notag( &texinfo[fcp->tex], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
	next_adr = 7+4;
#if USE_VPU1_SPRITE >= 3
	/* eof */
	_gps2_setdma_vpudata_r_tag( next_adr, DMAsizeof(GRVector4) );
	_gps2_setdma_32323232( VPU1_ENTRY_STOP, 0, 0, 0 );
	next_adr++;
	grd_ps2_vpu1_cont();
	next_adr = 0;
#endif

	for (i = 0; i < fcp -> max; i+=USE_VPU1_PACK1NUM) {
		n_data   = USE_VPU1_PACK1NUM;
		if (i+n_data > fcp -> max)
			n_data = fcp->max - i;
		if (i)
			next_adr = 0;

		/* 5 */
		_gps2_setdma_vpudata_r_tag( next_adr, DMAsizeof(GRVector4)*5 );
		_gps2_setdma_32323232( VPU1_ENTRY_SPRITE, 0, 0, 0 );
		_gps2_setdma_6464( GIF_NLOOP(n_data) | GIF_NREG(6) | GIF_PRE | GIF_FLG_PACKED |
			GIF_PRIM(GS_PRIM_SPRITE |
				GS_PRIM_TME |
				GS_PRIM_ABE |
				GS_PRIM_CTXT_1),
			GIF_REGS(GIF_REGS_ST,    0) |
			GIF_REGS(GIF_REGS_RGBAQ, 1) |
			GIF_REGS(GIF_REGS_XYZ2,  2) |
			GIF_REGS(GIF_REGS_ST,    3) |
			GIF_REGS(GIF_REGS_RGBAQ, 4) |
			GIF_REGS(GIF_REGS_XYZ2,  5) );
		_gps2_setdma_vpudata_body( fire1_vectors, DMAsizeof(GRVector4)*3 );
		next_adr += 5;

		/* vertex position and color */
		_gps2_setdma_vpudata_r( next_adr,
			&((GRVector4 *)(fcp -> dmem_p))[i*2],
			(n_data << 1) );
		next_adr += n_data << 1;

		/* eof */
		_gps2_setdma_vpudata_r_tag( next_adr, DMAsizeof(GRVector4) );
		_gps2_setdma_32323232( VPU1_ENTRY_STOP, 0, 0, 0 );
		next_adr++;
		grd_ps2_vpu1_cont();
	}
#endif
	return;
}

int fire_sub_setup( void )
{
	return fire1_setup();
}

int fire_sub_move( FIRE_COMMON_STRUCT *fcp )
{
	fire1_move( fcp );
	return TRUE;
}

int fire_sub_draw( FIRE_COMMON_STRUCT *fcp )
{
	fire1_draw( fcp );
	return TRUE;
}
