/* File: init.c

	Fireworks Demo v1.00

	Written by Toshio Fukui. (01/xx/2002 - 09/07/2002)
*/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>

#include "common.h"
#include "main.h"
#include "memory.h"
#include "fileio.h"
#include "input.h"
#include "geometry.h"
#include "draw.h"
#include "tex.h"
#include "font.h"
#include "debug.h"

const char *mes_c =
	" Fireworks Demo v1.00 for PS2 Linux "
	" Written by Toshio Fukui. ";

#ifdef USE_PHSYADR_DMA
int __grl_ps2_fdgenio = -1;
char *__grl_ps2_genio_p = MAP_FAILED;
#endif
int __grl_ps2_fddmamem = -1;
char *__grl_ps2_dmamem_p = MAP_FAILED;

void grinit( void )
{
	/* General I/O mapping */
#ifdef USE_PHSYADR_DMA
	__grl_ps2_fdgenio = open( PS2_DEV_GENIO, O_RDWR );
	if (__grl_ps2_fdgenio < 0) {
		ERRMSG(PS2_DEV_GENIO " open() error\n");
		EXIT(1);
	}
	if (flock(__grl_ps2_fdgenio, LOCK_EX | LOCK_NB) < 0) {
		ERRMSG(PS2_DEV_GENIO " flock() error\n");
		close(__grl_ps2_fdgenio);
		EXIT(1);
	}
	__grl_ps2_genio_p = mmap( 0, 0x4000000,
		PROT_READ | PROT_WRITE, MAP_PRIVATE, __grl_ps2_fdgenio, 0 );
	if (__grl_ps2_genio_p == MAP_FAILED) {
		ERRMSG(PS2_DEV_GENIO " mmap() error\n");
		close(__grl_ps2_fdgenio);
		EXIT(1);
	}
#endif

	/* DMA memory mapping */
	__grl_ps2_fddmamem = open( PS2_DEV_MEM, O_RDWR );
	if (__grl_ps2_fddmamem < 0) {
		ERRMSG(PS2_DEV_MEM " open() error\n");
		EXIT(1);
	}
	if (flock(__grl_ps2_fddmamem, LOCK_EX | LOCK_NB) < 0) {
		ERRMSG(PS2_DEV_MEM " flock() error\n");
		close(__grl_ps2_fddmamem);
		EXIT(1);
	}

#ifdef USE_PHSYADR_DMA
	__grl_ps2_dmamem_p = mmap( 0, PS2_RESERVE_MEMORY_SIZE,
#else
	__grl_ps2_dmamem_p = mmap( 0, gri_dmalloc_mmapsize,
#endif
		PROT_READ | PROT_WRITE, MAP_PRIVATE, __grl_ps2_fddmamem, 0 );
	if (__grl_ps2_dmamem_p == MAP_FAILED) {
		ERRMSG(PS2_DEV_MEM " mmap() error\n");
		close(__grl_ps2_fddmamem);
		EXIT(1);
	}

	__grm_init();
	__grg_init();
	__grl_draw_init();
	__grl_debug_init();
	__grl_tex_init();
	__grd_font_init();
	__grp_memory_init();
	__grp_fileio_init();
	__grp_gameport_init();
	return;
}

void help( void )
{
	fprintf(stderr, "Fireworks Demo v1.00 written by Toshio Fukui\n\n");
	fprintf(stderr, "usage: fireworks [-vesa | -ntsc | -pal] [-nointer]\n");
	return;
}

int main( int argc, char **argv )
{
	int i, div_flag = FALSE;

	gri_resolution_mode = GRD_RESOLUTIONMODE_VESA;
	for (i = 1; i < argc; i++) {
		if (!strcasecmp( argv[i], "-nointer" ))
			div_flag = TRUE;
		else if (!strcasecmp( argv[i], "-vesa" ))
			gri_resolution_mode = GRD_RESOLUTIONMODE_VESA;
		else if (!strcasecmp( argv[i], "-ntsc" ))
			gri_resolution_mode = GRD_RESOLUTIONMODE_NTSC;
		else if (!strcasecmp( argv[i], "-pal" ))
			gri_resolution_mode = GRD_RESOLUTIONMODE_PAL;
		else {
			help();
			return 1;
		}
	}
	if (gri_resolution_mode == GRD_RESOLUTIONMODE_VESA) {
		gri_resolution_x = 640;
		gri_resolution_y = 480;
	} else if (gri_resolution_mode == GRD_RESOLUTIONMODE_NTSC) {
		gri_resolution_x = 640;
		gri_resolution_y = 448 / (div_flag + 1);
	} else {
		gri_resolution_x = 640;
		gri_resolution_y = 512 / (div_flag + 1);
	}

	/* initialize GRENDSYS */
	gri_grdrawpath1_dmabufsize = 5*1024*1024;
	gri_grdrawpath2_dmabufsize = 32*1024;
	gri_dmalloc_mmapsize = 16*1024*1024;
	strcpy( gri_default_fontpath, "texdata/font.bmp" );

	grinit();
	prog_init();
	while (1)
		prog_main();
	return 0;
}
