# config.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg module implementing the application configuration hooks.
#
# -----------------------------------------------------------------------------
#
# $Id: config.sh,v a57bbf0187da 2020/08/20 16:29:01 keith $
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2011, 2013, 2017, 2018, 2020, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
# ANSI terminal control sequences to select/reset bold output...
#
  bold="`echo '^[[1m' | tr -s '^[' '\033['`"
  unbold="`echo '^[[30;0m' | tr -s '^[' '\033['`"

# ...and for selecting coloured output for diagnostic messages.
#
  error_colour="`echo '^[[31;1m' | tr -s '^[' '\033['`"
  warning_colour="`echo '^[[31m' | tr -s '^[' '\033['`"

# Use them, to implement the diagnostic message functions.
#
  warning() { echo >&2 "$warning_colour$cmd: *** WARNING *** $@$unbold"; }
  error() { echo >&2 "$error_colour$cmd: *** ERROR *** $@$unbold"; }

# Configure the core application functionality.
#
  for name in actions options; do require module $name; done

# Accept user specified customisation.
#
  test -f "$HOME/.${cmd}rc" && . "$HOME/.${cmd}rc" || true

# Reload any locally saved configuration overrides; if the configuration
# directory exists, take care that a failed glob match doesn't lure us into
# an attempt to parse a non-existent script named "*.sh".
#
  test -d .$cmd && {
    for name in .$cmd/*.sh; do test -f "$name" && . "$name"; done
  } || true
#
# -----------------------------------------------------------------------------
# $RCSfile: config.sh,v $: end of file
