# porthelp.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg module implementing the mingw-port built-in help displays.
#
# -----------------------------------------------------------------------------
#
# $Id: porthelp.sh,v 53f4b6a40196 2020/08/21 14:28:25 keith $
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2020, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
  for help_class in all synopsis options actions
  do case $help_class in ${optarg-"all"}*) optarg=$help_class;; esac
  done

  help_synopsis() { cat <<-ETX
	Usage: ${cmd="mingw-port"} [OPTIONS] package-version

	Download and build the <package-version> package, as directed by the
	corresponding mingw-port specification.

	ETX
      }

  help_options() { cat <<-ETX
	Options:
	  -h, --help[=class]	Display help, and exit; "class" is any one of:--
	 	synopsis	Show only the command synopsis.
	 	options		Show the synopsis, and summary of options.
	 	all		Show the full "help" display; (this is the default).

	  --licence		Display the $cmd licence, and exit.
	  --license		A synonym for "--licence".

	  -V, --version		Display the $cmd version, and exit.

	  -R, --repository=URL	Specify the URL whence mingw-port specification
	 			files may be downloaded; (if unspecified, defaults
	 			to https://osdn.net/dl/mingw/mingw-ports).

	  -P, --ports=dir	Specify a directory for local storage of mingw-port
	 			specification files; mingw-port will always search
	 			in the current working directory, followed by "dir",
	 			if specified, and finally in the internet repository
				specified by "-R URL", (or its built-in default); if
	 			the specification is found locally, the search stops
	 			immediately; otherwise, if the file is downloaded
	 			from the internet, and "-P dir" is specified, a copy
	 			will be stored in "dir", for future use.

	  -C, --cache-dir	Specify a local directory for persistent storage of
	 			downloaded packages; (if unspecified, any downloaded
				package files will be deleted, after unpacking).

	  -D, --depot=dir	Specify the root of the local mingw-port download
	 			and build directory tree; (if unspecified, defaults
	 			to the current working directory).

	  --download-only	Download, and prepare the specified package source
	 			for building, but do not apply any patches from the
	 			mingw-port, or proceed to build the package.

	  --in-tree		Build the package within its source tree; (if this
	 			is unspecified, mingw-port will attempt to build
	 			the package in the current working directory; if
	 			--download-only is also specified, --in-tree will
	 			be ignored).

	  Note that mandatory "dir", and "URL", arguments for long-form options are
	  also required when specifying the corresponding short-form option.

	ETX
      }

  case $optarg in
    synopsis) help_$optarg;;
    options) help_synopsis; help_$optarg;;
    all) help_synopsis; help_options;;
    *) die 1 "unknown help category '$optarg'";;
  esac

  exit 0
#
# -----------------------------------------------------------------------------
# $RCSfile: porthelp.sh,v $: end of file
