static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************************************/
/*  ֐                                                                   */
/*        int   ak_tr_packet_analize()                                          */
/*                                                                           */
/*                                                                     */
/*                                                                           */
/*                                                                           */
/*  ߂l                                                                   */
/*        0                  : I@@@                                */
/*        -1                 : ُI@@@                                */
/*        D_PRC_TERM         : vZXI˗M                          */
/*                                                                           */
/*  Tv                                                                 */
/*        pPbg̉͏                                                 */
/*****************************************************************************/
#include "trmm.h"

extern int ak_tr_term_close_timer();
static int ak_tr_check_sd();

int ak_tr_packet_analize( )
{
	short sCommand;
	int irc,iTerm=0;
	pRC_PACKET_TABLE pRcNext;
	pCOMM_PACK_HEAD pHead;

	/* Mpe[u */
	while (pRcNext = (pRC_PACKET_TABLE)akxs_rb_get_n(gp_rb_rctl)) {
		pHead = (pCOMM_PACK_HEAD)(pRcNext->sp_content);
		sCommand = ntohs(pHead->cph_prt.prt_cmnd);

DEBUGOUTL1(AKBP_LOG_GROUP|250,"ak_tr_packet_analize: Command = %d",sCommand);

		ak_tr_trace(0,pHead);
		aka_statistics_count(0,pRcNext->sp_len);
		switch( sCommand ) {
			case CM_CMD_CLT_DELETE :
				ak_tr_analiz_delete(pRcNext->sp_ch,sCommand,pHead);
				break ;
			case CM_CMD_SHUT   :
			case CM_CMD_FSHUT  :
				irc = ak_tr_analiz_shut(sCommand, pRcNext);
				if ( irc == D_PRC_TERM )
					iTerm = sCommand ;
				pRcNext = NULL;
				break ;
			case CM_CMD_TRM_QUERY  :
			case AKB_CMD_NOTIFY  :
				aka_dispatch(pRcNext);
				pRcNext = NULL;
				break ;
			case CM_CMD_SEND  :
				ak_tr_analiz_etc(pRcNext);
				pRcNext = NULL;
				break ;
			default :
				ERROROUT(ak_tr_conv_msg(2104));
				irc = akb_set_rb_pack_err_cd(pRcNext->sp_ch,pHead,gp_rb_wctl,
				                        D_ERR_UNKNOWN_CMD);
				if (!irc) {
					ak_tr_trace(1,pRcNext->sp_content);
					pRcNext->sp_content = NULL;
				}
		}
		if (pRcNext) {
			if (pRcNext->sp_content) Free(pRcNext->sp_content);
			Free(pRcNext);
		}
	}

	if (iTerm) return iTerm;

	return 0;
}

/*****************************************************************************/
/*  ֐                                                                   */
/*        int   ak_tr_analiz_shut()                                             */
/*                                                                           */
/*                                                                     */
/*        pRC_PACKET_TABLE     pRcCurrent   :  MpPbg                    */
/*        pSD_PACKET_TABLE    *pSdCurrent   :  MpPbg̃AhX          */
/*                                                                           */
/*                                                                           */
/*  ߂l                                                                   */
/*        0                  : ُ@@                                  */
/*        D_ERR_MEM_ALLOC    : [AP[VEG[                */
/*        D_PRC_TERM         : vZXI                                  */
/*                                                                           */
/*  Tv                                                                 */
/*        I˗@                                                 */
/*****************************************************************************/
int ak_tr_analiz_shut(sCommand, pRcCurrent)
short sCommand;
pRC_PACKET_TABLE pRcCurrent;
{
	pSD_PACKET_TABLE     pNew;
	pCOMM_PACK_HEAD      pHead;
	pCOMM_PACK_HEADB     pHeadB;
	int		iSd;
	int		irc;
	int     i,iSrc;
	uchar ucShutMode[2];


#ifdef DEBUG
printf(" ak_tr_analiz_shut  : start\n");
#endif

	irc = 0;
	pHead = ( pCOMM_PACK_HEAD)pRcCurrent->sp_content ;
	pHeadB = ( pCOMM_PACK_HEADB)pRcCurrent->sp_content ;
	if ( ntohs(pHead->cph_sinf.ind_prid) > gi_prid_term_base ) {
		/* [M */
		/* ˗pPbg */
#if 1
		irc = -1;
#else
		pNew = pRcCurrent;
#ifdef OLD_SHUT
		pNew->iSd = iPrMnSd ;
#else
		akb_exchg_indicate(pHead);
		pHead->cph_sinf.ind_pano = htons(-1);
#endif
		akxs_rb_set_n(gp_rb_wctl,pNew);
#endif
	}
	else {
		if (ntohs(pHead->cph_sinf.ind_prid) == D_PRID_PROM) {
			if ( pHead->cph_sinf.ind_thrd != 0 ) {
				ak_tr_post_shut_all(sCommand);
				akb_exchg_indicate(pHead);
			/*
				pRcCurrent->sp_ch = 0 ;
				akxs_rb_set_n(gp_rb_wctl,pRcCurrent);
			*/
#ifdef	DEBUG
printf("[akTrAna] shut command to terminal\n");
#endif
				aka_set_shut_packet(pHead);
				if (sCommand == AKB_CMD_SHUT) ucShutMode[0] = 1;
				else ucShutMode[0] = 2;
				aka_shut_control(AKA_SHUT_MODE,ucShutMode);
			/*	return D_PRC_TERM ;	*/
				irc = D_PRC_TERM ;
			}
		}
		else {
				/* ShutR}h̃G[pPbg */
#if 1
				irc = -1;
#else
	    		pNew = pRcCurrent;
				memcpy(pNew->sp_content,(char *)pHead,sizeof(tdtCOMM_PACK_HEAD));
				pNew->sp_len = sizeof(tdtCOMM_PACK_HEAD) ;
				akxs_rb_set_n(gp_rb_wctl,pNew);
#endif
		}
	}
	if (irc == -1) {
		/* G[pPbg˗ɑM */
		iSrc = pRcCurrent->sp_srcch - 1;
		if (akb_set_rb_pack_err_cd(iSrc,pHead,gp_rb_wctl,-1)) {
			/* xOt@CɋL^ */
			ERROROUT1("G[pPbgMG[. to proc=%d",
					ntohs(pHead->cph_sinf.ind_prid));
		}
		else {
			ak_tr_trace(1,pHead);
			pRcCurrent->sp_content = NULL;
		}
	}
	if (pRcCurrent) {
		if (pRcCurrent->sp_content) Free(pRcCurrent->sp_content);
		Free(pRcCurrent);
	}
	return irc;
}

/**********************************************************/
/*                                                        */
/* S[֏Iʒms                                 */
/*                                                        */
/**********************************************************/
int ak_tr_post_shut_all(sCommand)
short sCommand;
{
	int i,max=gi_regist_term_size;
	pTERM_TABLE pT;

	pT = gp_term_tbl;
	for (i=0;i<max;i++,pT++) {
		if (pT->sd > 0) {
			ak_tr_post_shut_packet(i+1,pT->rsv,sCommand,pT->trm_id);
			pT->expire_time = -1;
			pT->regist    = D_CANCELED;
		}
	}
	return 0;
}

int ak_tr_post_shut_packet(iCh,ucVer,sCommand,usTrmId)
int   iCh;
uchar ucVer;
short sCommand;
ushort usTrmId;
{
	pSD_PACKET_TABLE     pNew;
	pCOMM_PACK_HEAD      pHead;
	pCOMM_PACK_HEADB     pHeadB;

	pNew = akb_packet_tbl_new(sizeof(tdtCOMM_PACK_HEAD));
	if ( pNew == NULL ) {
		ERROROUT1("PacketTblMake error. for proc=%d",usTrmId);
		return D_ERR_MEM_ALLOC ;
	}
	if (ucVer == 'C') {
		pHead = (pCOMM_PACK_HEAD )pNew->sp_content ;
		pHead->cph_prt.prt_ver       = 'C' ;
		pHead->cph_prt.prt_send = 0 ;
		pHead->cph_prt.prt_cmnd   = htons(sCommand);
		pHead->cph_sinf.ind_hoid     = htonl(gl_my_host_id);
		pHead->cph_sinf.ind_clid   = 0 ;
		pHead->cph_sinf.ind_prid = htons(D_PRID_TERM);
		pHead->cph_sinf.ind_thrd    = 1 ;
		pHead->cph_sinf.ind_disp    = 1 ;
		pHead->cph_sinf.ind_pano   = htons(gui_total_packets++);
		pHead->cph_dinf.ind_hoid    = htonl(gl_my_host_id);
		pHead->cph_dinf.ind_clid   = 0 ;
		pHead->cph_dinf.ind_prid = htons(usTrmId);
		pHead->cph_dinf.ind_thrd    = 0 ;
		pHead->cph_dinf.ind_disp    = 0 ;
		pHead->cph_dinf.ind_pano   = 0 ;
		pHead->cph_plen            = 0 ;
	}
	else {
		pHeadB = (pCOMM_PACK_HEADB )pNew->sp_content ;
		pHeadB->phb_prt.prt_ver       = 'B' ;
		pHeadB->phb_prt.prt_send = 0 ;
		pHeadB->phb_prt.prt_cmnd   = htons(sCommand);
		pHeadB->phb_sind.inb_hoid     = htonl(gl_my_host_id);
		pHeadB->phb_sind.inb_prid  = htonl(D_PRID_TERM);
		pHeadB->phb_sind.inb_pkid   = htonl(gui_total_packets++);
		pHeadB->phb_dind.inb_hoid    = htonl(gl_my_host_id);
		pHeadB->phb_dind.inb_prid = htonl((INT4)usTrmId);
		pHeadB->phb_dind.inb_pkid  = 0 ;
		pHeadB->phb_plen           = 0 ;
	}
	pNew->sp_len   = sizeof(tdtCOMM_PACK_HEAD);
	pNew->sp_ch    = iCh;
	pNew->sp_offset = 0;	/* add 97.12.1 Koba */
	akxs_rb_set_n(gp_rb_wctl,pNew);
	ak_tr_trace(1,pNew->sp_content);

	return 0;
}

/*****************************************************************************/
/*  ֐                                                                   */
/*        int   ak_tr_analiz_etc()                                              */
/*                                                                           */
/*                                                                     */
/*        pRC_PACKET_TABLE     pRcCurrent   :  MpPbg                    */
/*        pSD_PACKET_TABLE    *pSdCurrent   :  MpPbg̃AhX          */
/*                                                                           */
/*                                                                           */
/*  ߂l                                                                   */
/*        0                  : @@                                  */
/*        -1                 : ُ@@                                  */
/*        D_ERR_MEM_ALLOC    : [AP[VEG[                */
/*                                                                           */
/*  Tv                                                                 */
/*        ʏWzM  @                                                 */
/*****************************************************************************/
int   ak_tr_analiz_etc( pRcCurrent )
pRC_PACKET_TABLE     pRcCurrent;
{
	pSD_PACKET_TABLE     pNew, pOld;
	tdtCOMM_PACK_HEAD     *pHead,tHead,*pH;
	tdtCOMM_PACK_HEADA    *pHA;
	int	 iSrcSd, iSrc, iDst, iRc, iHSize, iAPSysHid;
	INT4 /*lFromHid,*/ lToHid, lPackLen;
	char *pPacket,cver;
	ushort usAPSysId=0;

	pNew = pRcCurrent;
	pH = pHead = (pCOMM_PACK_HEAD)(pNew->sp_content) ;
	if ((cver=pHead->cph_prt.prt_ver) == 'A') {
		pHA = (tdtCOMM_PACK_HEADA *)pHead;
		usAPSysId = pHA->pha_dinf.ina_apid;
		akb_get_head_from_a(&tHead,pHA);
		pHead = &tHead;
		cver = 'C';
		iAPSysHid = usAPSysId;
	}
	else {
		iAPSysHid = ntohl(pHead->cph_dinf.ind_hoid);
	}

	iSrc = pNew->sp_srcch - 1;
	if ((iDst=ak_tr_get_entry(pH)) == -3) {
		ak_tr_broad_cast(pNew);
		Free(pNew->sp_content);
		Free(pNew);
		return 0 ;
	}
	else if (iDst < 0) {
		PRINTOUT1(ak_tr_conv_msg(2302),ntohs(pHead->cph_dinf.ind_prid));
		/* G[pPbg˗ɑM */
		if (akb_set_rb_pack_err_cd(iSrc,pH,gp_rb_wctl,
		                      C_ERR_TERM_OFFSET+D_ERR_NO_PROCESS)) {
			/* xOt@CɋL^ */
			ERROROUT1("G[pPbgMG[. to proc=%d",
					ntohs(pHead->cph_sinf.ind_prid));
			Free(pNew->sp_content);
		}
		else ak_tr_trace(1,pNew->sp_content);
		Free(pNew);
		return 0 ;
	}
	else {
		pNew->sp_ch = iDst;
	}
	if (!(lToHid = ntohl(pHead->cph_dinf.ind_hoid))) lToHid = gl_my_host_id;
	if ((iAPSysHid==gl_my_host_id || iAPSysHid == gi_my_apsys_hid) &&
	    ntohs(pHead->cph_dinf.ind_prid)==gi_my_proc_id) {
		aka_dispatch(pRcCurrent);
		return 0;
	}
	akxs_rb_set_n(gp_rb_wctl, pNew);
	ak_tr_trace(1,pNew->sp_content);
	return 0 ;
}

/***********
 *
 ***************/
int ak_tr_query(tpRecvMsg,tpCmdCnv)
AKAMSGCOM *tpRecvMsg;
tdtCMD_CNV *tpCmdCnv;
{
	unsigned short usProcId = tpCmdCnv->cmc_prno;
	pCOMM_PACK_HEAD   pHead;
	pSD_PACKET_TABLE  pNew;
	int i,l,rc,len,pos;
	char *p,*b,temp[D_RECORD_BUFSIZE],*pw;
	unsigned char *ph;
	int	iSd,iDst,max=gi_regist_term_size;
	INT4 lHid_n;
	pTERM_TABLE pT;

	/* tCmdCnv.cpDataɃf[^Ƃ́ASoCgJ */
	len = sizeof(tdtCOMM_PACK_HEAD)+(gi_regist_term_size+3)*36+4;
	pT = gp_term_tbl;
	for(i=0;i<max;i++,pT++) {
		if (pT->sd>0) {
			if (pw=pT->term_info) len += strlen(pw) + 1;
		}
	}
/*
printf("Query:malloc len=%d\n",len);
*/
	p = Malloc(len);
	if (p) {
		tpCmdCnv->cmc_data = p;
	}
	else {
		ERROROUT("ak_tr_query:malloc error");
		return (D_ERR_MEM_ALLOC);
	}
	b = p + 4;
	pos = 4;
	strcpy(b,"*** Terminal Table ***\nEntry Socket TremID Host ID\n----- ------ ------ ---------------\n");
	l = strlen(b);
	b += l;
	pos += l;
	pT = gp_term_tbl;
	for (i = 0 ; i < max ; i++, pT++) {
		if ( pT->sd > 0) {
			lHid_n = htonl(pT->host_id);
			ph = (unsigned char *)&lHid_n;
			sprintf(b,"%5d%7d%7d %3d.%3d.%3d.%3d",i,pT->sd,pT->trm_id,(int)*ph,(int)*(ph+1),(int)*(ph+2),(int)*(ph+3));
		/*	LOGOUT(b);	*/
			l = strlen(b);
			b += l;
			pos += l;
			if (pw=pT->term_info) {
				l = strlen(pw) + 1;
				*b = ' ';
				memcpy(b+1,pw,l);
			}
			else l = 0;
			memcpy(b+l,"\n",2);
			b += ++l;
			pos += l;
		}
	}
	tpCmdCnv->cmc_dlen = pos + 1;
	return (0);
}

int ak_tr_proc_id_to_entry(lHostId,usProcId)
INT4 lHostId;
unsigned short usProcId;
{
	int i,iAPSysHid,max;
	int iAPSysId = 0;
	pTERM_TABLE pT;

	if (lHostId == 0) lHostId = gl_my_host_id ;
	else if (!(lHostId & 0xffff0000)) iAPSysId = lHostId;

	if (lHostId!=gl_my_host_id && lHostId!=gi_my_apsys_hid) return 0;
	if (usProcId > AKB_PID_MAX) {
		if (usProcId & AKB_BCO_SERV) return 0;
		else if (usProcId & AKB_BCO_TERM) return -3;
		return -1;
	}
	else if (usProcId>gi_prid_term_base && usProcId<=AKB_PID_MAX) {
		max = gi_regist_term_size;
		pT = gp_term_tbl;
		for (i=0;i<max;i++,pT++) {
			if (pT->sd>0 && usProcId==pT->trm_id) {
				return i+1;
			}
		}
	}
	else {
		return 0;
	}
	return -1;
}

int ak_tr_hpato_entry(lHostId,iProcId,iAPSysId)
INT4 lHostId;
int  iProcId,iAPSysId;
{
	int i;

	if (lHostId == D_HID_BROADCAST) return 0;
	if (iAPSysId == gus_my_apsys_id)
		i = ak_tr_proc_id_to_entry(lHostId,iProcId);
	else i = 0;
	return i;
}

int ak_tr_get_entry (pHead)
pCOMM_PACK_HEAD      pHead;
{
	pCOMM_PACK_HEADA pHA;
	int i;
	INT4   lHostId;
	ushort usProcId,usAPSysId;

	if (pHead->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pHead;
		lHostId   = ntohl(pHA->pha_dinf.ina_hoid);
		usProcId  = ntohs(pHA->pha_dinf.ina_prid);
		usAPSysId = ntohs(pHA->pha_dinf.ina_apid);
		i = ak_tr_hpato_entry(lHostId, usProcId, usAPSysId);
	}
	else {
		lHostId   = ntohl(pHead->cph_dinf.ind_hoid);
		usProcId  = ntohs(pHead->cph_dinf.ind_prid);
		usAPSysId = 0;
		i = ak_tr_proc_id_to_entry(lHostId,usProcId);
	}
	if (i == -1)
		ERROROUT4("*** No Dest Process ver=%c HostId=%08x ProcId=%d APSysId=%d",
		          pHead->cph_prt.prt_ver,lHostId,usProcId,usAPSysId);
DEBUGOUTL5(AKBP_LOG_GROUP|250,
"ak_tr_get_entry:ver=%c lHostId=%08x usProcId=%d usAPSysId=%d i=%d",
pHead->cph_prt.prt_ver,lHostId,usProcId,usAPSysId,i);
 	return i;
}
#ifdef NO_SRC_CH
int akTrGetSrcEntry (pHead)
pCOMM_PACK_HEAD      pHead;
{
	pCOMM_PACK_HEADA pHA;
	int i;
	INT4   lHostId;
	ushort usProcId,usAPSysId;

	if (pHead->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pHead;
		lHostId   = ntohl(pHA->pha_sinf.ina_hoid);
		usProcId  = ntohs(pHA->pha_sinf.ina_prid);
		usAPSysId = ntohs(pHA->pha_sinf.ina_apid);
		i = ak_tr_hpato_entry(lHostId, usProcId, usAPSysId);
	}
	else {
		lHostId   = ntohl(pHead->cph_sinf.ind_hoid);
		usProcId  = ntohs(pHead->cph_sinf.ind_prid);
		usAPSysId = 0;
		i = ak_tr_proc_id_to_entry(lHostId,usProcId);
	}
	if (i == -1)
		ERROROUT4("*** No Src Process ver=%c HostId=%08x ProcId=%d APSysId=%d",
		          pHead->cph_prt.prt_ver,lHostId,usProcId,usAPSysId);
DEBUGOUTL5(AKBP_LOG_GROUP|250,
"akTrGetSrcEntry:ver=%c lHostId=%08x usProcId=%d usAPSysId=%d i=%d",
pHead->cph_prt.prt_ver,lHostId,usProcId,usAPSysId,i);
	return i;
}
#endif
static int ak_tr_check_sd(iSd)
int iSd;
{
	tdtCOMM_PACK_HEAD Head;
	fd_set  readfds;
	struct  timeval tm;
	int rc;

	if (iSd<0 || iSd>=FD_SETSIZE) return -1;
	tm.tv_sec  = 0;
	tm.tv_usec = 0;
	akb_fd_zero( &readfds  );
	akb_fd_set( iSd, &readfds );
	rc = select( akb_fd_setsize(), &readfds, NULL, NULL, &tm );
	if( rc < 0 ) {
		ERROROUT2("select error. errno = %d %s",errno,strerror(errno));
		return -1;
	}
	else if (rc == 0) return 0;
	rc = sk_nolp_read(iSd,&Head,sizeof(tdtCOMM_PACK_HEAD));
	if (rc == sizeof(tdtCOMM_PACK_HEAD)) ak_tr_trace(0,&Head);
	return rc;
}

int ak_tr_trace(iRW,cpPacket)
int iRW;
char *cpPacket;
{
/*
*	return akb_trace(guc_trace,D_TRLOGFILE,iRW,cpPacket);
*/
	return akb_trace_out(iRW,cpPacket);
}

int ak_tr_request(usProcId,sCommand)
ushort usProcId;
short  sCommand;
{
	pSD_PACKET_TABLE pNew;
	tdtCOMM_PACK_HEAD  Head, *pHead;
	ushort  *usp;
	short  sEvent, sw[4];
	int i, len;

DEBUGOUT2("ak_tr_request:usProcId=%d,sCommand=%d",usProcId,sCommand);
	len = 8;
	Head.cph_prt.prt_ver        = 'C' ;
	Head.cph_prt.prt_send  = 0 ;
	Head.cph_prt.prt_cmnd    = htons(AKB_CMD_SEND);
	Head.cph_sinf.ind_hoid      = htonl(gl_my_host_id);
	Head.cph_sinf.ind_clid    = 1 ;
	Head.cph_sinf.ind_prid  = htons(D_PRID_TERM);
	Head.cph_sinf.ind_thrd     = 1 ;
	Head.cph_sinf.ind_disp     = 0 ;
	Head.cph_sinf.ind_pano    = 0;
	Head.cph_dinf.ind_hoid     = htonl(gl_my_host_id);
	Head.cph_dinf.ind_clid   = htons(AKA_CLASS_NOTIFY);
	Head.cph_dinf.ind_prid = 0;
	Head.cph_dinf.ind_thrd    = 0 ;
	Head.cph_dinf.ind_disp    = AKB_AKO_NOREPLY;
	Head.cph_dinf.ind_pano   = 0 ;
	Head.cph_plen            = htonl(len);

	sw[0] = htons(sCommand);
	sw[1] = htons(usProcId);
	sw[2] = 0;
	sw[3] = 0;

	for (i=0;i<gi_req_tbl_size;i++) {
		sEvent = gp_req_tbl[i].event;
DEBUGOUT4("ak_tr_request:i=%d usProcId=%d sCommand=%d sEvent=%d",i,gp_req_tbl[i].proc_id,gp_req_tbl[i].command,sEvent);
		if (gp_req_tbl[i].proc_id &&
		    gp_req_tbl[i].command == AKB_CMD_NOTIFY &&
		    ((sCommand == AKB_CMD_REGIST && (sEvent & 0x01)) ||
		     (sCommand == AKB_CMD_DELETE && (sEvent & 0x02)))  ) {

			pNew = akb_packet_tbl_new(sizeof(tdtCOMM_PACK_HEAD)+len);
			if (pNew) {
				pHead = (pCOMM_PACK_HEAD )pNew->sp_content ;
				memcpy(pHead,&Head,sizeof(tdtCOMM_PACK_HEAD));
				pHead->cph_sinf.ind_pano    = htons(gui_total_packets++);
				pHead->cph_dinf.ind_prid = htons(gp_req_tbl[i].proc_id);
				memcpy(pHead+1,sw,len);
				pNew->sp_len   = sizeof(tdtCOMM_PACK_HEAD) + len;
				pNew->sp_ch    = 0;
				pNew->sp_offset = 0;
				akxs_rb_set_n(gp_rb_wctl,pNew);
			}
			else ERROROUT1("PacketTblMake error. for proc=%d", usProcId);
		}
	}
	return 0;
}

int ak_tr_request_class(tpRecvMsg,tpCmdCnv)
AKAMSGCOM *tpRecvMsg;
tdtCMD_CNV *tpCmdCnv;
{
	static char *fmt = "ak_tr_requestClas: %s Request ProcId=%d Command=%d Event=%d";
	unsigned short usProcId = tpCmdCnv->cmc_prno;
	short sCommand = tpCmdCnv->cmc_scmd;
	unsigned short usSrcProcId;
	unsigned char ucCmd, ucFlg;
	int  i, iFound, iEmpty;
	char *msg;

	usSrcProcId = tpRecvMsg->msg_prid;
PRINTOUT2("ak_tr_requestClas: Recv request = 0x%04x from proc=%d",usProcId,usSrcProcId);
	ucCmd = usProcId>>8;
	if (ucCmd) {
		ucFlg = usProcId & 0x00ff;
		iFound = iEmpty = -1;
		for (i=0;i<gi_req_tbl_size;i++) {
			if (gp_req_tbl[i].proc_id == usSrcProcId &&
			    gp_req_tbl[i].command == ucCmd) iFound = i;
			if (!gp_req_tbl[i].proc_id) iEmpty = i;
		}
DEBUGOUT2("ak_tr_requestClas: iFound=%d iEmpty=%d",iFound,iEmpty);
		msg = "Registed";
		if (iFound >= 0) {
			if (ucFlg) {
				gp_req_tbl[iFound].event   = ucFlg;
			}
			else {
				gp_req_tbl[iFound].proc_id = 0;
				msg = "Canceled";
			}
			PRINTOUT4(fmt,msg,usSrcProcId,gp_req_tbl[iFound].command,gp_req_tbl[iFound].event);
		}
		else if (iEmpty>=0 && ucFlg) {
			gp_req_tbl[iEmpty].proc_id = usSrcProcId;
			gp_req_tbl[iEmpty].command = ucCmd;
			gp_req_tbl[iEmpty].event   = ucFlg;
			PRINTOUT4(fmt,msg,usSrcProcId,ucCmd,ucFlg);
		}
	}
	tpCmdCnv->cmc_dlen = -1;
	return 0;
}

/***********
 *
 ***************/
int ak_tr_notify(tpRecvMsg,tpCmdCnv)
AKAMSGCOM *tpRecvMsg;
tdtCMD_CNV *tpCmdCnv;
{
	ushort *usp,usEvent,usProcId;
	int  len,iRc,i;
	INT4 lw;

	if ((len=tpRecvMsg->msg_mlen) < 0) return 0;
	usp = (ushort *)(tpRecvMsg->msg_pmsg+sizeof(INT4));
	usEvent  = ntohs(*usp++);
	usProcId = ntohs(*usp++);
	len -= 4;
	if (len<4) iRc = 0;
	else {
		memcpy(&lw,usp,sizeof(INT4));
		iRc = ntohl(lw);
	}

PRINTOUT3("ak_tr_notify: ProcId=%d Event=%d Rc=%d",usProcId,usEvent,iRc);

	if (usEvent == AKB_CMD_SHUT || usEvent == AKB_CMD_FSHUT ||
		usEvent == AKB_CMD_DELETE || usEvent == AKB_CMD_READ) {
		for (i=0;i<gi_req_tbl_size;i++) {
			if (gp_req_tbl[i].proc_id == usProcId) {
/*
printf("ak_tr_notify:found usProcId=%d sCommand=%d sEvent=%d\n",usProcId,
gp_req_tbl[i].command, gp_req_tbl[i].event);
*/
PRINTOUT3("ak_tr_notify:Canceled Request ProcId=%d Command=%d Event=%d",
usProcId,gp_req_tbl[i].command, gp_req_tbl[i].event);
				gp_req_tbl[i].proc_id = 0;
			}
		}
	}
	return 0;
}

int ak_tr_analiz_delete(iCh,sCommand,pHead)
int iCh;
pCOMM_PACK_HEAD pHead;
short sCommand;
{
	int i, iSdi, iRc, max=gi_regist_term_size;
	ushort usTrmId,usProcId;
	int ret;
	uchar *p;
	INT4 lHid_n;
	pTERM_TABLE pT;

	iRc = 0;
	usProcId = ntohs(pHead->cph_sinf.ind_prid);
	i = iCh;
	if (i > 0) {
		i--;
		pT = &gp_term_tbl[i];
		iSdi = pT->sd;
		usTrmId = pT->trm_id;
		if (iSdi<=0 || usTrmId != usProcId) {
			ERROROUT3("invalid pid!! omited cancel command ch=%d iSd=%d proc=%d",iCh,iSdi,usProcId);
			iRc = -1;
		}
	}
	else {
		pT = gp_term_tbl;
		for (i=0;i<max;i++,pT++) {
			iSdi = pT->sd;
			usTrmId = pT->trm_id;
			if (iSdi>0 && usTrmId == usProcId) break;
		}
		if (i >= gi_regist_term_size) {
			ERROROUT2("no registed pid!! omited cancel command ch=%d proc=%d",iCh,usProcId);
			iRc = -1;
		}
	}
	if (!iRc) {
		ak_tr_request(usProcId,sCommand);
		lHid_n = htonl(pT->host_id);
		p = (uchar *)&lHid_n;
		sprintf(LOGBUF(0),ak_tr_conv_msg(2101),i,
		        gi_regist_term_size,gi_resv_terminal,
		        (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3),
		        usProcId);
		LOGOUT(NULL);
		if (gt_que_write[i+1].rwq_torwlen > 0) {
#ifdef DEBUG
printf("[akTrAna] i=%d, written len=%d, to write len=%d\n",
i+1,gt_que_write[i+1].rwq_rwlen,gt_que_write[i+1].rwq_torwlen);
#endif
			gt_que_write[i+1].rwq_mode  = ' ';
			gt_que_write[i+1].rwq_torwlen = 0;
			gt_que_write[i+1].rwq_rwlen   = 0;
			Free(gt_que_write[i+1].rwq_buf);
			gt_que_write[i+1].rwq_buf = NULL;
			akb_wqch_rb_free(gp_rb_wctl_pa,gp_rb_pri_ctl_pa,0,i+1,0x01);
		}
	}
	akb_exchg_indicate(pHead);
	pHead->cph_sinf.ind_prid = htons(D_PRID_TERM);
/*
akxaxdump("DELETE",pHead,32);
*/
	ak_tr_trace(1,pHead);
	ret = ak_tr_check_sd(iSdi);
	if (ret >= 0) {
		ret = akb_sk_write(iSdi,(char *)pHead,sizeof(tdtCOMM_PACK_HEAD));
		if (ret < 0) {
			ERROROUTRC(ak_tr_conv_msg(2102),ret);
		}
	}
	if (!iRc) {
#if 1	/* 2001.6.5 Koba */
		pT->expire_time = aka_get_msec(NULL) + AKB_TERM_CLOSE_INTERVAL;
		pT->regist    = D_CANCELED;
		aka_register_timer("TermCloseTime",ak_tr_term_close_timer,AKB_TERM_CLOSE_INTERVAL*1000,NULL);
#else
		ak_tr_close(iSdi);
		pT->sd = -1;
		pT->expire_time = 0;
#endif
	}
	return 0;
}
