static char sccsid[]="%Z% %M% %I% %D% %T%";
/*************************************************
 *
 *  akbconnect.c
 *
 *        coded by A.Kobayashi 96/11/19
 *
 *************************************************/
#include "akbcommon.h"

static int iConnectPort=0;
static UINT4 ulConnectAddr=0;

int akb_get_host_addr(Hostname,ulpaddr_h)
char  *Hostname;
UINT4 *ulpaddr_h;
{
	struct hostent  *he;
	UINT4  taddr_n;
	char   szHostName[HOST_NAME_LEN],c,*host,*p;
	int    irc,len,n;

	len = 0;
	host = Hostname;
	if (host && (c=*host)) {
		if (c == '#') {
			if ((len = atoi(host+1)) < 0) len = 0;
		}
		else {
/* ̏gethostbyname̒łĂ炵
			if (*Hostname>='0' && *Hostname<='9') {
				if (ulpaddr_h) {
					taddr_n = inet_addr(Hostname);
					if ((INT4)taddr_n == -1) return -13;
					*ulpaddr_h = ntohl(taddr_n);
				}
				return 0;
			}
*/
			if (c == '[') {	/* for IPv6 Host addr */
				n = strlen(++host);
				if (*(p=host+n-1) == ']') p = '\0';
			}
			strnzcpy(szHostName,host,HOST_NAME_LEN-1);
			len = -1;
		}
	}
	if (len >= 0) {
		/* zXghc擾 */
		if (irc = gethostname(szHostName ,HOST_NAME_LEN)) {
			ERROROUT("gethostname failed");
			return -11;
		}
		if (len > 0) strnzcpy(Hostname,szHostName,len-1);
	}
#ifdef DEBUG
printf("akb_get_host_addr: host name = [%s]\n",szHostName);
#endif
	if (ulpaddr_h) {
		/* zXgɑ΂hoAhX𓾂 */
DEBUGOUT("gethostbyname");
		if (!(he = gethostbyname(szHostName))) {
			ERROROUT1("hostname(%s) not found in etc/hosts",szHostName);
			return -12;
		}
		memcpy((char *) &taddr_n, he->h_addr, he->h_length);
		*ulpaddr_h = ntohl(taddr_n);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_get_port_no_proto(Service,Type)
char *Service,*Type;
{
	struct servent  *se;
	unsigned short  tport_n, tport_h;
	int             iPort,ret;
	char            *service,*proto,*argv[2];

	if (!(service=Service)) return -21;
/*
printf("akb_get_port_no_proto:service=[%s]\n",service);
*/

	if ((iPort=atoi(service))>0) {	/* T[rX|[gԍ*/
		if (iPort > USHRT_MAX) {
			ERROROUT2("akb_get_port_no_proto:service(%s) > %d",service,USHRT_MAX);
			return -24;
		}
		tport_h = iPort;
	}
	else if (iPort<0) {
		ERROROUT1("akb_get_port_no_proto:service(%s) < 0",service);
		return -22;
	}
	else {
		if (Type && *Type) {
			proto = Type;
/*
printf("akb_get_port_no_proto:Type=[%s]\n",Type);
*/
		}
		else {
			if ((ret=akb_service_proto(service,argv))<0) {
				ERROROUT1("akb_get_port_no_proto:invalid service format(%s)",service);
				return ret-24;
			}
			service = argv[0];
			if (*argv[1]) proto = argv[1];
			else proto = "tcp";
		}
		if (se = getservbyname(service,proto)) {
			tport_n = se->s_port;
			tport_h = ntohs(tport_n);
		}
		else {
			ERROROUT1("akb_get_port_no_proto:service(%s) getservbyname failed.",Service);
			return -23;
		}
	}
/*
printf("akb_get_port_no_proto:port no=%d\n",tport_h);
*/

	return (int)tport_h;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_get_port_no(Service)
char *Service;
{
	return akb_get_port_no_proto(Service,NULL);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_connect_sub2(host_addr_h,port_no_h,iRetry,iSleep,iLinger)
UINT4 host_addr_h;
int port_no_h,iRetry,iSleep,iLinger;
{
	unsigned short  tport_h;
	struct sockaddr_in  sa_in;
	int iRc, s, t, time_out;

	akb_set_signal_msg("connect host=%08x port=%d",host_addr_h,port_no_h,0,0,0);

	tport_h = port_no_h;
	sa_in.sin_family      = AF_INET;
	sa_in.sin_port        = htons(tport_h);
	sa_in.sin_addr.s_addr = htonl(host_addr_h);

	t = iRetry;
	if (iSleep<0) iSleep = 3;
	time_out = akb_get_time_outi(D_TIMEOUT_SET_CONNECT);

	for (;;) {
		s = socket(AF_INET, SOCK_STREAM, 0);
		if (s == -1)
		{
			ERROROUT2("akb_connect_sub2: socket: errno=%d %s",
			          errno,strerror(errno));
			return -1;
		}
#ifdef SET_SIGNAL_ON_CONNECT
		signal(SIGALRM, akb_sock_time_out);
		siginterrupt(SIGALRM, 1);
#endif
		if (time_out > 0) alarm(time_out);
		else if (!time_out) alarm(1);
		iRc = connect(s,(struct sockaddr *)&sa_in,sizeof(struct sockaddr_in));
		alarm(0);
		if (iRc) {
			ERROROUT3("akb_connect_sub2: connect: iSd=%d errno=%d %s",
			          s,errno,strerror(errno));
			close(s);
			if (iRetry == 0) return -1;
			else if (iRetry > 0) {
				if (t-- <= 0) break;
			}
			sleep(iSleep);
		}
		else {
			if (iLinger >= 0) {
				if (akb_set_so_linger(s,1,iLinger) < 0) {
					ERROROUT3("akb_connect_sub2: akb_set_so_linger: iSd=%d errno=%d %s",
					          s,errno,strerror(errno));
					return -1;
				}
			}
			return s;
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_connect2(cpHost,cpService,iRetry,iSleep,iLinger)
char *cpHost     ;	/* ڑzXg */
char *cpService  ;	/* ڑT[rX܂̓|[gԍ */
int  iRetry,iSleep,iLinger;
{
	int iRc,port_no;
	UINT4 host_addr;

	if (!(iRc=akb_get_host_addr(cpHost,&host_addr))) {
		ulConnectAddr = host_addr;
		if ((port_no = akb_get_port_no_proto(cpService,"tcp"))>0) {
			iConnectPort = port_no;
			iRc = akb_connect_sub2(host_addr,port_no,iRetry,iSleep,iLinger);
		}
		else iRc = port_no;
	}
	return iRc;
}

#define LONG_TO_SHORT2(time_out,iLinger,iTimeOut)\
{\
	short sw[2];\
\
	memcpy(sw,&time_out,sizeof(INT4));\
	if (htons(1) == 1) {\
		iLinger  = sw[0];\
		iTimeOut = sw[1];\
	}\
	else {\
		iLinger  = sw[1];\
		iTimeOut = sw[0];\
	}\
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_connect_sub(host_addr_h,port_no_h,iRetry,iLingerSleep)
UINT4 host_addr_h;
int port_no_h,iRetry,iLingerSleep;
{
	int iLinger,iSleep;

	LONG_TO_SHORT2(iLingerSleep,iLinger,iSleep)

	return akb_connect_sub2(host_addr_h,port_no_h,iRetry,iSleep,iLinger-1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_connect(cpHost,cpService,iRetry,iLingerSleep)
char *cpHost     ;	/* ڑzXg */
char *cpService  ;	/* ڑT[rX܂̓|[gԍ */
int  iRetry,iLingerSleep;
{
	char *argv[2],*linger;
	int ret,iLinger,iSleep;

	LONG_TO_SHORT2(iLingerSleep,iLinger,iSleep)
	iLinger--;

	if ((ret=akb_service_linger(cpService,argv)) < 0) return ret;
	else if (ret > 0) {
		linger = argv[1];
		if (linger && *linger) {
			if (ret = akxccvn(10,linger,strlen(linger),&iLinger)) {
				ERROROUT3("akb_connect: cpService=[%s] linger=[%s] error=%d",
				          cpService,linger,ret);
				return -1;
			}
		}
	}

	return akb_connect2(cpHost,argv[0],iRetry,iSleep,iLinger);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_get_connect_port()
{
	return iConnectPort;
}

/********************************************************/
/*                                                      */
/********************************************************/
UINT4 akb_get_connect_addr()
{
	return ulConnectAddr;
}

static struct sockaddr_in sin={0,0};
static INT4 glAcceptSocketParm[3]={0,0,0};
/********************************************************/
/*                                                      */
/********************************************************/
int akb_accept2(iSd0, time_out, iLinger)
int iSd0, time_out, iLinger;
{
	int             iRc, iSd, iLen;
	fd_set          readfds;
	struct timeval  tval;

	if (time_out <= -2) time_out = akb_get_time_outi(D_TIMEOUT_SET_ACCEPT);
	if (time_out >= 0) {
		FD_ZERO(&readfds);
		FD_SET(iSd0,&readfds);
		tval.tv_sec  = time_out;
		tval.tv_usec = 0;
		iRc = select(iSd0+1, &readfds, NULL, NULL, &tval);
		if (iRc < 0) {
			ERROROUT3("akb_accept:select iSd=%d errno=%d %s",iSd0,errno,strerror(errno));
			if (errno == EINTR) return -2;
			else return -1;
		}
		else if(!iRc) {
			return -2;
		}
	}
	iLen = sizeof(struct sockaddr_in);
	iSd = accept(iSd0,(struct sockaddr *)&sin,&iLen);
	if (iSd < 0) {
		ERROROUT3("akb_accept:accept iSd=%d errno=%d %s",iSd,errno,strerror(errno));
		return -1;
	}
	if (iLinger >= 0) {
		if (akb_set_so_linger(iSd,1,iLinger) < 0) {
			ERROROUT3("akb_connect_sub2: akb_set_so_linger: iSd=%d errno=%d %s",
			          iSd,errno,strerror(errno));
			return -1;
		}
	}
	return iSd;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_accept(iSd0, time_out)
int iSd0, time_out;
{
	int   iLinger,iTimeOut;

	LONG_TO_SHORT2(time_out,iLinger,iTimeOut)

	return akb_accept2(iSd0, iTimeOut, iLinger-1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_get_accept_sock_addr(psa,len)
struct sockaddr_in  *psa;
int len;
{
	int len_sin;

	if (!psa) return -1;
	len_sin = sizeof(struct sockaddr_in);
	if (len == len_sin) memcpy(psa,&sin,len_sin);
	else len_sin = -2;
	return len_sin;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_get_accept_sock_parm(n,parm)
int n,parm[];
{
	int i,m;

	if ((m=n) > 3) m = 3;
	if (m >= 1) parm[0] = ntohl(sin.sin_addr.s_addr);
	if (m >= 2) parm[1] = ntohs(sin.sin_port);
	if (m >= 3) parm[2] = 0;
	return m;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_so_linger(iSd,onoff,time)
int iSd;
int onoff;	/* 0/1=OFF/ON */
int time;	/* sec */
{
	struct linger lin;

/*	
printf("akb_set_so_linger: iSd=%d onoff=%d time=%d\n",iSd,onoff,time);
*/
	lin.l_onoff  = onoff;
	lin.l_linger = time;
	if (setsockopt(iSd,SOL_SOCKET,SO_LINGER,&lin,sizeof(lin)) == -1) {
		ERROROUT3("akb_set_so_linger: setsockopt: iSd=%d errno=%d %s",
		          iSd,errno,strerror(errno));
		return -1;
	}
	return 0;
}
