static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************/
/*								*/
/*      coded by A.Kobayashi 1993.12.20   */
/*    updated by A.Kobayashi 1995.06.06   */
/*    updated by A.Kobayashi 2001.10.15   */
/*								*/
/******************************************/
#include	"akxcommon.h"

#if defined(AIX) || defined(WIN) || defined(HPUX) || defined(CYGWIN)
#define SJIS
#else
#define EUC
#endif

#define AKX_SJIS_START		0x8140
#define AKX_SJIS_OFFSET		(AKX_SJIS_START-256)

#ifdef UTF8_SRC
#define AKX_SJIS_AKI_START	0xA000
#define AKX_SJIS_START2		0xE040
#define AKX_SJIS_OFFSET2	(AKX_SJIS_START2-AKX_SJIS_AKI_START)
#define AKX_SJIS_MAX		(65536-AKX_SJIS_OFFSET-AKX_SJIS_OFFSET2)
#define AKX_SJIS_HASH_MAX	11500
#define AKX_SJIS_HASH_PRE	11467
#else
#define AKX_SJIS_MAX		(65536-AKX_SJIS_OFFSET)
#define AKX_SJIS_HASH_MAX	12000
#endif

static int gexe_set_utf8=0;
static UINT4 *gucs4=NULL;
static UINT4 *gutf8=NULL;
static HASHB *ha=NULL;
static HASHB *ha4=NULL;

#ifdef UTF8_SRC

static int _init_sj_utf8();
static int _Unihaslr();

int akxc_set_utf8_file(file)
char *file;
{
	return 0;
}

int akxc_set_sj_utf8(file)
char *file;
{
	return 0;
}
#else

static char *hkey[2],*h4key[2];
static char *utf8_file;

int akxc_set_utf8_file(file)
char *file;
{
	if (!(utf8_file=Strdup(file))) return -1;
	return 0;
}

int akxc_set_sj_utf8(file)
char *file;
{
	FILE *fp;
	char buf[128],parm[256],*argv[3],*p,c,*hkey[2],*h4key[2];
	int  len,n,ret,offset,iha4;
	ushort ucs2;
	UINT4  val,sj,utf8,ucs4,ix;

	if (!file) return -1;
	if (!(fp=fopen(file,"r"))) {
		XERROROUTL5(200,"%s open error",file,0,0,0,0);
		return -2;
	}

	gexe_set_utf8 = 1;
	len = AKX_SJIS_MAX*sizeof(UINT4)*2;
	if (!gucs4) {
		if (!(gucs4=(UINT4 *)Malloc(len))) {
			XERROROUTL5(200,"gucs4 malloc error",0,0,0,0,0);
			ret = -3;
			goto Err;
		}
	}
	memset(gucs4,0,len);
	gutf8 = gucs4 + AKX_SJIS_MAX;

	if (ha) akxs_hasl_free(ha);
	ha = akxs_hasl_new(4,AKX_SJIS_HASH_MAX,0);
	if (!ha) {
		XERROROUTL5(200,"akxs_hasl_new errno=%d",errno,0,0,0,0);
		ret = -3;
		goto Err;
	}
/*
printf("UTF8: id=%c%c len=%d maxreg=%d mso=%d\n",
ha->ha_id[0],ha->ha_id[1],ha->ha_keylen,ha->ha_maxreg,ha->ha_prereg);
*/
	ha->ha_key = (char *)hkey;
	if (ha4) akxs_hasl_free(ha4);
	ha4 = akxs_hasl_new(4,AKX_SJIS_HASH_MAX,0);
	if (!ha4) {
		XERROROUTL5(200,"akxs_hasl_new errno=%d",errno,0,0,0,0);
		ret = -4;
		goto Err;
	}
/*
printf("UCS4: id=%c%c len=%d maxreg=%d mso=%d\n",
ha->ha_id[0],ha->ha_id[1],ha->ha_keylen,ha->ha_maxreg,ha->ha_prereg);
*/
	ha4->ha_key = (char *)h4key;
/*
printf("--sjis-- --ucs4-- --utf8-- - ix- -iha- -iha4\n");
*/
	while ((len = akxa_read_line(buf,sizeof(buf),fp)) > 0) {
		if ((c=*buf) == '#') continue;
		else if (c == '\t') offset = 1;
		else offset = 8;
		n = akxtgetargv2(buf+offset,argv,3,parm,sizeof(parm),1);
		if (n >= 2) {
			p = argv[0] + 2;
			ret = akxccvx(p,strlen(p),&val);
			sj = val;
			if (n>=3 && *argv[2]=='(') p = argv[2] + 1;
			else p = argv[1] + 2;
			ret = akxccvx(p,strlen(p),&val);
			ucs4 = val;
			if (ucs4 <= 0x7f) {
				utf8 = ucs4<<24;
			}
			else if (ucs4 <= 0x7ff) {
				utf8 = ((ucs4&0x07c0)<<2 | (ucs4&0x3f) | 0xc080)<<16;
			}
			else if (ucs4 <= 0xffff) {
				utf8 = ((ucs4&0xf000)<<4 | (ucs4&0x0fc0)<<2 | (ucs4&0x3f) |
				        0xe08080)<<8;
			}
			else {
				utf8 = (ucs4&0x1c0000)<<6 | (ucs4&0x3f000)<<4 |
				       (ucs4&0xfc0)<<2 | (ucs4&0x3f) | 0xf0808080;
			}
			if ((ix=sj) >= AKX_SJIS_START) ix = sj - AKX_SJIS_OFFSET;
			gucs4[ix] = ucs4;
			gutf8[ix] = utf8;
			hkey[1] = (char *)sj;
			ret = akxshasls(ha,utf8);
			h4key[1] = (char *)sj;
			iha4 = akxshasls(ha4,ucs4);
/*
printf("%08x %08x %08x %5d %5d %5d\n",sj,ucs4,utf8,ix,ret,iha4);
*/
		}
	}
	ret = 0;
Err:
	fclose(fp);
	return ret;
}
#endif

int akxc_sj_to_utf8(sjis,utf8c,ucs4)
ushort  sjis;
uchar  *utf8c;
UINT4  *ucs4;
{
	int len,ret;
	UINT4 w,utf8,ix,sj,ucs4w;

	if (!gexe_set_utf8) {
#ifdef UTF8_SRC
		if (ret=_init_sj_utf8()) return ret;
#else
		if (ret=akxc_set_sj_utf8(utf8_file)) return ret;
#endif
	}
	if (!gutf8) return -1;
	sj = sjis;
#ifdef UTF8_SRC
	if ((ix=sj) >= AKX_SJIS_START) {
		ix = sj - AKX_SJIS_OFFSET;
		if (sj>=AKX_SJIS_START2) ix -= AKX_SJIS_OFFSET2;
	}
#else
	if ((ix=sj) >= AKX_SJIS_START) ix = sj - AKX_SJIS_OFFSET;
#endif
/*
printf("akxc_sj_to_utf8: %04x %08x\n",sjis,utf8);
*/
	if (utf8c) {
		utf8 = gutf8[ix];
	/*	len = akxqu8len((utf8>>24) & 0xff);	*/
		w = htonl(utf8);
		len = akxqu8nlen(&w, 4);
		memcpy(utf8c,&w,len);
	}
	else len = 0;
	if (ucs4) *ucs4 = gucs4[ix];
/*
printf("akxc_sj_to_utf8: sjis=%04x utf8=%08x len=%d\n",sjis,utf8,len);
*/
	return len;
}

int akxcstou8(n, inc, outc)
int   n;
uchar *inc, *outc;
{
	int i,j,len;
	uchar  c1;
	ushort sjis;

	j = 0;
	for (i=0;i<n;i++,inc++) {
		sjis = c1 = *inc;
		if (akxqiskanji1(c1)) {
			if (i+1 < n) {
				if (akxqiskanji(inc)) {
					i++;
					sjis = sjis<<8 | *(++inc);
				}
			}
			else break;
		}
		len = akxc_sj_to_utf8(sjis,outc,NULL);
		outc += len;
		j    += len;
	}
	return j;
}

int akxc_utf8_to_sj(utf8c,sjis,ucs4)
uchar  *utf8c;
ushort *sjis;
UINT4  *ucs4;
{
	int len,ret;
	UINT4 w,utf8,ix,sj,ucs4w;
	char **argv;

	if (!gexe_set_utf8) {
#ifdef UTF8_SRC
		if (ret=_init_sj_utf8()) return ret;
#else
		if (ret=akxc_set_sj_utf8(utf8_file)) return ret;
#endif
	}
	if (!ha) return -1;
	len = akxqu8len(*utf8c);
	sj = ucs4w = w = 0;
	memcpy(&w,utf8c,len);
	utf8 = ntohl(w);
#ifdef UTF8_SRC
/*
printf("akxc_utf8_to_sj: utf8=%08x\n",utf8);
*/
	if ((ret = _Unihaslr(ha,utf8)) > 0) {
#else
	if ((ret = akxshaslr(ha,utf8)) > 0) {
#endif
#ifdef UTF8_SRC
		sj = (UINT4)ha->ha_next;
/*
printf("akxc_utf8_to_sj: sj=%08x\n",sj);
*/
		if ((ix=sj) >= AKX_SJIS_START) {
			ix = sj - AKX_SJIS_OFFSET;
			if (sj>=AKX_SJIS_START2) ix -= AKX_SJIS_OFFSET2;
		}
#else
		if (!(argv=(char **)ha->ha_key)) return -1;
		sj = (UINT4)argv[1];
		if ((ix=sj) >= AKX_SJIS_START) ix = sj - AKX_SJIS_OFFSET;
#endif
		ucs4w = gucs4[ix];
	}
	if (sjis) *sjis = sj;
	if (ucs4) *ucs4 = ucs4w;
/*
printf("akxc_utf8_to_sj: utf8=%08x len=%d ret=%5d sj=%08x ucs4=%08x\n",utf8,len,ret,sj,ucs4w);
*/
	return len;
}

int akxcu8tos(n, inc, outc)
int   n;
uchar *inc, *outc;
{
	int i,j,len;
	ushort sjis;

	j = 0;
	for (i=0;i<n;i+=len) {
		if ((len = akxc_utf8_to_sj(inc,&sjis,NULL)) < 0) return len;
		inc += len;
		if (sjis) {
			*outc = sjis;
			if (sjis & 0xff00) {
				outc[1] = *outc;
				*outc++ = sjis>>8;
				j++;
			}
			outc++;
			j++;
		}
	}
	return j;
}
#if 0
int akxc_ucs4to_sj(ucs4,sjis,utf8c)
UINT4   ucs4;
ushort *sjis;
uchar  *utf8c;
{
	int i,len,ret;
	UINT4 w,utf8,ix,sj,ucs4w;

	if (!ha4) return -1;
	sj = len = ucs4w = w = 0;
	memcpy(&w,utf8c,len);
	utf8 = ntohl(w);
	if ((ret = akxshaslr(ha4,ucs4)) > 0) {
		sj = (UINT4)hkey[1];
		if (utf8c) {
			len = akxc_sj_to_utf8((ushort)sj,utf8c,NULL);
		}
	}
	if (sjis) *sjis = sj;
/*
printf("akxc_ucs4to_sj: ucs4=%08x sj=%04x utf8=%04x len=%d\n",ucs4,sj,utf8,len);
*/
	return len;
}
#endif
int akxcstou81(sjis,utf8)
uchar *sjis,*utf8;
{
	ushort us,usw;

	memcpy(&usw,sjis,2);
	us = ntohs(usw);
	return akxc_sj_to_utf8(us,utf8,NULL);
}

int akxcu8tos1(utf8,sjis)
uchar *utf8,*sjis;
{
	int len;
	ushort us,usw;
	uchar uc;

	len = 0;
	akxc_utf8_to_sj(utf8,&us,NULL);
/*
printf("akxcu8tos1: us=%08x\n",us);
*/
	uc = us;
	if (us) {
		len = 1;
		if (us & 0xff00) {
			sjis[1] = uc;
			uc = us>>8;
			len++;
		}
	}
	*sjis = uc;
	return len;
}

#if 1
int akxqu8len(c)
uchar c;
{
	UINT4 u1;
	int mlen;

	mlen = 1;
	u1 = (UINT4)c;
	if (u1 < 0xc2) ;
	else if (u1 < 0xe0) {
		if (u1 <= 0xdf) mlen = 2;
	}
	else if (u1 < 0xf0) {
		if (u1 <= 0xef) mlen = 3;
	}
	else if (u1 <= 0xf4) mlen = 4;
	return mlen;
}

int akxqu8nlen(p_str, len)
char *p_str;
int len;
{
	UINT4 u1,u2,u3,u4;
	int mlen;
	char *p;

	if (!(p=p_str)) return -1;
	if (len <= 0) return akxqu8len(*p);
/*	else if (len == 1) return 1; */

	mlen = 1;
	u1 = (UINT4)*p & 0xff;
/*
printf("akxqu8nlen: len=%d u1=%08x\nh,len,u1);
*/
	if (u1 < 0xc2) ;
	else if (u1 < 0xe0) {
		if (u1<=0xdf) {
			if (len >= 2) {
				u2 = (UINT4)*(++p) & 0xff;
				if (u2>=0x80 && u2<=0xbf) mlen = 2;
			}
			else mlen = -2;
		}
	}
	else if (u1 < 0xf0) {
		if (len >= 3) {
			u2 = (UINT4)*(++p) & 0xff;
			if (u1==0xe0) {
				if (u2>=0xa0 && u2<=0xbf) mlen = 3;
			}
			else if ((u1>=0xe1 && u1<=0xec) || (u1>=0xee && u1<=0xef)) {
				if (u2>=0x80 && u2<=0xbf) mlen = 3;
			}
			else if (u1==0xed) {
				if (u2>=0x80 && u2<=0x9f) mlen = 3;
			}
			if (mlen>1) {
				u3 = (UINT4)*(++p) & 0xff;
				if (u1==0xef && u2==0xbb && u3==0xbf) mlen = 103; /* BOM */
				else if (u3>=0x80 && u3<=0xbf) ;
				else mlen = 1;
			}
		}
		else mlen = -3;
	}
	else {
		if (len >= 4) {
			u2 = (UINT4)*(++p) & 0xff;
			if (u1==0xf0) {
				if (u2>=0x90 && u2<=0xbf) mlen = 4;
			}
			else if (u1<0xf4) {
				if (u2>=0x80 && u2<=0xbf) mlen = 4;
			}
			else if (u1==0xf4) {
				if (u2>=0x80 && u2<=0x8f) mlen = 4;
			}
			if (mlen>1) {
				u3 = (UINT4)*(++p) & 0xff;
				if (u3>=0x80 && u3<=0xbf) {
					u4 = (int)*(++p) & 0xff;
					if (u4>=0x80 && u4<=0xbf) ;
					else mlen = 1;
				}
				else mlen = 1;
			}
		}
		else mlen = -4;
	}
	return mlen;
}
#else
int akxqu8len(c1)
uchar c1;
{
	UINT4 utf8;
	int len;

	utf8 = c1;
	if (!(utf8 & 0x80)) len = 1;
	else if ((utf8 & 0xe0) == 0xc0) len = 2;
	else if ((utf8 & 0xf0) == 0xe0) len = 3;
	else len = 4;
	return len;
}
#endif

#ifdef UTF8_SRC
#include "akxutf8_src.c"
#endif
