/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_LIBTODO_API

#include"libtodo_header.h"

/*
  <Data Operation>
    LibToDo_GetTopData
	LibToDo_GetPrevData
	LibToDo_GetNextData
    LibToDo_GetChildData
*/

/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_ImportClientJson(
			char	*pstr_import_filepath )
{
	int		i_result;

	if( NULL == pstr_import_filepath )	{
		SET_ERRINFO( "Invalid param. (Operand is NULL)" );
		return -0x01;
	}

	i_result	= ConfigFile_Global_Import_GLClientSecretJson( pstr_import_filepath );

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_CreateUserOAuthURL(
			char	*pstr_url )
{
	int		i_result;

	if( NULL == pstr_url )	{
		SET_ERRINFO( "Invalid param. (Operand is NULL)" );
		return -0x01;
	}

	i_result	= ConfigFile_Global_CreateOAuthURL( pstr_url );

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_CreateConfigFile(
			char *pstr_code )
{
	int		i_result;

	if( NULL == pstr_code )	{
		SET_ERRINFO( "Invalid param. (Operand is NULL)" );
		return -0x01;
	}

	i_result	= ConfigFile_CreateConfig( pstr_code );

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_ReadToDoCache(
			char *pstr_filepath )
{
	int		i_err	= 0x00;
	char	str_filepath[256];
	struct	stat	t_stat;

	if( NULL == pstr_filepath )	{
		if( LIBTODO_MODE_DEBUG == gb_mode )	{
			strncpy( str_filepath, "./"LIBTODO_CACHE_FILE, 255 );
		}
		else	{
			strncpy( str_filepath, getenv("HOME"), 255 );
			strncat( str_filepath, "/"LIBTODO_CACHE_FILE, 255 );
		}
	}
	pstr_filepath	= str_filepath;

	if( 0x00 == stat( pstr_filepath, &t_stat ) )
		{ i_err	= ToDoData_ReadInCache( pstr_filepath ); }

	return i_err;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_WriteToDoCache(
			char *pstr_filepath )
{
	int		i_err;
	char	str_filepath[256];

	if( NULL == pstr_filepath )	{
		if( LIBTODO_MODE_DEBUG == gb_mode )	{
			strncpy( str_filepath, "./"LIBTODO_CACHE_FILE, 255 );
		}
		else	{
			strncpy( str_filepath, getenv("HOME"), 255 );
			strncat( str_filepath, "/"LIBTODO_CACHE_FILE, 255 );
		}
	}
	pstr_filepath	= str_filepath;

	i_err	= ToDoData_WriteOutCache( pstr_filepath );
	return i_err;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_SearchDataID(
			char			*pstr_id )
{
	if( NULL == pstr_id )	{
		SET_ERRINFO( "Invalid param. (Operand is NULL)" );
		return -0x01;
	}

	return ToDoData_SearchData( pstr_id );
}
	

/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetData(
			LibToDo_Data	*p_data,
			int				i_id )
{
	ToDo_Data		*p_tdata;

	if( NULL == p_data )	{
		SET_ERRINFO( "Invalid param. (Operand is NULL)" );
		return -0x01;
	}

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( NULL == p_tdata )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x02;
	}

	if( TODODATA_TYPE_TASK == p_tdata->b_type )
		{ p_tdata->t_data.i_level	= 1; }
	else if( TODODATA_TYPE_SUB == p_tdata->b_type )
		{ p_tdata->t_data.i_level	= 2; }
	else
		{ p_tdata->t_data.i_level	= 0; }

	memcpy( p_data, &(p_tdata->t_data), sizeof( LibToDo_Data ) );

	// XXX Debug!
	p_data->qw_position	= p_tdata->qw_position;

	return 0x00;
}
	

/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_SetStatus(
			int				i_id,
			Byte			b_status )
{
	ToDo_Data		*p_tdata;

	if( NO_TODODATA >= i_id )	{
		SET_ERRINFO( "Invalid param. (Operand is minus id)" );
		return -0x01;
	}

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( NULL == p_tdata )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x03;
	}

	return ToDoData_SetStatus( p_tdata, b_status );
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetTopDataID(
			void )
{
	int				i_id;
	ToDo_Data		*p_tmaster;

	p_tmaster	= ToDoData_GetToDoData( 0 );
	assert( NULL != p_tmaster );
	i_id		= p_tmaster->i_child;

	return i_id;
}
	

/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetListDataID(
			int		i_id )
{
	ToDo_Data		*p_tdata;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	if( TODODATA_TYPE_LIST == p_tdata->b_type )
		{ return p_tdata->i_id; }
	else if( TODODATA_TYPE_TASK == p_tdata->b_type )
		{ return p_tdata->i_parent; }

	assert( TODODATA_TYPE_SUB == p_tdata->b_type );

	p_tdata	= ToDoData_GetToDoData( p_tdata->i_parent );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	return p_tdata->i_parent;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetParentDataID(
			int		i_id )
{
	ToDo_Data		*p_tdata;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	if( TODODATA_TYPE_SUB == p_tdata->b_type )
		{ return (( 0 < p_tdata->i_parent ) ? p_tdata->i_parent : NO_TDATA ); }

	return NO_TDATA;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetChildDataID(
			int		i_id )
{
	ToDo_Data		*p_tdata;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	return p_tdata->i_child;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetPrevDataID(
			int		i_id )
{
	ToDo_Data		*p_tdata;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	return p_tdata->i_prev;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_GetNextDataID(
			int		i_id )
{
	ToDo_Data		*p_tdata;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	return p_tdata->i_next;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_InsertToDo(
			char	*pstr_title,
			int		i_listid,
			int		i_previd,
			int		i_parentid,
			Byte	b_mode )
{
	int				i_id;
	int				i_result;
	Byte			b_type;
	QWord			qw_position;
	ToDo_Data		*p_tdata;
	ToDo_Data		*p_tlist	= NULL;
	ToDo_Data		*p_tparent	= NULL;
	ToDo_Data		*p_tprev	= NULL;

	if( NULL == pstr_title )	{
		SET_ERRINFO( "Invalid param (operand is NULL)" );
		return -0x01;
	}

	p_tlist	= ToDoData_GetToDoData( i_listid );
	if( p_tlist	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x02;
	}

	if( NO_TDATA != i_previd )	{
		p_tprev		= ToDoData_GetToDoData( i_previd );
		if( p_tprev	== NULL )	{
			SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
			return -0x03;
		}
	}

	if( NO_TDATA != i_parentid )	{
		p_tparent	= ToDoData_GetToDoData( i_parentid );
		if( p_tparent	== NULL )	{
			SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
			return -0x04;
		}

		b_type	= ((1 == p_tparent->t_data.i_level) ? TODODATA_TYPE_SUB : TODODATA_TYPE_TASK);

		if((NO_TDATA == i_previd )
				&& (TODODATA_TYPE_MASTER != p_tparent->b_type))
			{ qw_position	= TODODATA_POSITION_TOP; }
		else if( NULL != p_tprev )
			{ qw_position	= p_tprev->qw_position; }
		else
			{ qw_position	= 0L; }
	}
	else	{
		b_type	= TODODATA_TYPE_TASK;
		assert( NULL != p_tprev );
		qw_position	= p_tprev->qw_position;
	}

	// Append Task to ToDoCache
	i_id	= ToDoData_InsetToDoData(
					((NO_TDATA != i_parentid) ? i_parentid : i_listid),
					b_type, NULL, qw_position );

	p_tdata	= ToDoData_GetToDoData( i_id );
	strncpy( p_tdata->t_data.str_item, pstr_title, 512 );

	p_tdata->b_status	= TODO_STATUS_NEEDSACTION;
	p_tdata->t_data.b_status	= p_tdata->b_status;

	p_tdata->t_data.i_level	= ((TODODATA_TYPE_TASK == b_type) ? 1 : 2);
	p_tdata->t_data.i_id	= p_tdata->i_id;

	ToDoData_UpdatePosition( p_tdata );

	// Set Unsync Flag
	ToDoData_UpdateFlag( p_tdata, TODODATA_FLAG_UNSYNC_INSERT );

	if( TODO_MODE_SYNC & b_mode )	{
		i_result	= GLAPI_Task_InsertTask(
						pstr_title, p_tdata, p_tlist, p_tprev, p_tparent );
		if( 0x00 > i_result )	{
			SET_ERRINFO1( "Failed function call: GLAPI_Task_InsertTask()", i_result );
			return i_result;
		}

		// Close Unsync flag
		ToDoData_UpdateFlag( p_tdata, (TODODATA_FLAG_UNSYNC_INSERT ^ p_tdata->b_flag) );
	}

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_UpdateStatus(
			int		i_id,
			Byte	b_status )
{
	int				i_result;
	Byte			b_setst;
	ToDo_Data		*p_tdata;
	ToDo_Data		*p_tlist;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	p_tlist	= ToDoData_GetToDoData( p_tdata->i_parent );
	assert( NULL != p_tlist );

	if( 0 != p_tlist->i_parent )	{
		p_tlist	= ToDoData_GetToDoData( p_tlist->i_parent );
		assert( NULL != p_tlist );
		assert( 0 == p_tlist->i_parent );
	}

	i_result	= GLAPI_Task_UpdateTask(
					p_tdata, p_tlist, p_tdata->t_data.str_item,
					((TODO_STATUS_COMPLETED & b_status) ? "completed" : "needsAction"),
					HIDDEN_FLAG_HIDDEN );
	if( 0x00 > i_result )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Task_UpdateTask()", i_result ); }

	ToDoData_UpdateFlag( p_tdata, TODODATA_FLAG_SYNCED );

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_LoadToDoList(
			void )
{
	int		i_maxlists;
	
	// All-Clear Local ToDo-Data Tree ---
	ToDoData_FreeToDoData( NULL );

	// Get TaskList from Google ---
	i_maxlists	= GLAPI_List_GetTaskList();
	if( 0 > i_maxlists )	{
		SET_ERRINFO1( "Failed function call: GLAPI_List_GetTaskList()", i_maxlists );
		return -0x01;
	}

	return i_maxlists;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_LoadToDoData(
			Byte	b_mode )
{
	int		i_cnt;
	int		i_taskid;
	int		i_maxtasks	= 0;
	int		i_parentid;
	int		i_list;
	int		i_maxlists;
	int		i_items	= 0;
	int		i_tlist_id;
	char	*pstr_lastupdated;
	ToDo_Data	*p_tmaster;
	ToDo_Data	*p_tlist;
	ToDo_Data	*p_tnow;

	pstr_lastupdated	= ToDoData_GetLastUpdated();
	if( '\0' == *(pstr_lastupdated + 0) )
		{ b_mode	|= TODO_MODE_RELOAD; }

	// All-Clear Local ToDo-Data Tree ---
	if( TODO_MODE_RELOAD & b_mode )		// ReLoad mode
		{ ToDoData_FreeToDoData( NULL ); }

	// Get TaskList from Google ---
	i_maxlists	= GLAPI_List_GetTaskList();
	if( 0 > i_maxlists )	{
		SET_ERRINFO1( "Failed function call: GLAPI_List_GetTaskList()", i_maxlists );
		return -0x01;
	}

	p_tmaster	= ToDoData_GetToDoData( 0 );
	assert( NULL != p_tmaster );

	i_items		= i_maxlists;
	i_tlist_id	= p_tmaster->i_child;
	for( i_list = 0; i_list < i_maxlists; i_list++ )	{
		p_tlist	= ToDoData_GetToDoData( i_tlist_id );

		// Get Task in Indicate-TaskList form Google ---
		i_maxtasks	= GLAPI_Task_GetTasks( p_tlist, b_mode );
		if( 0 > i_maxtasks )	{
			SET_ERRINFO1( "Failed function call: GLAPI_Task_GetTasks()", i_maxtasks );
			return -0x02;
		}

		// ReConstruct ToDo-Data ---
		i_taskid	= p_tlist->i_child;
		for( i_cnt = 0; ((i_cnt < i_maxtasks) && (NO_TDATA != i_taskid)); i_cnt++ )	{
			
			p_tnow	= ToDoData_GetToDoData( i_taskid );
			assert( NULL != p_tnow );
			i_taskid	= p_tnow->i_next;

			if( '\0' != p_tnow->str_parent[0] )	{
				i_parentid	= ToDoData_SearchParent( p_tlist, p_tnow->str_parent );
				if( NO_TDATA != i_parentid )	{
					ToDoData_DisConnectChain( p_tnow );
					ToDoData_AppendChain(
							p_tnow->i_id, i_parentid, TODODATA_TYPE_SUB, p_tnow->qw_position );
				}
			}
		}

		i_tlist_id	= p_tlist->i_next;

		i_items	+= i_maxtasks;
	}

	// ReLoad mode
	if( TODO_MODE_RELOAD & b_mode )	{
		ToDoData_SortIndex();
		ToDoData_ReNumberingDataID();
	}

	return i_items;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_ClearToDoData(
			void )
{
	int		i_result	= 0;
	int		i_maxlists	= 0;
	ToDo_Data	*p_tmaster;
	ToDo_Data	*p_tlist;
	
	p_tmaster	= ToDoData_GetToDoData( 0 );
	assert( NULL != p_tmaster );

	p_tlist	= ToDoData_GetToDoData( p_tmaster->i_child );
	while( NULL != p_tlist )	{
		i_result	= GLAPI_Task_ClearTasks( p_tlist );
		if( 0x00 > i_result )	{
			SET_ERRINFO1( "Failed function call: GLAPI_Task_ClearTasks()", i_result );
			break;
		}

		p_tlist	= ToDoData_GetToDoData( p_tlist->i_next );
	}

	ToDoData_ClearDoneTask();

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_MoveToDo(
			int		i_taskid,
			int		i_listid,
			int		i_previd,
			int		i_parentid,
			Byte	b_mode )
{
	int				i_result;
	ToDo_Data		*p_ttask	= NULL;
	ToDo_Data		*p_tlist	= NULL;
	ToDo_Data		*p_tparent	= NULL;
	ToDo_Data		*p_tprev	= NULL;
	ToDo_Data		*p_toldnext	= NULL;

	p_ttask	= ToDoData_GetToDoData( i_taskid );
	if( p_ttask	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x01;
	}

	p_tlist	= ToDoData_GetToDoData( i_listid );
	if( p_tlist	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x02;
	}

	if( NO_TDATA != i_previd )	{
		p_tprev		= ToDoData_GetToDoData( i_previd );
		if( p_tprev	== NULL )	{
			SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
			return -0x03;
		}
	}

	if( NO_TDATA != i_parentid )	{
		p_tparent	= ToDoData_GetToDoData( i_parentid );
		if( p_tparent	== NULL )	{
			SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
			return -0x04;
		}
	}
	// DisConnect Task from Original Chain ---
	p_toldnext	= ToDoData_GetToDoData( p_ttask->i_next );
	ToDoData_DisConnectChain( p_ttask );
	if( NULL != p_toldnext )
		{ ToDoData_UpdatePosition( p_toldnext ); }

	// Append Task to New Position ---
	if( NULL != p_tprev )	{
		i_result	= ToDoData_AppendChain(
						i_taskid, i_parentid, p_tprev->b_type, p_tprev->qw_position );
	}
	else	{
		i_result	= ToDoData_AppendChain(
						i_taskid, i_parentid,
						((TODODATA_TYPE_TASK == p_tparent->b_type)
						  ? TODODATA_TYPE_SUB : TODODATA_TYPE_TASK),
						TODODATA_POSITION_TOP );
	}
	ToDoData_UpdatePosition( p_ttask );

	ToDoData_UpdateFlag( p_ttask, TODODATA_FLAG_UNSYNC_MOVE );

	if( TODO_MODE_SYNC & b_mode )	{
		i_result	= GLAPI_Task_MoveTask( p_ttask, p_tlist, p_tprev, p_tparent );
		if( 0x00 > i_result )
			{ SET_ERRINFO1( "Failed function call: GLAPI_Task_MoveTask()", i_result ); }

		ToDoData_UpdateFlag( p_ttask, (TODODATA_FLAG_UNSYNC_MOVE ^ p_ttask->b_flag) );
	}

	return i_result;
}


/* ===================================================================*/
LIBTODO_API_API_EXTERN
int
	LibToDo_DeleteTask(
			int		i_id )
{
	int				i_result;
	ToDo_Data		*p_tdata;
	ToDo_Data		*p_tlist;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return NO_TDATA;
	}

	p_tlist	= ToDoData_GetToDoData( p_tdata->i_parent );
	assert( NULL != p_tlist );

	if( 0 != p_tlist->i_parent )	{
		p_tlist	= ToDoData_GetToDoData( p_tlist->i_parent );
		assert( NULL != p_tlist );
		assert( 0 == p_tlist->i_parent );
	}

	i_result	= GLAPI_Task_DeleteTask( p_tdata, p_tlist );
	if( 0x00 > i_result )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Task_DeleteTask()", i_result ); }

	ToDoData_FreeToDoData( p_tdata );

	return i_result;
}


/* ===================================================================*/
static int
	LibToDo_Sync_Insert(
			int		i_id )
{
	int				i_result;
	ToDo_Data		*p_tdata;
	ToDo_Data		*p_tlist	= NULL;
	ToDo_Data		*p_tparent	= NULL;
	ToDo_Data		*p_tprev	= NULL;

	p_tdata	= ToDoData_GetToDoData( i_id );
	if( p_tdata	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x01;
	}

	p_tprev		= ToDoData_GetToDoData( p_tdata->i_prev );

	p_tparent	= ToDoData_GetToDoData( p_tdata->i_parent );
	if( NULL == p_tparent )	{
		SET_ERRINFO( "Ivalid ToDoData (parent is NULL): LibToDo_Sync_Insert()" );
		return -0x02;
	}

	if( TODODATA_TYPE_TASK == p_tparent->b_type )	{
		p_tlist	= ToDoData_GetToDoData( p_tparent->i_parent );
	}
	else	{
		p_tlist		= p_tparent;
		p_tparent	= NULL;
	}

	i_result	= GLAPI_Task_InsertTask(
						p_tdata->t_data.str_item, p_tdata, p_tlist, p_tprev, p_tparent );
	if( 0x00 > i_result )	{
		SET_ERRINFO1( "Failed function call: GLAPI_Task_InsertTask()", i_result );
		return i_result;
	}

	// Close Unsync flag
	ToDoData_UpdateFlag( p_tdata, (TODODATA_FLAG_UNSYNC_INSERT ^ p_tdata->b_flag) );

	return 0x00;
}

/* -------------------------------------------------------------------*/
static int
	LibToDo_Sync_Move(
			int		i_id )
{
	int				i_result;
	ToDo_Data		*p_ttask	= NULL;
	ToDo_Data		*p_tlist	= NULL;
	ToDo_Data		*p_tparent	= NULL;
	ToDo_Data		*p_tprev	= NULL;

	p_ttask	= ToDoData_GetToDoData( i_id );
	if( p_ttask	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x01;
	}

	p_tparent	= ToDoData_GetToDoData( p_ttask->i_parent );
	if( p_tparent	== NULL )	{
		SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
		return -0x02;
	}

	if( TODODATA_TYPE_TASK == p_tparent->b_type )	{
		p_tlist	= ToDoData_GetToDoData( p_tparent->i_parent );
		if( p_tlist	== NULL )	{
			SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
			return -0x02;
		}
	}
	else
		{ p_tlist	= p_tparent; }
	assert( TODODATA_TYPE_LIST == p_tlist->b_type );

	if( NO_TDATA != p_ttask->i_prev )	{
		p_tprev		= ToDoData_GetToDoData( p_ttask->i_prev );
		if( p_tprev	== NULL )	{
			SET_ERRINFO( "Failed function call: ToDoData_GetToDoData()" );
			return -0x03;
		}
	}

	i_result	= GLAPI_Task_MoveTask( p_ttask, p_tlist, p_tprev, p_tparent );
	if( 0x00 > i_result )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Task_MoveTask()", i_result ); }

	ToDoData_UpdateFlag( p_ttask, (TODODATA_FLAG_UNSYNC_MOVE ^ p_ttask->b_flag) );

	return i_result;
}

/* -------------------------------------------------------------------*/
static int
	LibToDo_Sync_Node(
			int		i_id,
			int		i_parent )
{
	int		i_err	= 0x00;
	int		i_next;
	int		i_prev	= NO_TDATA;
	ToDo_Data	*p_tnow;

	while( NO_TDATA != i_id )	{
		p_tnow	= ToDoData_GetToDoData( i_id );
		i_next	= p_tnow->i_next;

		LibToDo_Sync_Node( p_tnow->i_child, p_tnow->i_id );

		if( TODODATA_FLAG_UNSYNC_DELETE & p_tnow->b_flag )
			{ i_err	= LibToDo_DeleteTask( i_id ); }
		else if( TODODATA_FLAG_UNSYNC_INSERT & p_tnow->b_flag )
			{ i_err = LibToDo_Sync_Insert( p_tnow->i_id ); }
		else if( TODODATA_FLAG_UNSYNC_MOVE & p_tnow->b_flag )
			{ i_err = LibToDo_Sync_Insert( p_tnow->i_id ); }
		else if( TODODATA_FLAG_UNSYNC_STATUS & p_tnow->b_flag )
			{ i_err	= LibToDo_UpdateStatus( i_id, p_tnow->b_status ); }

		if( 0x00 != i_err )
			{ return i_err; }

		i_prev	= i_id;
		i_id	= i_next;
	}

	return 0x00;
}

/* -------------------------------------------------------------------*/
LIBTODO_API_API_EXTERN
int
	LibToDo_Sync(
			void )
{
	int				i_err;

	i_err	= LibToDo_Sync_Node( 0, NO_TDATA );
	if( 0x00 != i_err )	{
		goto	goto_LibToDo_Sync_err;
	}

	ToDoData_SortIndex();

	i_err	= LibToDo_LoadToDoData( TODO_MODE_RELOAD | TODO_MODE_SHOW_ALL );

goto_LibToDo_Sync_err:
	return i_err;
}


/* EOF of main.c ******************************************************/
