/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_PROC_JSON

#include"libtodo_header.h"

/* ===================================================================*/
LIBTODO_PROC_JSON_EXTERN
void
	ProcJson_CutCutDoubleQuote(
			char *pstr_data, int i_max )
{
	int		i_cnt;
	int		i_len;

	i_len	= strnlen( pstr_data, i_max );
	if( 0 == i_len )	{ return; }
	// Cut Double-Quote in String-End.
	if( '"' == *(pstr_data + i_len - 1) )	{
		*(pstr_data + i_len - 1)	= '\0';
		i_len--;
	}

	// Cut Double-Quote in String-Start.
	if( '"' == *(pstr_data + 0) )	{
		for( i_cnt = 0; i_cnt < i_len; i_cnt++ )
			{ *(pstr_data + i_cnt)	= *(pstr_data + i_cnt + 1); }
	}
}


/* ===================================================================*/
LIBTODO_PROC_JSON_EXTERN
json_object *
	ProcJson_GetJsonChildArray(
			json_object *p_parent,
			char		*pstr_aryname )
{
	json_object	*p_json	= NULL;

	json_object_object_foreach( p_parent, key, val)	{
		if(json_object_is_type(val, json_type_array)) {
			if( !strncmp( key, pstr_aryname, 256 ))	{
				p_json	= (json_object *)val;
				goto	goto_ProcJson_GetJsonChildArray_post;
			}
		}
	}

goto_ProcJson_GetJsonChildArray_post:
	return	p_json;
}


/* ===================================================================*/
LIBTODO_PROC_JSON_EXTERN
json_object *
	ProcJson_GetJsonChildObject(
			json_object *p_parent,
			char		*pstr_objname )
{
	json_object	*p_json	= NULL;

	json_object_object_foreach( p_parent, key, val)	{
		if(json_object_is_type(val, json_type_object)) {
			if( !strncmp( key, pstr_objname, 256 ))	{
				p_json	= (json_object *)val;
				goto	goto_ProcJson_GetJsonChildObject_post;
			}
		}
	}

goto_ProcJson_GetJsonChildObject_post:
	return	p_json;
}


/* ===================================================================*/
LIBTODO_PROC_JSON_EXTERN
json_object *
	ProcJson_GetJsonChildString(
			char		*pstr_dest,
			json_object *p_parent,
			char		*pstr_keyname,
			int			i_buflen )
{
	json_object	*p_json	= NULL;

	*(pstr_dest + 0)	= '\0';
	
	json_object_object_foreach( p_parent, key, val)	{
		if(json_object_is_type(val, json_type_string)) {
			if( !strcmp( key, pstr_keyname ))	{
				strncpy( pstr_dest,
						json_object_to_json_string_ext( val, JSON_C_TO_STRING_NOSLASHESCAPE ),
						i_buflen );
				ProcJson_CutCutDoubleQuote( pstr_dest, i_buflen );
				goto	goto_ProcJson_GetJsonChildString_post;
			}
		}
	}

goto_ProcJson_GetJsonChildString_post:
	return	p_json;
}


/* ===================================================================*/
LIBTODO_PROC_JSON_EXTERN
int
	ProcJson_CheckKind(
			json_object *p_json,
			char	*pstr_kind )
{
	int		i_result	= -0x01;

	json_object_object_foreach( p_json, key, val)	{
		if(json_object_is_type(val, json_type_string)) {
			if( !strcmp( key, "kind" ))	{
				if( !strcmp( json_object_to_json_string( val ), pstr_kind) )
					{ i_result	= 0x00; }
				else
					{ i_result	= -0x02; }
				goto	goto_ProcJson_CheckKind_post;
			}
		}
	}

goto_ProcJson_CheckKind_post:
	return i_result;
}


/* ===================================================================*/
LIBTODO_PROC_JSON_EXTERN
int
	ProcJson_GetAPIError(
			char	*pstr_errmsg,
			json_object	*p_jmaster )
{
	int			i_errcode	= 0;
	json_object	*p_json	= NULL;

	*(pstr_errmsg + 0)	= '\0';

	p_json	= ProcJson_GetJsonChildObject( p_jmaster, "error" );
	if( NULL == p_json )	{ goto	goto_ProcJson_GetAPIError_post; }

	json_object_object_foreach( p_json, key, val)	{
		if(json_object_is_type(val, json_type_string)) {
			if( !strncmp( key, "message", 127 ))
				{ strncpy( pstr_errmsg,
						json_object_to_json_string_ext( val, JSON_C_TO_STRING_NOSLASHESCAPE ),
						127 ); }
		}

		if(json_object_is_type(val, json_type_int)) {
			if( !strncmp( key, "code", 256 ))
				{ i_errcode	= json_object_get_int( val ); }
		}
	}
		
goto_ProcJson_GetAPIError_post:
	return i_errcode;
}


/* EOF of main.c ******************************************************/
