/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_TODODATA

#include"libtodo_header.h"

/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_UpdatePosition(
			ToDo_Data	*p_tdata )
{
	int		i_id;
	QWord	qw_position;
	ToDo_Data	*p_tnow;
	ToDo_Data	*p_tprev;

	i_id		= p_tdata->i_id;
	if( NO_TDATA == p_tdata->i_prev )
		{ qw_position	= 0L; }
	else	{
		p_tprev	= (gp_tododata + p_tdata->i_prev);
		qw_position	= p_tprev->qw_position + 1;
	}

	do	{
		p_tnow	= (gp_tododata + i_id);
		p_tnow->qw_position	= qw_position++;
		i_id	= p_tnow->i_next;
	}while( NO_TDATA != i_id );

	return;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_UpdateIndex(
			ToDo_Data	*p_tdata )
{
	int		i_id;
	ToDo_Index	*p_index;

	p_index	= (gp_todoindex + 0);
	for( i_id = 0; i_id < gi_max_tododata; i_id++, p_index++ )	{
		if( p_index->i_id == p_tdata->i_id )
			{ p_index->dw_hash	= p_tdata->dw_hash; }
	}

	return;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_RenewLastUpdated(
			char	*pstr_updated )
{
	QWord	qw_value;

	qw_value	= Common_ConvISO8601toQWord( pstr_updated );
	if( gqw_lastupdated < qw_value )	{
		gqw_lastupdated	= qw_value;
		strncpy( gstr_lastupdated, pstr_updated, 32 );
	}

	return;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
char *
	ToDoData_GetLastUpdated(
			void )
{
	return gstr_lastupdated;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_UpdateFlag(
			ToDo_Data	*p_tdata,
			Byte		b_flag )
{
	assert( NULL != p_tdata );

	p_tdata->b_flag	= b_flag;

	if( TODODATA_FLAG_UNSYNC_MASK & p_tdata->b_flag )
		{ p_tdata->t_data.chr_flag	= '!'; }
	else if( TODODATA_FLAG_SYNCED == p_tdata->b_flag )
		{ p_tdata->t_data.chr_flag	= '*'; }
	else
		{ p_tdata->t_data.chr_flag	= ' '; }

	return;
}


/* ===================================================================*/
void
	ToDoData_UpdateFlag_Node(
			ToDo_Data	*p_tdata,
			Byte		b_flag )
{
	int		i_id;

	assert( NULL != p_tdata );

	i_id	= p_tdata->i_child;
	while( NO_TDATA != i_id )	{
		p_tdata	= (gp_tododata + i_id);
		if( NULL == p_tdata )	{ return; }

		ToDoData_UpdateFlag( p_tdata, b_flag );

		ToDoData_UpdateFlag_Node( p_tdata, b_flag );

		i_id	= p_tdata->i_next;
	}

	return;
}

/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_UpdateFlag_AllToDoData(
			Byte	b_flag )
{
	if( NULL == gp_tododata )	{
		return -0x01;
	}

	ToDoData_UpdateFlag_Node( (gp_tododata + 0), b_flag );

	return 0x00;
}


/* ===================================================================*/
void
	ToDoData_ClearDoneTask_Node(
			ToDo_Data	*p_tdata )
{
	int		i_id;
	ToDo_Data	*p_tlist;

	assert( NULL != p_tdata );

	i_id	= p_tdata->i_child;
	while( NO_TDATA != i_id )	{
		p_tdata	= (gp_tododata + i_id);
		if( NULL == p_tdata )	{ return; }

		i_id	= p_tdata->i_next;

		ToDoData_ClearDoneTask_Node( p_tdata );

		if((TODO_STATUS_COMPLETED & p_tdata->b_status)
				&& (0x00 == (TODODATA_FLAG_UNSYNC_STATUS & p_tdata->b_flag)))	{

			p_tlist	= (gp_tododata + p_tdata->i_parent);
			if( TODODATA_TYPE_TASK == p_tlist->b_type )
				{ p_tlist	= (gp_tododata + p_tlist->i_parent); }
			
			GLAPI_Task_DeleteTask( p_tdata, p_tlist );

			ToDoData_FreeToDoData( p_tdata );
		}
	}

	return;
}

/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_ClearDoneTask(
			void )
{
	if( NULL == gp_tododata )	{
		return -0x01;
	}

	ToDoData_ClearDoneTask_Node( (gp_tododata + 0) );

	return 0x00;
}


/* ===================================================================*/
int
	ToDoData_ReNumberingDataID_Node(
			ToDo_Data	*p_tdata,
			int	i_count )
{
	int		i_id;

	assert( NULL != p_tdata );

	p_tdata->t_data.i_id	= i_count++;

	i_id	= p_tdata->i_child;
	while( NO_TDATA != i_id )	{
		p_tdata	= (gp_tododata + i_id);
		if( NULL == p_tdata )
			{ return i_count; }

		i_count	= ToDoData_ReNumberingDataID_Node( p_tdata, i_count );

		i_id	= p_tdata->i_next;
	}

	return i_count;
}


/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_ReNumberingDataID(
			void )
{
	int			i_id		= 0;
	int			i_count		= 0;
	ToDo_Data	*p_tdata;

	if( NULL == gp_tododata )	{
		return -0x01;
	}

	ToDoData_ReNumberingDataID_Node( (gp_tododata + 0), i_count );

	return 0x00;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_SetStatus(
			ToDo_Data	*p_tdata,
			Byte	b_status )
{
	Byte	b_old;
	assert( NULL != p_tdata );

	b_old	= p_tdata->b_status;

	p_tdata->b_status			= b_status;
	p_tdata->t_data.b_status	= b_status;
	
	if((TODO_STATUS_DELETED & b_old)
			&& (0x00 == (TODO_STATUS_DELETED & b_status))
			&& (TODODATA_FLAG_UNSYNC_DELETE & p_tdata->b_flag))	{
		ToDoData_UpdateFlag( p_tdata, (TODODATA_FLAG_UNSYNC_DELETE ^ p_tdata->b_flag) );
		goto	goto_ToDoData_SetStatus_post;
	}
	else if(TODO_STATUS_DELETED & b_status )	{
		ToDoData_UpdateFlag( p_tdata, (TODODATA_FLAG_UNSYNC_DELETE | p_tdata->b_flag) );
		goto	goto_ToDoData_SetStatus_post;
	}
	
	if((TODO_STATUS_NEEDSACTION & b_status)
			&& (TODO_STATUS_COMPLETED & b_old)
			&& (TODODATA_FLAG_UNSYNC_STATUS & p_tdata->b_flag))
		{ ToDoData_UpdateFlag( p_tdata, (TODODATA_FLAG_UNSYNC_STATUS ^ p_tdata->b_flag) ); }
	else
		{ ToDoData_UpdateFlag( p_tdata, TODODATA_FLAG_UNSYNC_STATUS ); }

goto_ToDoData_SetStatus_post:
	return 0x00;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
ToDo_Data *
	ToDoData_GetToDoData(
			int	i_tdata_id )
{
	ToDo_Data	*p_tdata;

	if(( 0 > i_tdata_id ) || ( gi_alloc_tododata <= i_tdata_id ))	{
		return NULL;
	}

	p_tdata	= (gp_tododata + i_tdata_id);
	if( TODODATA_TYPE_NONE == p_tdata->b_type )	{ p_tdata	= NULL; }

	return p_tdata;
}


/* ===================================================================*/
int
	ToDoData_ReadInCache_Data(
			int		i_fd,
			int		i_parent,
			ToDo_Data	*p_tbuf )
{
	int			i_nowid;
	int			i_err;
	int			i_next;
	Byte		b_flag;
	ToDo_Data	*p_tnow;

	do	{
		i_err	= read( i_fd, p_tbuf, sizeof( ToDo_Data ) );
		if( i_err != (int)sizeof( ToDo_Data ) )	{
			i_err	= errno;
			goto	goto_ToDoData_ReadInCache_Data_post;
		}

		i_nowid	= ToDoData_InsetToDoData( 
						i_parent, p_tbuf->b_type, p_tbuf->str_id, p_tbuf->qw_position );
		if( NO_TDATA == i_nowid )	{
			break;
		}

		p_tnow	= (gp_tododata + i_nowid);

		p_tnow->b_status	= p_tbuf->b_status;
		p_tnow->dw_hash		= p_tbuf->dw_hash;

		//strncpy( p_tnow->str_id, p_tbuf->str_id, 64 );
		strncpy( p_tnow->str_parent, p_tbuf->str_parent, 64 );

		memcpy( &(p_tnow->t_data), &(p_tbuf->t_data), sizeof( LibToDo_Data ) );

		// Clear Sync Flag ---
		b_flag	= p_tbuf->b_flag & TODODATA_FLAG_UNSYNC_MASK;
		ToDoData_UpdateFlag( p_tnow, b_flag );

		i_next	= p_tbuf->i_next;

		// Re-Numbering ID
		//p_tnow->t_data.i_id	= p_tnow->i_id;

		if( NO_TDATA != p_tbuf->i_child )	{
			i_err	= ToDoData_ReadInCache_Data( i_fd, i_nowid, p_tbuf );
		}

	}while( NO_TDATA != i_next );

goto_ToDoData_ReadInCache_Data_post:
	return	i_err;
}

/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_ReadInCache(
			char	*pstr_filepath )
{
	int		i_fd;
	int		i_cnt;
	int		i_err;
	int		i_ret	= 0x00;
	ToDo_CacheHeader	t_cheader;
	ToDo_Data			t_data;

	i_fd	= open( pstr_filepath, O_RDONLY );
	if( -1 == i_fd )	{
		return errno;
	}

	/* Read&Check Header -----*/
	memset( &t_cheader, 0x00, sizeof( ToDo_CacheHeader ) );
	i_err	= read( i_fd, &t_cheader, sizeof( ToDo_CacheHeader ) );
	if( i_err != (int)sizeof( ToDo_CacheHeader ) )	{
		return errno;
	}

	if( memcmp( t_cheader.str_header, "LIBTODO_CACHE__\0", 16 ) )	{
		i_ret	= -0x01;
		goto	goto_ToDoData_ReadInCache_post;
	}

	if( 10 != t_cheader.w_version )	{
		i_ret	= -0x02;
		goto	goto_ToDoData_ReadInCache_post;
	}

	//t_cheader.i_items		= gi_max_tododata;

	ToDoData_FreeToDoData( NULL );	/* All Clear existed-ToDoData */

	strncpy( gstr_lastupdated, t_cheader.str_lastupdate, 32 );
	gqw_lastupdated	= Common_ConvISO8601toQWord( gstr_lastupdated );

	memset( &t_data, 0x00, sizeof( ToDo_Data ) );
	i_err	= read( i_fd, &t_data, sizeof( ToDo_Data ) );
	if( i_err != (int)sizeof( ToDo_Data ) )	{
		i_ret	= errno;
		goto	goto_ToDoData_ReadInCache_post;
	}

	// Check MASTER Data ---
	if( TODODATA_TYPE_MASTER != t_data.b_type )	{
		i_ret	= -0x03;
		goto	goto_ToDoData_ReadInCache_post;
	}

	i_err	= ToDoData_ReadInCache_Data( i_fd, 0, &t_data );

	ToDoData_SortIndex();

	ToDoData_ReNumberingDataID();

goto_ToDoData_ReadInCache_post:
	close( i_fd );

	return 0;
}


/* ===================================================================*/
int
	ToDoData_WriteOut_Tree(
			int			i_fd,
			int			i_id )
{
	int			i_err;
	ToDo_Data	*p_tdata;

	while( NO_TDATA != i_id )	{
		p_tdata	= (gp_tododata + i_id);

		i_err	= write( i_fd, p_tdata, sizeof( ToDo_Data ) );
		if( -1 == i_err )	{
			return errno;
		}

		i_err	= ToDoData_WriteOut_Tree( i_fd, p_tdata->i_child );

		i_id	= p_tdata->i_next;
	}

	return 0;
}

/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_WriteOutCache(
			char	*pstr_filepath )
{
	int		i_fd;
	int		i_err;
	ToDo_CacheHeader	t_cheader;

	i_fd	= open( pstr_filepath, O_WRONLY | O_CREAT, S_IRUSR|S_IWUSR );
	if( -1 == i_fd )	{
		return errno;
	}

	/* WriteOut Header -----*/
	memset( &t_cheader, 0x00, sizeof( ToDo_CacheHeader ) );
	strncpy( t_cheader.str_header, "LIBTODO_CACHE__\0", 16 );
	t_cheader.w_version 	= 10;
	t_cheader.i_items		= gi_max_tododata;
	strncpy( t_cheader.str_lastupdate, gstr_lastupdated, 32 );

	i_err	= write( i_fd, &t_cheader, (size_t)sizeof( ToDo_CacheHeader ) );
	if( -1 == i_fd )	{
		return errno;
	}

	/* WriteOut TreeData ---*/
	ToDoData_WriteOut_Tree( i_fd, 0 );

	close( i_fd );

	return 0;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_SearchParent(
			ToDo_Data	*p_tlist,
			char		*pstr_parent )
{
	int			i_now_id;
	int			i_result	= NO_TDATA;
	DWord		dw_hash;
	ToDo_Data	*p_tdata;

	dw_hash	= Common_CalcDJBhash( pstr_parent );

	i_now_id	= p_tlist->i_child;
	if( NO_TDATA == i_now_id )
		{ goto	goto_ToDoData_SearchParent_post; }

	do	{
		p_tdata	= ToDoData_GetToDoData( i_now_id );
		assert( NULL != p_tdata );

		if( p_tdata->dw_hash == dw_hash )	{
			if( !strncmp( p_tdata->str_id, pstr_parent, 64 ) )	{
				i_result	= p_tdata->i_id;
				break;
			}
		}

		i_now_id	= p_tdata->i_next;
	}while( NO_TDATA != i_now_id );

goto_ToDoData_SearchParent_post:
	return i_result;
}


/* ===================================================================*/
int
	ToDoData_SearchData_Recursion(
			char	*pstr_id,
			DWord	dw_hash,
			int		i_start,
			int		i_end )
{
	int			i_pos;
	ToDo_Data	*p_tdata;

	i_pos	= (i_start + i_end) / 2;

	if( dw_hash == (gp_todoindex + i_pos)->dw_hash )	{
		p_tdata	= (gp_tododata + ((gp_todoindex + i_pos)->i_id));
		if( !strncmp( pstr_id, p_tdata->str_id, 64) )
			{ return p_tdata->i_id; }
	}
	if( i_start >= i_end )	{ return NO_TDATA; }

	if( dw_hash < (gp_todoindex + i_pos)->dw_hash )	{
		return ToDoData_SearchData_Recursion( pstr_id, dw_hash, i_start, (i_pos - 1));
	}
	//else if( dw_hash >= (gp_todoindex + i_pos)->dw_hash )
		return ToDoData_SearchData_Recursion( pstr_id, dw_hash, (i_pos + 1), i_end );
}


/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_SearchData(
			char	*pstr_id )
{
	DWord	dw_hash;

	if(NULL == pstr_id)		{ return NO_TDATA; }
	if('\0' == *pstr_id)	{ return NO_TDATA; }

	dw_hash	= Common_CalcDJBhash( pstr_id );

	return ToDoData_SearchData_Recursion( pstr_id, dw_hash, 0, (gi_max_tododata - 1));
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_ClearToDoData(
			ToDo_Data	*p_tdata )
{
	int		i_id;

	i_id	= p_tdata->i_id;
	memset( p_tdata, 0x00, sizeof( ToDo_Data ) );

	p_tdata->i_id		= i_id;
	p_tdata->i_parent	= NO_TDATA;
	p_tdata->i_child	= NO_TDATA;
	p_tdata->i_prev		= NO_TDATA;
	p_tdata->i_next		= NO_TDATA;

	p_tdata->t_data.i_id	= i_id;

	return;
}


/* ===================================================================*/
int
	ToDoData_CompareIndex(
			const void *pv_index1, const void *pv_index2 )
{
	ToDo_Index	*p_tindex1;
	ToDo_Index	*p_tindex2;

	p_tindex1	= (ToDo_Index *)pv_index1;
	p_tindex2	= (ToDo_Index *)pv_index2;

	if( p_tindex1->dw_hash < p_tindex2->dw_hash )
		{ return -1; }
	else if( p_tindex1->dw_hash > p_tindex2->dw_hash )
		{ return 1; }

	return 0;
}

/* -------------------------------------------------------------------*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_SortIndex(
			void )
{
	qsort( gp_todoindex, (gi_max_tododata - 1), sizeof(ToDo_Index), ToDoData_CompareIndex );

	return;
}


/* ===================================================================*/
ToDo_Data *
	ToDoData_AllocToDoData(
			char	*pstr_id )
{
	int			i_cnt;	
	int			i_new_allocs;
	int			i_stop;
	ToDo_Data	*p_tmaster;
	ToDo_Data	*p_ttemp;
	ToDo_Data	*p_tdata;
	ToDo_Index	*p_tindex;

	// Extend ToDo_Data Buffer ---
	if( NO_TDATA == gi_empty_chain )	{
		assert( gi_max_tododata == gi_alloc_tododata );

		i_new_allocs	= (gi_alloc_tododata + TODODATA_ALLOC_UNITS);
		p_tmaster	= (ToDo_Data *)realloc( gp_tododata,
							(sizeof( ToDo_Data ) * i_new_allocs) );
		if( NULL == p_tmaster )	{
			SET_ERRINFO( "Not enough memory!" );
			return NULL;
		}

		p_tindex	= (ToDo_Index *)realloc( gp_todoindex,
							(sizeof( ToDo_Index ) * i_new_allocs ));
		if( NULL == p_tindex )	{
			SET_ERRINFO( "Not enough memory!" );
			return NULL;
		}

		i_stop				= gi_alloc_tododata;
		gp_tododata			= p_tmaster;
		gp_todoindex		= p_tindex;
		gi_alloc_tododata	= i_new_allocs;

		for( i_cnt = (gi_alloc_tododata - 1); i_stop <= i_cnt; i_cnt-- )	{
			p_ttemp	=  gp_tododata + i_cnt;
			ToDoData_ClearToDoData( p_ttemp );

			p_ttemp->i_id			= i_cnt;
			p_ttemp->t_data.i_id	= i_cnt;

			ToDoData_InsertEmptyChain( p_ttemp );
		}
	}

	assert( NO_TDATA != gi_empty_chain );

	p_tdata			= (gp_tododata + gi_empty_chain);
	gi_empty_chain	= p_tdata->i_next;
	p_tdata->i_next	= NO_TDATA;

	// Regist Index ---
	if( NULL != pstr_id )	{
		strncpy( p_tdata->str_id, pstr_id, 64 );
		strncpy( p_tdata->t_data.str_id, pstr_id, 64 );
		p_tdata->dw_hash	= Common_CalcDJBhash( p_tdata->str_id );

		(gp_todoindex + (gi_max_tododata - 1))->dw_hash	= p_tdata->dw_hash;
		(gp_todoindex + (gi_max_tododata - 1))->i_id	= p_tdata->i_id;
	}

	gi_max_tododata++;

	return p_tdata;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_AppendChain(
		int		i_tdata,
		int		i_parent,
		Byte	b_type,
		QWord	qw_position )
{
	ToDo_Data	*p_tdata;
	ToDo_Data	*p_tnow;
	ToDo_Data	*p_tnext	= NULL;
	ToDo_Data	*p_tprev	= NULL;
	ToDo_Data	*p_tparent;

	// Check Self ToDo_Data ---
	if( NO_TDATA == i_tdata )	{
		SET_ERRINFO( "Invalid param.(i_tdata is NO_TDATA)" );
		return -0x01;
	}
	p_tdata	= gp_tododata + i_tdata;

	// Check Parent ToDo_Data ---
	if( NO_TDATA == i_parent )	{
		SET_ERRINFO( "Invalid param.(i_parent is NO_TDATA)" );
		return -0x02;
	}
	p_tparent	= gp_tododata + i_parent;
	assert( NULL != p_tparent );

	if( TODODATA_TYPE_NONE == p_tparent->b_type )	{
		return -0x02;
	}

	// Append ToDo_Data in Parent-ToDo_Data ---
	p_tnow		= ((NO_TDATA == p_tparent->i_child) ? NULL : (gp_tododata + p_tparent->i_child));

	if( NULL == p_tnow )	{
		p_tparent->i_child		= p_tdata->i_id;
		p_tdata->i_parent		= i_parent;
		p_tdata->b_type			= b_type;
		p_tdata->qw_position	= qw_position;
		goto	goto_ToDoData_AppendChain_post;
	}

	p_tnext	= p_tnow;
	if( TODODATA_POSITION_TOP == qw_position )	{
		p_tprev	= NULL;
	}
	else	{
		do	{
			if( qw_position < p_tnext->qw_position )	{ break; }

			p_tprev	= p_tnext;
			p_tnext	= ((NO_TDATA != p_tprev->i_next) ? (gp_tododata + p_tprev->i_next) : NULL);
		}while( NULL != p_tnext );
	}

	if( NULL != p_tprev )	{ p_tprev->i_next	= p_tdata->i_id; }
	p_tdata->i_prev	= ((NULL != p_tprev) ? p_tprev->i_id : NO_TDATA);

	if( NULL != p_tnext )	{ p_tnext->i_prev	= p_tdata->i_id; }
	p_tdata->i_next	= ((NULL != p_tnext) ? p_tnext->i_id : NO_TDATA);

	p_tdata->i_parent		= i_parent;
	if( NULL != p_tnext )	{
		if( p_tparent->i_child == p_tnext->i_id )
			{ p_tparent->i_child	= p_tdata->i_id; }
	}

	p_tdata->b_type			= b_type;
	p_tdata->qw_position	= ((TODODATA_POSITION_TOP == qw_position) ? 0L : qw_position);

goto_ToDoData_AppendChain_post:
	return p_tdata->i_id;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_InsetToDoData(
		int		i_parent,
		Byte	b_type,
		char	*pstr_id,
		QWord	qw_position )
{
	int			i_id;
	int			i_result;
	ToDo_Data	*p_tdata;

	if( NULL != pstr_id )	{
		i_id	= ToDoData_SearchData( pstr_id );
		if( NO_TDATA != i_id )
			{ return i_id; }
	}

	// Alloc ToDo_Data ---
	p_tdata	= ToDoData_AllocToDoData( pstr_id );
	if( NULL == p_tdata )	{
		SET_ERRINFO( "Failed function call: ToDoData_AllocToDoData()" );
		return -0x03;
	}

	i_result	= ToDoData_AppendChain( p_tdata->i_id, i_parent, b_type, qw_position );
	if( 0x00 > i_result )	{
		SET_ERRINFO( "Failed function call: ToDoData_AppendChain()" );
		ToDoData_FreeToDoData( p_tdata );
		return -0x02;
	}

	return p_tdata->i_id;
}


/* ===================================================================*/
void
	ToDoData_InsertEmptyChain(
			ToDo_Data	*p_tdata )
{
	p_tdata->i_next	= gi_empty_chain;
	gi_empty_chain	= p_tdata->i_id;

	p_tdata->b_type	= TODODATA_TYPE_NONE;

	return;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_DisConnectChain(
			ToDo_Data	*p_tdata )
{
	int			i_parent;
	int			i_prev;
	int			i_next;
	ToDo_Data	*p_tparent;
	ToDo_Data	*p_tprev;
	ToDo_Data	*p_tnext;
	ToDo_Data	*p_ttemp;

	// Set Now ToDoData Links ---
	i_parent	= p_tdata->i_parent;
	i_prev		= p_tdata->i_prev;
	i_next		= p_tdata->i_next;

	// DisConnect Parent ---
	p_tparent	= ((NO_TDATA == i_parent) ? NULL : (gp_tododata + i_parent));
	if( NULL != p_tparent )	{
		if( p_tdata->i_id == p_tparent->i_child )	{
			p_ttemp	= ((NO_TDATA == i_next) ? NULL : (gp_tododata + i_next));
			if( NULL == p_ttemp )	
				{ p_ttemp	= ((NO_TDATA == i_prev) ? NULL : (gp_tododata + i_prev)); }
	
			if( NULL != p_ttemp )	{
				assert( p_tparent->i_id == p_ttemp->i_parent );
				p_tparent->i_child	= p_ttemp->i_id;
			}
			else	{
				p_tparent->i_child	= NO_TDATA;
			}
		}

		p_tdata->i_parent	= NO_TDATA;
	}


	// DisConnect Prev-Next ----
	p_tprev	= ((NO_TDATA == i_prev) ? NULL : (gp_tododata + i_prev));
	p_tnext	= ((NO_TDATA == i_next) ? NULL : (gp_tododata + i_next));

	if( NULL != p_tprev )	{ p_tprev->i_next	= i_next; }
	if( NULL != p_tnext )	{ p_tnext->i_prev	= i_prev; }

	p_tdata->i_prev	= NO_TDATA;
	p_tdata->i_next	= NO_TDATA;

	assert( NO_TDATA == p_tdata->i_parent );
	assert( NO_TDATA == p_tdata->i_child );
	assert( NO_TDATA == p_tdata->i_prev );
	assert( NO_TDATA == p_tdata->i_next );

	return;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_FreeToDoData(
			ToDo_Data	*p_tdata )
{
	int			i_cnt;
	int			i_child;
	ToDo_Data	*p_tnow;
	ToDo_Data	*p_tchild;
	ToDo_Index	*p_tindex;

	if( NULL == p_tdata )
		{ p_tdata	= (gp_tododata + 0); }	// Master ToDoData

	if( 0 != p_tdata->i_id )	{
		// DisConnect Child ---
		while( NO_TDATA != p_tdata->i_child )	{
			i_child		= p_tdata->i_child;
			p_tchild	= (gp_tododata + i_child);
			assert( NULL != p_tchild );
			ToDoData_FreeToDoData( p_tchild );
		}

		ToDoData_DisConnectChain( p_tdata );

		// Delete Index ---
		// XXX: None TESTED
		for( i_cnt = 0; i_cnt < (gi_max_tododata - 1); i_cnt++ )	{
			p_tindex	= (gp_todoindex + i_cnt);
			if( p_tindex->i_id	== p_tdata->i_id )	{
				bcopy( (gp_todoindex + (i_cnt + 1)), (gp_todoindex + i_cnt),
						(sizeof(ToDo_Index) * (gi_max_tododata - i_cnt - 2)));
				break;
			}
		}

		if( TODODATA_TYPE_MASTER != p_tdata->b_type )	{
			ToDoData_InsertEmptyChain( p_tdata );

			gi_max_tododata--;
		}
		return;
	}

	// for Free Master-Object ---
	if( 0 == gi_max_tododata )	{ return; }

	gi_empty_chain	= NO_TDATA;
	for( i_cnt = gi_alloc_tododata; 0 < i_cnt; i_cnt-- )	{
		p_tnow	= gp_tododata + i_cnt;
		ToDoData_ClearToDoData( p_tnow );
		ToDoData_InsertEmptyChain( p_tnow );
	}

	// Index All Clear ---
	memset( gp_todoindex, 0x00, sizeof( ToDo_Index ) * TODODATA_ALLOC_UNITS );

	// Regist Master ToDo_Data (ID = 0) ---
	p_tnow	= gp_tododata + 0;
	ToDoData_ClearToDoData( p_tnow );
	p_tnow->b_type		= TODODATA_TYPE_MASTER;
	p_tnow->i_id		= 0;
	p_tnow->t_data.i_id	= 0;

	gi_max_tododata	= 1;

	// Init lastupdated ---
	gqw_lastupdated		= 0;
	gstr_lastupdated[0]	= '\0';

	return;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
int
	ToDoData_Init( void )
{
	int			i_cnt;
	ToDo_Data	*p_tmaster;
	ToDo_Data	*p_tdata;
	ToDo_Index	*p_tindex;

	p_tmaster	= (ToDo_Data *)malloc( sizeof( ToDo_Data ) * TODODATA_ALLOC_UNITS );
	if( NULL == p_tmaster )	{
		SET_ERRINFO( "Not engouh memory." );
		return -0x01;
	}

	p_tindex	= (ToDo_Index *)malloc( sizeof( ToDo_Index ) * TODODATA_ALLOC_UNITS );
	if( NULL == p_tindex )	{
		SET_ERRINFO( "Not engouh memory." );
		return -0x02;
	}

	gp_tododata			= p_tmaster;
	gp_todoindex		= p_tindex;
	gi_alloc_tododata	= TODODATA_ALLOC_UNITS;
	gi_max_tododata		= 0;

	gi_empty_chain		= NO_TDATA;
	gi_topdata			= NO_TDATA;

	// Regist Master ToDo_Data (ID = 0) ---
	p_tdata			= gp_tododata + 0;
	ToDoData_ClearToDoData( p_tdata );
	p_tdata->i_id			= 0;
	p_tdata->t_data.i_id	= 0;

	p_tdata->b_type	= TODODATA_TYPE_MASTER;
	gi_topdata		= p_tdata->i_id;
	gi_max_tododata++;

	// Init lastupdated ---
	gqw_lastupdated		= 0;
	gstr_lastupdated[0]	= '\0';

	// Other ToDo_Data (ID > 1) is append Empty-Chain ---
	for( i_cnt = (gi_alloc_tododata - 1); 0 < i_cnt; i_cnt-- )	{
		p_tdata	= gp_tododata + i_cnt;
		ToDoData_ClearToDoData( p_tdata );

		p_tdata->i_id	= i_cnt;

		ToDoData_InsertEmptyChain( p_tdata );
	}

	memset( gp_todoindex, 0x00, sizeof( ToDo_Index ) * TODODATA_ALLOC_UNITS );

	return 0x00;
}


/* ===================================================================*/
LIBTODO_TODODATA_EXTERN
void
	ToDoData_Term( void )
{
	if(( NULL == gp_tododata ) || ( NULL == gp_todoindex ))	{
		SET_ERRINFO( "Invalid condition.(Not memory alloc)" );
 		return;
	}

	free( gp_tododata );
	gp_tododata			= NULL;

	free( gp_todoindex );
	gp_todoindex		= NULL;

	gi_alloc_tododata	= 0;
	gi_max_tododata		= 0;
	gi_empty_chain		= NO_TDATA;
	gi_topdata			= NO_TDATA;

	return;
}


/* EOF of main.c ******************************************************/
