/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_LIBTODO_COMMON

#include"libtodo_header.h"

/* ===================================================================*/
LIBTODO_COMMON_EXTERN
QWord
	Common_ConvISO8601toQWord( char *pstr_src )
{
	/* 2019-11-17T12:04:45.000Z  -> 20191117120445000 */

	int		i_len;
	QWord	qw_value	= 0;
	char	str_buf[32];

	i_len	= strnlen( pstr_src, 32 );
	if( 24 > i_len )	{
		return 0;
	}
	strncpy( str_buf, pstr_src, 31 );

	str_buf[ 4]	= '\0';
	str_buf[ 7]	= '\0';
	str_buf[10]	= '\0';
	str_buf[13]	= '\0';
	str_buf[16]	= '\0';
	str_buf[19]	= '\0';
	str_buf[23]	= '\0';

	qw_value	+= Common_ConvStr2QWord( str_buf +  0 ) * 10000000000000;
	qw_value	+= Common_ConvStr2QWord( str_buf +  5 ) *   100000000000;
	qw_value	+= Common_ConvStr2QWord( str_buf +  8 ) *     1000000000;
	qw_value	+= Common_ConvStr2QWord( str_buf + 11 ) *       10000000;
	qw_value	+= Common_ConvStr2QWord( str_buf + 14 ) *         100000;
	qw_value	+= Common_ConvStr2QWord( str_buf + 17 ) *           1000;
	qw_value	+= Common_ConvStr2QWord( str_buf + 20 );

	return qw_value;
}


/* ===================================================================*/
LIBTODO_COMMON_EXTERN
QWord
	Common_ConvStr2QWord( char *pstr_src )
{
	int		i_len;
	QWord	qw_value	= 0;

	i_len	= strnlen( pstr_src, 20 );

	for( ; 0 < i_len; i_len-- )
		{ qw_value	= (10 * qw_value) + (*pstr_src++ - '0'); }

	return qw_value;
}


/* ===================================================================*/
LIBTODO_COMMON_EXTERN
DWord
	Common_CalcDJBhash( char *pstr_src )
{
	DWord	dw_value;
	Byte	b_temp;

	dw_value    = 5381;

	for( b_temp = *pstr_src; '\0' != b_temp; b_temp = *++pstr_src )
		{ dw_value	= ( dw_value * 33 ) + b_temp; }

	return dw_value;
}


/* ===================================================================*/
LIBTODO_COMMON_EXTERN
int
	Common_URL_Encode(
			char	*pstr_data,
			int		i_size )
{
	char	*pstr_tmpencode;
	char	*pstr_alloc;
	CURL	*p_curl;

	pstr_alloc	= (char *)alloca( i_size );
	assert( NULL != pstr_alloc );

	p_curl = curl_easy_init();
	if( NULL == p_curl )	{
		SET_ERRINFO( "curl_easy_init() failed." );
		return -0x01;
	}

	strncpy( pstr_alloc, pstr_data, i_size );

	pstr_tmpencode	= curl_easy_escape( p_curl, pstr_alloc, i_size );
	if( NULL == pstr_tmpencode )	{
		SET_ERRINFO( "curl_easy_escape() failed." );
		return -0x02;
	}

	strncpy( pstr_data, pstr_tmpencode, i_size );

	curl_easy_cleanup( p_curl );

	return 0x00;
}


/* EOF of main.c ******************************************************/
