/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_GLAPI_BASE

#include"libtodo_header.h"

/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
void
	GLAPI_Base_ClearResultArea(
			GLAPI_Result	*p_glresult,
			Byte			b_flag)
{
	if( NULL == p_glresult )	{
		SET_ERRINFO( "Invalid Param.(p_glresult == NULL)" );
		return;
	}

	if( 0x00 == ( GLAPI_CLRFLG_RETRY & b_flag ))	{
		memset( p_glresult->pb_request, 0x00, 32768 );
		p_glresult->sz_request	= 0;
	}

	memset( p_glresult->pb_result, 0x00, p_glresult->sz_alloc );
	p_glresult->sz_size		= 0;
	p_glresult->l_response	= 0;
	
	return;
}


/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
GLAPI_Result *
	GLAPI_Base_AllocResultArea(
			GLAPI_Result	*p_glresult )
{
	Byte	*pb_result;
	Byte	*pb_request;

	if( NULL == p_glresult )	{
		SET_ERRINFO( "Invalid Param.(p_glresult == NULL)" );
		return NULL;
	}

	pb_request	= (Byte *)malloc( 32768 );
	if( NULL == pb_request )	{
		SET_ERRINFO( "Not enough memory.(pb_request)" );
		return NULL;
	}

	pb_result	= (Byte *)malloc( 32768 );
	if( NULL == pb_result )	{
		SET_ERRINFO( "Not enough memory.(pb_result)" );
		free( pb_request );
		return NULL;
	}

	p_glresult->pb_request	= pb_request;

	p_glresult->pb_result	= pb_result;
	p_glresult->sz_alloc	= 32768;

	GLAPI_Base_ClearResultArea( p_glresult, GLAPI_CLRFLG_NONE );

	return	p_glresult;
}

/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
void
	GLAPI_Base_FreeResultArea(
			GLAPI_Result	*p_glresult )
{
	if( NULL == p_glresult )	{
		SET_ERRINFO( "Invalid Param.(p_glresult == NULL)" );
		return;
	}

	free( p_glresult->pb_request );
	p_glresult->pb_request	= NULL;
	p_glresult->sz_request	= 0;

	free( p_glresult->pb_result );
	p_glresult->pb_result	= NULL;
	p_glresult->sz_size		= 0;
	p_glresult->sz_alloc	= 0;
	p_glresult->l_response	= 0;
	
	return;
}


/* ===================================================================*/
static size_t
	GLAPI_Base_ReadCallBack(
			void *pv_ptr, size_t sz_blksize, size_t sz_blknum, void *pv_glrequest )
{
	size_t	sz_read;

	sz_read	= strnlen( (const char *)pv_glrequest, 32768 );
	memcpy( (Byte *)pv_ptr, (Byte *)pv_glrequest, (sz_read + 1) );

	return sz_read;
}


/* ===================================================================*/
size_t
	GLAPI_Base_WriteCallBack(
			void *pv_ptr, size_t sz_blksize, size_t sz_blknum, void *pv_glresult )
{
	size_t	sz_size;
	Byte			*pb_data;
	GLAPI_Result	*p_glresult;

	sz_size	= sz_blksize * sz_blknum;
	if( 0 == sz_size )	{ return 0; }

	p_glresult	= (GLAPI_Result *)pv_glresult;

	if( p_glresult->sz_alloc < (p_glresult->sz_size + sz_size + 1) )	{
		pb_data	= (Byte *)realloc( p_glresult->pb_result, (p_glresult->sz_size + sz_size + 1) );
		if( NULL == pb_data )	{
			SET_ERRINFO( "Not enough re-alloc memory.(pb_data)" );
			return 0;
		}

		p_glresult->pb_result	= pb_data;
		p_glresult->sz_alloc	= p_glresult->sz_size + sz_size + 1;
	}

	assert( NULL != p_glresult->pb_result );

	memcpy( (p_glresult->pb_result + p_glresult->sz_size), pv_ptr, sz_size );
	p_glresult->sz_size	+= sz_size;
	*(p_glresult->pb_result + p_glresult->sz_size)	= '\0';

	return sz_size;
}


/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
int
	GLAPI_Base_SendAPI(
			GLAPI_Result	*p_glresult,
			Byte	b_mode,
			char	*pstr_url,
			char	*pstr_header )
{
	int					i_postlen;
	CURL				*p_curl;
	CURLcode			curl_res;
	struct curl_slist	*curl_slist;

	curl_slist	= NULL;
	if( NULL != pstr_header )	{
		curl_slist	= curl_slist_append( curl_slist, pstr_header );
	}

	p_curl	= curl_easy_init();
	if( NULL == p_curl )	{
		SET_ERRINFO( "curl_easy_init() failed." );
		return -0x01;
	}

	curl_easy_setopt( p_curl, CURLOPT_BUFFERSIZE, 102400L);
	curl_easy_setopt( p_curl, CURLOPT_URL, pstr_url );

	if( SENDAPI_MODE_POST & b_mode )	{
		curl_easy_setopt( p_curl, CURLOPT_POST, 1L );
		i_postlen	= strnlen( (const char *)p_glresult->pb_request, 32768 );
		curl_easy_setopt( p_curl, CURLOPT_POSTFIELDS, (char *)p_glresult->pb_request );
		curl_easy_setopt( p_curl, CURLOPT_POSTFIELDSIZE_LARGE, (curl_off_t)i_postlen );

		if( SENDAPI_BODY_JSON & b_mode )	{
			curl_slist_append( curl_slist, HTTP_HEADER_CONTENT_TYPE );
			curl_slist_append( curl_slist, HTTP_HEADER_CHARSETS );
			//curl_slist_append( curl_slist, "Accept-Encoding: gzip" );
			curl_slist_append( curl_slist, "User-Agent: todocmd (gzip)" );
		}
	}
	else if( SENDAPI_MODE_PUT & b_mode )	{
		i_postlen	= strnlen( (const char *)p_glresult->pb_request, 32768 );
		curl_easy_setopt( p_curl, CURLOPT_PUT, 1L );
		curl_easy_setopt( p_curl, CURLOPT_READFUNCTION, GLAPI_Base_ReadCallBack );
		curl_easy_setopt( p_curl, CURLOPT_READDATA, (void *)p_glresult->pb_request );
		curl_easy_setopt( p_curl, CURLOPT_INFILESIZE_LARGE, (curl_off_t)i_postlen );

		curl_slist_append( curl_slist, HTTP_HEADER_ACCEPT );
		curl_slist_append( curl_slist, HTTP_HEADER_CONTENT_TYPE );
		curl_slist_append( curl_slist, HTTP_HEADER_CHARSETS );
		curl_slist_append( curl_slist, "Accept-Encoding: gzip" );
		curl_slist_append( curl_slist, "User-Agent: todocmd (gzip)" );
	}
	else if( SENDAPI_MODE_DELETE & b_mode )	{
		curl_easy_setopt( p_curl, CURLOPT_CUSTOMREQUEST, "DELETE" );
	}

	if( NULL != pstr_header )
		{ curl_easy_setopt( p_curl, CURLOPT_HTTPHEADER, curl_slist ); }

	curl_easy_setopt( p_curl, CURLOPT_WRITEFUNCTION, GLAPI_Base_WriteCallBack );
	curl_easy_setopt( p_curl, CURLOPT_WRITEDATA, (void *)p_glresult );

	curl_easy_setopt( p_curl, CURLOPT_USERAGENT, HTTP_HEADER_USERAGENT );
	curl_easy_setopt( p_curl, CURLOPT_MAXREDIRS, 50L);
	curl_easy_setopt( p_curl, CURLOPT_HTTP_VERSION, (long)CURL_HTTP_VERSION_2TLS );
	curl_easy_setopt( p_curl, CURLOPT_TCP_KEEPALIVE, 1L);

	curl_res	= curl_easy_perform( p_curl );
	if( curl_res )	{
		SET_ERRINFO1( curl_easy_strerror( curl_res ), (int)curl_res );
		return (-100 - ((int)curl_res));
	}

    curl_easy_getinfo( p_curl, CURLINFO_RESPONSE_CODE, &(p_glresult->l_response) );

	curl_easy_cleanup( p_curl );

	if( NULL != pstr_header )
		{ curl_slist_free_all( curl_slist ); }

	return 0x00;
}


/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
int
	GLAPI_Base_RefreshToken(
			void )
{
	int				i_result;
	json_object		*p_json;
	json_object		*p_jerr;
	GLAPI_Result	t_glrefresh;
	char			str_err[64];

    GLAPI_Base_AllocResultArea( &t_glrefresh );

	snprintf( (char *)t_glrefresh.pb_request, 32767,
				LIBTODO_GL_REFRESH_PARAM, gt_config.str_refresh_token,
				gt_config.str_client_id, gt_config.str_client_secret );

    i_result    = GLAPI_Base_SendAPI( &t_glrefresh, SENDAPI_MODE_POST, LIBTODO_GL_TOKEN_URI, NULL );
	if( 0 > i_result )	{
		SET_ERRINFO1( "Failed function call: GLAPI_Base_SendAPI()", i_result );
		return i_result;
	}

	p_json		= json_tokener_parse( (const char *)t_glrefresh.pb_result );
	p_jerr	= ProcJson_GetJsonChildString( str_err, p_json, JSON_KEY_GLAPI_ERROR, 64 );
	if( NULL == p_jerr )	{ 
		ProcJson_GetJsonChildString(
				gt_config.str_access_token, p_json, JSON_KEY_GLAPI_ACCESS_TOKEN, 256 );
		ProcJson_GetJsonChildString(
				gt_config.str_token_type, p_json, JSON_KEY_GLAPI_TOKEN_TYPE, 64 );
	}

	json_object_put( p_json );

	GLAPI_Base_FreeResultArea( &t_glrefresh );

	return 0x00;
}


/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
int
	GLAPI_Base_GetToken(
			void )
{
	int				i_result;
	json_object		*p_json;
	json_object		*p_jerr;
	GLAPI_Result	t_glrefresh;
	char			str_err[64];

    GLAPI_Base_AllocResultArea( &t_glrefresh );

	snprintf( (char *)t_glrefresh.pb_request, 32767,
				LIBTODO_GL_GETTOKEN_PARAM, gt_config.str_code, gt_config.str_client_id,
				gt_config.str_client_secret );

    i_result    = GLAPI_Base_SendAPI( &t_glrefresh, SENDAPI_MODE_POST, LIBTODO_GL_TOKEN_URI, NULL );
	if( 0 > i_result )	{
		SET_ERRINFO1( "Failed function call: GLAPI_Base_SendAPI()", i_result );
		return i_result;
	}

	p_json		= json_tokener_parse( (const char *)t_glrefresh.pb_result );

	p_jerr	= ProcJson_GetJsonChildString( str_err, p_json, JSON_KEY_GLAPI_ERROR, 64 );
	if( NULL == p_jerr )	{ 
		ProcJson_GetJsonChildString(
				gt_config.str_access_token, p_json, JSON_KEY_GLAPI_ACCESS_TOKEN, 256 );
		ProcJson_GetJsonChildString(
				gt_config.str_refresh_token, p_json, JSON_KEY_GLAPI_REFRESH_TOKEN, 256 );
		ProcJson_GetJsonChildString(
				gt_config.str_token_type, p_json, JSON_KEY_GLAPI_TOKEN_TYPE, 64 );
	}

	json_object_put( p_json );

	GLAPI_Base_FreeResultArea( &t_glrefresh );

	return 0x00;
}


/* ===================================================================*/
LIBTODO_GLAPI_BASE_EXTERN
int
	GLAPI_Base_DoAPI(
			GLAPI_Result	*p_glresult,
			Byte	b_mode,
			char	*pstr_url )
{
	int		i_result;
	char	str_header[256];

	snprintf( str_header, 256, HTTP_HEADER_GLAUTH"%s %s",
					gt_config.str_token_type, gt_config.str_access_token );

	i_result	= GLAPI_Base_SendAPI( p_glresult, b_mode, pstr_url, str_header );
	if( 0 > i_result )	{
		SET_ERRINFO1( "Failed function call: GLAPI_Base_SendAPI()", i_result );
		return i_result;
	}

	if( 401 == p_glresult->l_response )	{
		i_result	= GLAPI_Base_RefreshToken();
		if( 0 > i_result )	{
			SET_ERRINFO1( "Failed function call: GLAPI_Base_Refresh_Token()", i_result );
			return i_result;
		}

		GLAPI_Base_ClearResultArea( p_glresult, GLAPI_CLRFLG_RETRY );

		snprintf( str_header, 256,  HTTP_HEADER_GLAUTH"%s %s",
					gt_config.str_token_type, gt_config.str_access_token );

		i_result	= GLAPI_Base_SendAPI( p_glresult, b_mode, pstr_url, str_header );
		if( 0 > i_result )	{
			SET_ERRINFO1( "Failed function call: GLAPI_Base_SendAPI()", i_result );
			return i_result;
		}
	}

	return	0x00;
}


/* EOF of main.c ******************************************************/
