/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#ifndef	LIBTODO_HEADER_GLAPI_BASE
#define	LIBTODO_HEADER_GLAPI_BASE

#ifdef LIBTODO_SRC_GLAPI_BASE
	#define LIBTODO_GLAPI_BASE_EXTERN
#else
	#define LIBTODO_GLAPI_BASE_EXTERN	extern
#endif

#define	LIBTODO_GL_REDIRECT_URI		"urn:ietf:wg:oauth:2.0:oob"
#define	LIBTODO_GL_TOKEN_URI		"https://www.googleapis.com/oauth2/v4/token"

#define	LIBTODO_GL_REFRESH_PARAM	"refresh_token=%s&client_id=%s&client_secret=%s&grant_type=refresh_token"
#define	LIBTODO_GL_GETTOKEN_PARAM	"code=%s&client_id=%s&client_secret=%s&redirect_uri=urn%%3Aietf%%3Awg%%3Aoauth%%3A2.0%%3Aoob&grant_type=authorization_code&access_type=offline"

#define HTTP_HEADER_CONTENT_TYPE	"Content-Type: application/json"
#define HTTP_HEADER_CHARSETS		"charsets: utf-8"
#define HTTP_HEADER_ACCEPT			"Accept: application/json"
#define HTTP_HEADER_USERAGENT		"curl/7.66.0"
#define	HTTP_HEADER_GLAUTH			"Authorization: "

#define	GLAPI_CLRFLG_NONE	0x00
#define	GLAPI_CLRFLG_RETRY	0x01

#define	SENDAPI_MODE_GET	0x00
#define	SENDAPI_MODE_POST	0x01
#define	SENDAPI_MODE_PUT	0x02
#define	SENDAPI_MODE_DELETE	0x04

#define	SENDAPI_BODY_RAW	0x00
#define	SENDAPI_BODY_JSON	0x10

LIBTODO_GLAPI_BASE_EXTERN
	void GLAPI_Base_ClearResultArea( GLAPI_Result *p_glresult, Byte b_flag );
LIBTODO_GLAPI_BASE_EXTERN
	GLAPI_Result *GLAPI_Base_AllocResultArea( GLAPI_Result *p_glresult );
LIBTODO_GLAPI_BASE_EXTERN
	void GLAPI_Base_FreeResultArea( GLAPI_Result *p_glresult );
LIBTODO_GLAPI_BASE_EXTERN
	int GLAPI_Base_SendAPI( GLAPI_Result *p_glresult, Byte b_mode, char *pstr_url, char *pstr_header );
LIBTODO_GLAPI_BASE_EXTERN
	int GLAPI_Base_RefreshToken( void );
LIBTODO_GLAPI_BASE_EXTERN
	int GLAPI_Base_GetToken( void );
LIBTODO_GLAPI_BASE_EXTERN
	int GLAPI_Base_DoAPI( GLAPI_Result *p_glresult, Byte b_mode, char *pstr_url );

#endif

/* EOF of main.c ******************************************************/
