/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	TEST_LIBTODO_SRC_TODODATA
#include"libtodo_header.h"
#include"test_libtodo.h"

/* ===================================================================*/
void Test_LibToDo_ToDoData_test00_001( void )
{
	int		i_err;
	int		i_cnt;
	int		i_id;
	ToDo_Data	*p_tdata;

	i_err	= ToDoData_Init();
	CU_ASSERT( 0x00  == i_err );

	// Check Master-ToDo_Data ---
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( NO_TDATA == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	// Alloc & Check ToDo-Data ----
	for( i_cnt = 1; i_cnt < TODODATA_ALLOC_UNITS; i_cnt++ )	{
		i_id	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, NULL, TODODATA_APPEND );
		p_tdata	= ToDoData_GetToDoData( i_id );
		CU_ASSERT( NULL != p_tdata );
		CU_ASSERT( i_cnt == p_tdata->i_id );
		CU_ASSERT( TODODATA_TYPE_LIST == p_tdata->b_type );
		CU_ASSERT( 0 == p_tdata->i_parent );
		CU_ASSERT( NO_TDATA == p_tdata->i_child );
	}
	
	// Delete Master-ToDo-Data ---
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( 1 == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	ToDoData_FreeToDoData( p_tdata );

	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( NO_TDATA == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );


	// Alloc & Check ToDo-Data ----
	for( i_cnt = 1; i_cnt < TODODATA_ALLOC_UNITS; i_cnt++ )	{
		i_id	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, NULL, TODODATA_APPEND );
		p_tdata	= ToDoData_GetToDoData( i_id );
		CU_ASSERT( NULL != p_tdata );
		CU_ASSERT( i_cnt == p_tdata->i_id );
		CU_ASSERT( TODODATA_TYPE_LIST == p_tdata->b_type );
		CU_ASSERT( 0 == p_tdata->i_parent );
		CU_ASSERT( NO_TDATA == p_tdata->i_child );
	}
	
	// Delete Master-ToDo-Data ---
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( 1 == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	ToDoData_FreeToDoData( p_tdata );

	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( NO_TDATA == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	ToDoData_Term();

	return;
}


/* ===================================================================*/
void Test_LibToDo_ToDoData_test00_000( void )
{
	int		i_err;
	int		i_cnt;
	int		i_id;
	ToDo_Data	*p_tdata;

	i_err	= ToDoData_Init();
	CU_ASSERT( 0x00  == i_err );

	// Check Master-ToDo_Data ---
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( NO_TDATA == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	// Alloc & Check ToDo-Data ----
	for( i_cnt = 1; i_cnt < (TODODATA_ALLOC_UNITS * 2); i_cnt++ )	{
		i_id	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, NULL, TODODATA_APPEND );
		p_tdata	= ToDoData_GetToDoData( i_id );
		CU_ASSERT( NULL != p_tdata );
		CU_ASSERT( i_cnt == p_tdata->i_id );
		CU_ASSERT( TODODATA_TYPE_LIST == p_tdata->b_type );
		CU_ASSERT( 0 == p_tdata->i_parent );
		CU_ASSERT( NO_TDATA == p_tdata->i_child );
	}

	// Check ToDo-Data Horizon Links ---
	for( i_cnt = 1; i_cnt < TODODATA_ALLOC_UNITS * 2; i_cnt++ )	{
		p_tdata	= ToDoData_GetToDoData( i_cnt );
		CU_ASSERT( NULL != p_tdata );
		CU_ASSERT( i_cnt == p_tdata->i_id );
		CU_ASSERT( TODODATA_TYPE_LIST == p_tdata->b_type );
		CU_ASSERT( 0 == p_tdata->i_parent );
		CU_ASSERT( NO_TDATA == p_tdata->i_child );
		CU_ASSERT( p_tdata->i_prev == ((i_cnt == 1) ? NO_TDATA : i_cnt - 1) );
		CU_ASSERT( p_tdata->i_next ==
						((i_cnt == ((TODODATA_ALLOC_UNITS * 2) - 1)) ? NO_TDATA : i_cnt + 1 ) );
	}

	// Delete & Check ToDo-Data ---
	for( i_cnt = 1; i_cnt < (TODODATA_ALLOC_UNITS * 2); i_cnt++ )	{
		p_tdata	= ToDoData_GetToDoData( i_cnt );
		CU_ASSERT( NULL != p_tdata );
		CU_ASSERT( i_cnt == p_tdata->i_id );
		CU_ASSERT( TODODATA_TYPE_LIST == p_tdata->b_type );
		CU_ASSERT( 0 == p_tdata->i_parent );
		CU_ASSERT( NO_TDATA == p_tdata->i_child );
		CU_ASSERT( p_tdata->i_prev == NO_TDATA );
		CU_ASSERT( p_tdata->i_next ==
						((i_cnt == ((TODODATA_ALLOC_UNITS * 2) - 1)) ? NO_TDATA : i_cnt + 1 ) );

		ToDoData_FreeToDoData( p_tdata );
	}

	// Check Master-ToDo_Data ---
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( NO_TDATA == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	ToDoData_Term();

	return;
}


/* ===================================================================*/
void Test_LibToDo_ToDoData_test01_000( void )
{
	int		i_err;
	int		i_id;
	ToDo_Data	*p_tdata;

	i_err	= ToDoData_Init();
	CU_ASSERT( 0x00  == i_err );

	// Check Master-ToDo_Data ---
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( NULL != p_tdata );
	CU_ASSERT( TODODATA_TYPE_MASTER == p_tdata->b_type );
	CU_ASSERT( NO_TDATA == p_tdata->i_parent );
	CU_ASSERT( NO_TDATA == p_tdata->i_child );
	CU_ASSERT( NO_TDATA == p_tdata->i_prev );
	CU_ASSERT( NO_TDATA == p_tdata->i_next );

	/*
		0+- 1+- 3
		 |     +- 4+- 5
		 |     |     +- 6
		 |     |
		 |     +- 7
		 |
		 +- 2+- 8+-13
		 |     |     +-14
		 |     |
		 |     +- 9
		 |
		 +-10+-11
			   +-12
	*/

	// Alloc & Check ToDo-Data ----
	// ID=  1
	i_id	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  1 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  2
	i_id	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  2 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  1 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  3
	i_id	= ToDoData_InsetToDoData(  1, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  3 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  4
	i_id	= ToDoData_InsetToDoData(  1, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  4 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  3 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  5
	i_id	= ToDoData_InsetToDoData(  4, TODODATA_TYPE_SUB, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  5 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  4 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  6
	i_id	= ToDoData_InsetToDoData(  4, TODODATA_TYPE_SUB, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  6 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  4 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  5 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  7
	i_id	= ToDoData_InsetToDoData(  1, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  7 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  4 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  8
	i_id	= ToDoData_InsetToDoData(  2, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  8 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  2 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  9
	i_id	= ToDoData_InsetToDoData(  2, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id ==  9 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  2 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  8 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID= 10
	i_id	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id == 10 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  2 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID= 11
	i_id	= ToDoData_InsetToDoData( 10, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id == 11 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent == 10 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID= 12
	i_id	= ToDoData_InsetToDoData( 10, TODODATA_TYPE_TASK, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id == 12 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent == 10 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == 11 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID= 13
	i_id	= ToDoData_InsetToDoData(  8, TODODATA_TYPE_SUB, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id == 13 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  8 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID= 14
	i_id	= ToDoData_InsetToDoData(  8, TODODATA_TYPE_SUB, NULL, TODODATA_APPEND );
	p_tdata	= ToDoData_GetToDoData( i_id );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->i_id == 14 );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  8 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == 13 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	/*
		0+- 1+- 3
		 |     +- 4+- 5
		 |     |     +- 6
		 |     |
		 |     +- 7
		 |
		 +- 2+- 8+-13
		 |     |     +-14
		 |     |
		 |     +- 9
		 |
		 +-10+-11
			   +-12
	*/
	// ID= 0 
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_MASTER );
	CU_ASSERT( p_tdata->i_parent == NO_TDATA );
	CU_ASSERT( p_tdata->i_child ==  1 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  1
	p_tdata	= ToDoData_GetToDoData(  1 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child ==  3 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  2 );

	// ID=  2
	p_tdata	= ToDoData_GetToDoData(  2 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child ==  8 );
	CU_ASSERT( p_tdata->i_prev ==  1 );
	CU_ASSERT( p_tdata->i_next == 10 );

	// ID= 10
	p_tdata	= ToDoData_GetToDoData( 10 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child == 11 );
	CU_ASSERT( p_tdata->i_prev ==  2 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );


	// ID=  3
	p_tdata	= ToDoData_GetToDoData(  3 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  4 );

	// ID=  4
	p_tdata	= ToDoData_GetToDoData(  4 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child ==  5 );
	CU_ASSERT( p_tdata->i_prev ==  3 );
	CU_ASSERT( p_tdata->i_next ==  7 );

	// ID=  7
	p_tdata	= ToDoData_GetToDoData(  7 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  4 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// ID=  5
	p_tdata	= ToDoData_GetToDoData(  5 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  4 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  6 );

	// ID=  6
	p_tdata	= ToDoData_GetToDoData(  6 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  4 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev ==  5 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );


	// ID=  8
	p_tdata	= ToDoData_GetToDoData(  8 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  2 );
	CU_ASSERT( p_tdata->i_child == 13 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  9 );

	// ID=  9
	p_tdata	= ToDoData_GetToDoData(  8 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  2 );
	CU_ASSERT( p_tdata->i_child == 13 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  9 );

	// ID= 13
	p_tdata	= ToDoData_GetToDoData( 13 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  8 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == 14 );

	// ID= 14
	p_tdata	= ToDoData_GetToDoData( 14 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  8 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == 13 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );


	// ID= 11
	p_tdata	= ToDoData_GetToDoData( 11 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent == 10 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == 12 );

	// ID= 12
	p_tdata	= ToDoData_GetToDoData( 12 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent == 10 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == 11 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	/*
		0+- 1+- 3
		 |     +- 4+- 5
		 |     |     +- 6
		 |     |
		 |     +- 7
		 |
		 +- 2+- 8+-13
		 |     |     +-14
		 |     |
		 |     +- 9
		 |
		 +-10+-11
			   +-12

	     6 -> 13 ->  2 ->  3 -> 0
	*/

	// Delete=  6
	p_tdata	= ToDoData_GetToDoData(  6 );
	ToDoData_FreeToDoData( p_tdata );
	// Check is  5
	p_tdata	= ToDoData_GetToDoData(  5 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  4 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// Delete= 13
	p_tdata	= ToDoData_GetToDoData( 13 );
	ToDoData_FreeToDoData( p_tdata );
	// Check is  8
	p_tdata	= ToDoData_GetToDoData(  8 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  2 );
	CU_ASSERT( p_tdata->i_child == 14 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  9 );
	// Check is 14
	p_tdata	= ToDoData_GetToDoData( 14 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_SUB );
	CU_ASSERT( p_tdata->i_parent ==  8 );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );

	// Delete=  2
	p_tdata	= ToDoData_GetToDoData(  2 );
	ToDoData_FreeToDoData( p_tdata );
	// Check is  1 
	p_tdata	= ToDoData_GetToDoData(  1 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child ==  3 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == 10 );
	// Check is 10
	p_tdata	= ToDoData_GetToDoData( 10 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child == 11 );
	CU_ASSERT( p_tdata->i_prev ==  1 );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );
	// Check is 13
	p_tdata	= ToDoData_GetToDoData( 13 );
	CU_ASSERT( p_tdata == NULL );
	// Check is 14
	p_tdata	= ToDoData_GetToDoData( 14 );
	CU_ASSERT( p_tdata == NULL );
	// Check is  8
	p_tdata	= ToDoData_GetToDoData(  8 );
	CU_ASSERT( p_tdata == NULL );
	// Check is  9
	p_tdata	= ToDoData_GetToDoData(  9 );
	CU_ASSERT( p_tdata == NULL );
	// Check is  2
	p_tdata	= ToDoData_GetToDoData(  2 );
	CU_ASSERT( p_tdata == NULL );

	// Delete=  3
	p_tdata	= ToDoData_GetToDoData(  3 );
	ToDoData_FreeToDoData( p_tdata );
	// Check is  1 
	p_tdata	= ToDoData_GetToDoData(  1 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_LIST );
	CU_ASSERT( p_tdata->i_parent == 0 );
	CU_ASSERT( p_tdata->i_child ==  4 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == 10 );
	// Check is  4
	p_tdata	= ToDoData_GetToDoData(  4 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_TASK );
	CU_ASSERT( p_tdata->i_parent ==  1 );
	CU_ASSERT( p_tdata->i_child ==  5 );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next ==  7 );
	// Check is  3
	p_tdata	= ToDoData_GetToDoData(  3 );
	CU_ASSERT( p_tdata == NULL );

	// Delete= 0 (AllClear)
	p_tdata	= ToDoData_GetToDoData( 0 );
	ToDoData_FreeToDoData( p_tdata );
	// Check is 0
	p_tdata	= ToDoData_GetToDoData( 0 );
	CU_ASSERT( p_tdata != NULL );
	CU_ASSERT( p_tdata->b_type == TODODATA_TYPE_MASTER );
	CU_ASSERT( p_tdata->i_parent == NO_TDATA );
	CU_ASSERT( p_tdata->i_child == NO_TDATA );
	CU_ASSERT( p_tdata->i_prev == NO_TDATA );
	CU_ASSERT( p_tdata->i_next == NO_TDATA );
	// Check is  4
	p_tdata	= ToDoData_GetToDoData(  4 );
	CU_ASSERT( p_tdata == NULL );
	// Check is  5
	p_tdata	= ToDoData_GetToDoData(  5 );
	CU_ASSERT( p_tdata == NULL );
	// Check is 7
	p_tdata	= ToDoData_GetToDoData( 7 );
	CU_ASSERT( p_tdata == NULL );
	// Check is  1
	p_tdata	= ToDoData_GetToDoData(  1 );
	CU_ASSERT( p_tdata == NULL );
	// Check is 10
	p_tdata	= ToDoData_GetToDoData( 10 );
	CU_ASSERT( p_tdata == NULL );
	// Check is 11
	p_tdata	= ToDoData_GetToDoData( 11 );
	CU_ASSERT( p_tdata == NULL );
	// Check is 12
	p_tdata	= ToDoData_GetToDoData( 12 );
	CU_ASSERT( p_tdata == NULL );


	ToDoData_Term();

	return;
}

/* ===================================================================*/
TEST_LIBTODO_TODODATA_EXTERN
int
	Test_LibToDo_ToDoData( void )
{
	CU_pSuite	pt_todocmd;

	pt_todocmd	= CU_add_suite( "LibToDo_ToDoData", NULL, NULL );

	CU_add_test( pt_todocmd, "ToDoData_test00_000", Test_LibToDo_ToDoData_test00_000 );
	CU_add_test( pt_todocmd, "ToDoData_test00_001", Test_LibToDo_ToDoData_test00_001 );

	CU_add_test( pt_todocmd, "ToDoData_test01_000", Test_LibToDo_ToDoData_test01_000 );

	return 0x00;
}


/* EOF of main.c ******************************************************/
