/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	TODOCMD_SRC_MAIN
#include"todocmd.h"


/* ===================================================================*/
void
	Copyright(
		void )	{
	fputs( "todocmd: Command-Line & ncurses Google Tasks/Todo Client.\n", stderr );
	fprintf( stderr, " Version 0.9.0 (Build: %s %s)\n", __DATE__, __TIME__ );
	fputs( " Copyright(C) 2019- Koine Yuusuke(koinec@users.osdn.me).\n",
			stderr );
	fputs( " This software presented by 2-clause FreeBSD License.\n\n", stderr );
	return;
}


/* ===================================================================*/
void
	Usage(
		DWord	dw_mode )	{
	
	switch( dw_mode )	{
		case MODE_CMD_LIST:
			fputs( " usage: todocmd l [option]\n", stderr );
			fputs( " usage: todocmd list [option]\n", stderr );
			fputs( "   Print out ToDo-List\n", stderr );
			fputs( "     [option]\n", stderr );
			fputs( "       -r                       : ReLoad Task from Google.\n", stderr );
			fputs( "       -a                       : PrintOut Completed Task.\n", stderr );
			fputs( "       -ra                      : ReLoad & PrintOut Completed Task.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_ADD:
			fputs( " usage: todocmd a [option] <Title> [Prev. Task Num / TaskID] [List ID]\n", stderr );
			fputs( " usage: todocmd add [option] <Title> [Prev. Task Num / TaskID] [List ID]\n", stderr );
			fputs( "   Add Task to TaskList \n", stderr );
			fputs( "     [option]\n", stderr );
			fputs( "       -c                       : Insert Task as child of Prev. Task.\n", stderr );
			fputs( "       -s                       : Sync to Google.\n", stderr );
			fputs( "       -cs                      : (Both -c & -s option)\n", stderr );
			fputs( "\n", stderr );
			fputs( "   * If omit [List ID], the task add to the Default TaskList (e.g. MyTask).\n", stderr );
			fputs( "   * If omit [Prev.Task Num / TaskID], add the task to the top of the Default TaskList.\n", stderr );
			fputs( "   * If omit [Prev.Task Num / TaskID], add the task to the top of the Default TaskList.\n", stderr );
			fputs( "   * If you want to add task as a SubTask at the top of the task, or task at the top of\n"
				   "     the indicate TaskList, sppecify the -c option.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_DONE:
			fputs( " usage: todocmd d [option] <Task Num / TaskID>\n", stderr );
			fputs( " usage: todocmd done [option] <Task Num / TaskID>\n", stderr );
			fputs( "   Done (Complete) Task (Set Done flag to indicate task.)\n", stderr );
			fputs( "     [option]\n", stderr );
			fputs( "       -s                       : Sync to Google.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_UNDO:
			fputs( " usage: todocmd u [option] <Task Num / TaskID>\n", stderr );
			fputs( " usage: todocmd undo [option] <Task Num / TaskID>\n", stderr );
			fputs( "   Rewind Done (Completed) & Erased Task\n", stderr );
			fputs( "     [option]\n", stderr );
			fputs( "       -s                       : Sync to Google.\n", stderr );
			fputs( "\n", stderr );
			fputs( "   * This command can only undo completed tasks before executing the Clear command,\n"
				   "     and delete tasks that are not reflected in Google.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_ERASE:
			fputs( " usage: todocmd e [option] <Task Num / TaskID>\n", stderr );
			fputs( " usage: todocmd erase [option] <Task Num / TaskID>\n", stderr );
			fputs( "   Erase(delete) Indicate Task. (Set Erase(Delete) flag to Task.)\n", stderr );
			fputs( "     [option]\n", stderr );
			fputs( "       -s                       : Sync to Google.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_MOVE:
			fputs( " usage: todocmd m [option] <Task Num / TaskID> <Prev. Task Num / TaskID>\n", stderr );
			fputs( " usage: todocmd move [option] <Task Num / TaskID> <Prev. Task Num / TaskID>\n", stderr );
			fputs( "   Move Task\n", stderr );
			fputs( "     [option]\n", stderr );
			fputs( "       -c                       : Move Task as child of Prev. Task.\n", stderr );
			fputs( "       -s                       : Sync to Google.\n", stderr );
			fputs( "       -cs                      : (Both -c & -s option)\n", stderr );
			fputs( "\n", stderr );
			fputs( "   * If you want to move task as a SubTask at the top of the task, or task at the top of\n"
				   "     the indicate TaskList, sppecify the -c option.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_CLEAR:
			fputs( " usage: todocmd c\n", stderr );
			fputs( " usage: todocmd clear\n", stderr );
			fputs( "   Clear Done(Completed) Task\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_CMD_SYNC:
			fputs( " usage: todocmd s\n", stderr );
			fputs( " usage: todocmd sync\n", stderr );
			fputs( "   Sync ToDo-List with Google.\n"
				   "   (Reflect changes such as Add / Erase / Done on the local cache to Google.)\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_IMPORT:
			fputs( " usage: todocmd i <JSON file path of Client Secret from Google Cloud>\n", stderr );
			fputs( " usage: todocmd import <JSON file path of Client Secret from Google Cloud>\n", stderr );
			fputs( "   Import client-secret Json file ([filename] is JSON filename)\n", stderr );
			fputs( "\n", stderr );
			fputs( "   * This command MUST be run as the root user.\n", stderr );
			fputs( "   * After execution, todocmd.conf file will be created under the /usr/local/etc dir.\n", stderr );
			fputs( "   * This command only needs to be run once after installation on your machine.\n", stderr );
			fputs( "\n", stderr );
			break;

		case MODE_REGIST:
			fputs( " usage: todocmd r\n", stderr );
			fputs( " usage: todocmd regist\n", stderr );
			fputs( "   Setup todocmd on each user.\n"
				   "   (Generate Setup-URL & Regist Authorization-Code)\n", stderr );
			fputs( "\n", stderr );
			fputs( "   * This command needs to be executed for each user who uses todocmd.\n", stderr );
			fputs( "   * When executed, the URL will be displayed.\n", stderr );
			fputs( "     Please Copy and paste this URL into your Web browser, and approve the use\n"
				   "     of todocmd on the displayed Google site. \n", stderr );
			fputs( "     After approval, the verification code will be displayed on the screen.\n"
				   "     Please Enter it at the prompt displayed and press the Enter key.\n", stderr );
			fputs( "   * After execution, a .todocmd file will be created under your home directory.\n", stderr );
			fputs( "\n", stderr );
			break;

		default:
			fputs( " usage: todocmd <command> [option] [filename/Task Num./Task ID]\n", stderr );
			fputs( "   <command>\n", stderr );
			fputs( "     [CommandLine Mode]\n", stderr );
			fputs( "       list     / l             :  Print out ToDo-List\n", stderr );
			fputs( "       add      / a             :  Add Task\n", stderr );
			fputs( "       done     / d             :  Done (Complete) Task\n", stderr );
			fputs( "       undo     / u             :  Rewind Done (Completed) Task\n", stderr );
			fputs( "       erase    / e             :  Erase(delete) Task\n", stderr );
			fputs( "       move     / m             :  Move Task\n", stderr );
			fputs( "       clear    / c             :  Clear Done(Completed) Task\n", stderr );
			fputs( "       sync     / s             :  Sync ToDo-List\n", stderr );
			fputs( "     [Setup Mode]\n", stderr );
			fputs( "       import   / i             :  "
					"import client-secret Json file ([filename] is JSON filename)\n", stderr );
			fputs( "       regist   / r             :  "
					"Setup todocmd (Generate Setup-URL & Regist Authorization-Code)\n", stderr );
			fputs( "   [option]\n", stderr );
			fputs( "       -h : Help (This Message)\n", stderr );
			fputs( "\n", stderr );
			break;
	}

	return;
}


/* ===================================================================*/
int
	ParseMode(
			int		*pi_opt,
			char	*argv[],
			DWord	dw_mode,
			int		i_len,
			int		i_args,
			int		i_params,
			char	*pstr_modestr,
			DWord	dw_modeval)
{
	char	c_modechr;

	if( 1 < *pi_opt )	{ return dw_mode; }

	c_modechr	= *(pstr_modestr + 0);

	if( c_modechr == *(argv[*pi_opt] + 0) )	{
		if( 1 == i_len )	{
			dw_mode	= dw_modeval;
			*pi_opt	+= 1;
		}
		else	{
			if( !strcmp( argv[*pi_opt], pstr_modestr ))	{
				dw_mode	= dw_modeval;
				*pi_opt	+= 1;
			}
		}
	}

	if( 1 < *pi_opt )	{
		if( (i_args - *pi_opt) < i_params )	{
			dw_mode	|= MODE_HELP;
		}
	}

	return dw_mode;
}


/* ===================================================================*/
int main(
		int argc,
		char *argv[] )	{

	int		i_cnt;
	int		i_len;
	int		i_opt;
	int		i_result;
	char	*pstr_param[4];
	Byte	b_option;
	DWord	dw_mode		= MODE_NCURSES;
	DWord	dw_option	= OPTION_NONE;

	pstr_param[0]	= NULL;
	pstr_param[1]	= NULL;
	pstr_param[2]	= NULL;
	pstr_param[3]	= NULL;

	Copyright();
	
	if( 1 < argc )	{
		i_opt	= 1;

		// Recognize Mode ----------------------
		i_len	= strlen( argv[i_opt] );
		
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "ncurses", MODE_NCURSES );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "list", MODE_CMD_LIST );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 1, "add", MODE_CMD_ADD );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 1, "done", MODE_CMD_DONE );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 1, "undo", MODE_CMD_UNDO );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "erase", MODE_CMD_ERASE );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "move", MODE_CMD_MOVE );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "clear", MODE_CMD_CLEAR );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "sync", MODE_CMD_SYNC );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 1, "import", MODE_IMPORT );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "regist", MODE_REGIST );
		dw_mode	= ParseMode( &i_opt, argv, dw_mode, i_len, argc, 0, "help", MODE_HELP );

		// Recognize Option ----
		for( ; ((i_opt < argc) && ( '-' == *(argv[i_opt] + 0 ))); i_opt++ )	{

			i_len	= strlen( argv[i_opt] );
			for( i_len-- ; 0 < i_len; i_len-- )	{
				if( 'h' == *(argv[i_opt] + i_len) )
					{ dw_mode	|= MODE_HELP; }
				else if( 'a' == *(argv[i_opt] + i_len) )
					{ dw_option	|= OPTION_LIST_ALL; }
				else if( 'c' == *(argv[i_opt] + i_len) )
					{ dw_option	|= OPTION_ADD_CHILD; }
				else if( 's' == *(argv[i_opt] + i_len) )
					{ dw_option	|= OPTION_SYNC; }
				else if( 'r' == *(argv[i_opt] + i_len) )
					{ dw_option	|= OPTION_RELOAD; }
				else
					{ dw_mode	|= MODE_HELP; }
			}
		}

		for( i_cnt = 0; ((i_opt < argc) && ( 4 > i_cnt )); i_opt++, i_cnt++ )
			{ pstr_param[i_cnt]	= argv[i_opt]; }
	}
	else
		{ dw_mode	= MODE_HELP; }

	// Handling Mode ---
	if( MODE_HELP & dw_mode )	{
		Usage( MODE_HELP ^ dw_mode );
		return 0x00;
	}

	i_result	= Common_InitLibiconv( NULL );
	if( 0x00 != i_result )	{
		return 0x02;
	}

	i_result	= LibToDo_Init();
	if( 0x00 != i_result )	{
		return 0x01;
	}

	LibToDo_ReadToDoCache( NULL );

	switch( dw_mode )	{
		case MODE_NCURSES:
			break;
		case MODE_CMD_LIST:
			if( OPTION_SYNC & dw_option )	{
				b_option	= (( OPTION_LIST_ALL & dw_option )
								? TODO_MODE_SHOW_ALL :  TODO_MODE_SHOW_NORMAL )
							  | (( OPTION_RELOAD & dw_option )
								? TODO_MODE_RELOAD :  TODO_MODE_UPDATE );
				i_result	= LibToDo_LoadToDoData( b_option );
				if( 0x00 > i_result )	{
					return 0x03;
				}
			}
			PrintToDo_Print( dw_option );
			break;
		case MODE_CMD_ADD:
			Scenery_AddTask( pstr_param[0], pstr_param[2], pstr_param[1], dw_option );
			break;
		case MODE_CMD_DONE:
			Scenery_CompleteTask( pstr_param[0], dw_option );
			break;
		case MODE_CMD_UNDO:
			Scenery_UndoCompleteTask( pstr_param[0], dw_option );
			break;
		case MODE_CMD_ERASE:
			Scenery_DeleteTask( pstr_param[0], dw_option );
			break;
		case MODE_CMD_MOVE:
			Scenery_MoveTask( pstr_param[0], pstr_param[1], dw_option );
			break;
		case MODE_CMD_CLEAR:
			LibToDo_ClearToDoData();
			break;
		case MODE_CMD_SYNC:
			LibToDo_Sync();
			break;
		case MODE_IMPORT:
			Setup_ImportClientJson( pstr_param[0] );
			break;
		case MODE_REGIST:
			i_result	= Setup_RegistScenery();
			break;
		default:
			break;
	}

	LibToDo_PrintErrorInfo();

	LibToDo_WriteToDoCache( NULL );

	i_result	= Common_TermLibiconv();
	if( 0x00 != i_result )	{
		return 0x03;
	}

	LibToDo_Term();

	return 0x00;
}


/* EOF of main.c ******************************************************/
