/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel.CallbackThread;
import jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel.L10n;
import org.omegat.core.Core;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.gui.UIThreadsUtil;

public class ExcelModel {
    private static final String WSF_NAME = "HTMLinExcel.wsf";
    private static final File wsf;
    private static String windowTitle;
    private static int installedExcelVersion;
    public static final int INSTALLED_VERSION_NOT_FOUND = -1;

    static void exportHTML() {
        new Thread(){

            @Override
            public void run() {
                try {
                    final Command command = new Command();
                    command.setOutCallback(new Runnable(){

                        @Override
                        public void run() {
                            String OUT_COMMAND_PREFIX_EXPORTED_COUNT = "### ExportedCount ";
                            String s = command.getAndClearStdout();
                            if (!s.isEmpty()) {
                                String[] split;
                                for (String line : split = s.split("\\n")) {
                                    if (line.startsWith("### ExportedCount ")) {
                                        String exportedCount = line.substring("### ExportedCount ".length());
                                        final int i = Integer.parseInt(exportedCount);
                                        if (i <= 0) continue;
                                        UIThreadsUtil.executeInSwingThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                String msg = L10n.getExportedMessage().replace("{0}", String.valueOf(i));
                                                Core.getMainWindow().showMessageDialog(msg);
                                            }
                                        });
                                        continue;
                                    }
                                    Log.log(s);
                                }
                            }
                        }
                    });
                    command.setErrCallback(new Runnable(){

                        @Override
                        public void run() {
                            String s = command.getAndClearStderr();
                            if (!s.isEmpty()) {
                                Log.log(s);
                            }
                        }
                    });
                    int ret = command.execExportHTML();
                    if (!command.getStderr().isEmpty()) {
                        Log.log("Fail to export HTMLs. error(" + ret + "): " + command.getAndClearStderr());
                    }
                    if (!command.getStdout().isEmpty()) {
                        Log.log("Exporting HTMLs has completed. return(" + ret + "): " + command.getAndClearStderr());
                    }
                    ExcelModel.onExcelApplicationQuit(ret);
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
                catch (InterruptedException ex) {
                    Log.log(ex);
                }
            }
        }.start();
    }

    static void importHTML() {
        new Thread(){

            @Override
            public void run() {
                try {
                    final Command command = new Command();
                    command.setOutCallback(new Runnable(){

                        @Override
                        public void run() {
                            String s = command.getAndClearStdout();
                            if (!s.isEmpty()) {
                                Log.log(s);
                            }
                        }
                    });
                    command.setErrCallback(new Runnable(){

                        @Override
                        public void run() {
                            String s = command.getAndClearStderr();
                            if (!s.isEmpty()) {
                                Log.log(s);
                            }
                        }
                    });
                    int ret = command.execImportHTML();
                    if (!command.getStderr().isEmpty()) {
                        Log.log("Fail to import HTMLs. error(" + ret + "): " + command.getAndClearStderr());
                    }
                    if (!command.getStdout().isEmpty()) {
                        Log.log("Importing HTMLs has completed. return(" + ret + "): " + command.getAndClearStderr());
                    }
                    ExcelModel.onExcelApplicationQuit(ret);
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
                catch (InterruptedException ex) {
                    Log.log(ex);
                }
            }
        }.start();
    }

    private ExcelModel() {
    }

    public static int getInstalledExcelVersion() {
        return installedExcelVersion;
    }

    public static void setWindowTitle(String title) {
        windowTitle = title;
    }

    private static void initInstalledExcelVersion() {
        boolean RET_OK = false;
        int ver = -1;
        try {
            String s;
            String EXCEL_VER_KEY = "Excel.Application\\CurVer";
            Command command = new Command();
            if (0 == command.execDOS("assoc", "Excel.Application\\CurVer") && (s = command.getStdout()).startsWith("Excel.Application\\CurVer=Excel.Application.")) {
                String versionString = s.substring("Excel.Application\\CurVer=Excel.Application.".length()).replace("\r\n", "");
                ver = Integer.parseInt(versionString);
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
        installedExcelVersion = ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getWSF() throws IOException {
        if (!wsf.exists()) {
            InputStream in = ExcelModel.class.getResourceAsStream(WSF_NAME);
            try {
                LFileCopy.copy(in, wsf);
            }
            finally {
                in.close();
            }
        }
        wsf.deleteOnExit();
        return wsf;
    }

    private static void onExcelApplicationQuit(int returnCode) {
        ExcelModel.deleteWSF();
    }

    public static void close() {
        ExcelModel.deleteWSF();
    }

    private static void deleteWSF() {
        if (wsf.exists()) {
            wsf.delete();
        }
    }

    static {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        wsf = new File(tempDir, WSF_NAME);
        ExcelModel.initInstalledExcelVersion();
    }

    protected static class Command {
        private int exitCode = 0;
        private CallbackThread outThread;
        private CallbackThread errThread;
        private Runnable outCallback;
        private Runnable errCallback;
        private String stdout;
        private String stderr;

        public void setOutCallback(Runnable callback) {
            this.outCallback = callback;
        }

        public void setErrCallback(Runnable callback) {
            this.errCallback = callback;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getAndClearStdout() {
            String ret = this.stdout;
            this.stdout = "";
            return ret;
        }

        public String getAndClearStderr() {
            String ret = this.stderr;
            this.stderr = "";
            return ret;
        }

        public int exec(String ... command) throws IOException, InterruptedException {
            return this.startProcessAndWait(Arrays.asList(command));
        }

        public int execDOS(String ... command) throws IOException, InterruptedException {
            ArrayList<String> commands = new ArrayList<String>(command.length + 2);
            commands.add("cmd.exe");
            commands.add("/c");
            commands.addAll(Arrays.asList(command));
            return this.startProcessAndWait(commands);
        }

        public int execWSF(String job, String ... command) throws IOException, InterruptedException {
            String script = ExcelModel.getWSF().getCanonicalPath();
            ArrayList<String> commands = new ArrayList<String>(command.length + 4);
            commands.add("cscript.exe");
            commands.add("//nologo");
            commands.add("//Job:" + job);
            commands.add(script);
            commands.addAll(Arrays.asList(command));
            return this.startProcessAndWait(commands);
        }

        public int execExportHTML() throws IOException, InterruptedException {
            String script = ExcelModel.getWSF().getCanonicalPath();
            String sourceFolder = Core.getProject().getProjectProperties().getSourceRoot();
            String targetFolder = "";
            String extWorkbook = "xlsx";
            String extHtml = "html";
            boolean forceExportAllFiles = false;
            boolean deleteHtmlAfterImport = true;
            String worksheetName = "";
            boolean windowVisible = true;
            String altAppCaption = L10n.getExcelAltApplicationCaption();
            ArrayList<String> commands = new ArrayList<String>(6);
            commands.add("cscript.exe");
            commands.add("//nologo");
            commands.add(script);
            commands.add("/sourceFolder:\"" + sourceFolder + "\"");
            commands.add("/windowVisible" + (windowVisible ? "+" : "-"));
            commands.add("/altAppCaption:\"" + altAppCaption + "\"");
            return this.startProcessAndWait(commands);
        }

        public int execImportHTML() throws IOException, InterruptedException {
            String script = ExcelModel.getWSF().getCanonicalPath();
            String sourceFolder = "";
            String targetFolder = Core.getProject().getProjectProperties().getTargetRoot();
            String extWorkbook = "xlsx";
            String extHtml = "html";
            boolean forceExportAllFiles = false;
            boolean deleteHtmlAfterImport = true;
            String worksheetName = "";
            boolean windowVisible = true;
            String altAppCaption = L10n.getExcelAltApplicationCaption();
            ArrayList<String> commands = new ArrayList<String>(6);
            commands.add("cscript.exe");
            commands.add("//nologo");
            commands.add(script);
            commands.add("/targetFolder:\"" + targetFolder + "\"");
            commands.add("/windowVisible" + (windowVisible ? "+" : "-"));
            commands.add("/altAppCaption:\"" + altAppCaption + "\"");
            return this.startProcessAndWait(commands);
        }

        private int startProcessAndWait(List<String> command) throws IOException, InterruptedException {
            this.stdout = "";
            this.stderr = "";
            ProcessBuilder pb = new ProcessBuilder(command);
            Process process = pb.start();
            this.outThread = new CallbackThread(process.getInputStream(), new Runnable(){

                @Override
                public void run() {
                    Command.this.onReadStdOutLine();
                }
            });
            this.errThread = new CallbackThread(process.getErrorStream(), new Runnable(){

                @Override
                public void run() {
                    Command.this.onReadStdErrLine();
                }
            });
            this.outThread.start();
            this.errThread.start();
            this.exitCode = process.waitFor();
            this.outThread.join();
            this.errThread.join();
            return this.exitCode;
        }

        private void onReadStdOutLine() {
            String line = this.outThread.getString();
            if (line != null) {
                this.stdout = this.stdout.isEmpty() ? line : "\n" + line;
                if (this.outCallback != null) {
                    this.outCallback.run();
                }
            }
        }

        private void onReadStdErrLine() {
            String line = this.errThread.getString();
            if (line != null) {
                this.stderr = this.stderr.isEmpty() ? line : "\n" + line;
                if (this.errCallback != null) {
                    this.errCallback.run();
                }
            }
        }
    }
}

