/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util.binary;

import java.nio.charset.Charset;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.tools.util.binary.Binary;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BinaryTest
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testBinary01_Error_argument_is_null() {
        try {
            new Binary(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"argument [binaryArray] is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testBinary02_Error_argument_is_empty() {
        try {
            new Binary(new byte[0]);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"argument [binaryArray] is EMPTY", (String)e.getMessage());
        }
    }

    @Test
    public void testGetSource01_normal() {
        byte[] bytes = new byte[]{-128, -112, -96, -80, -64};
        Binary binary = new Binary(bytes);
        byte[] actual = binary.getSource();
        Assert.assertEquals((int)bytes.length, (int)actual.length);
        int len = bytes.length;
        int i = 0;
        while (i < len) {
            Assert.assertEquals((byte)bytes[i], (byte)actual[i]);
            ++i;
        }
    }

    @Test
    public void testGetSource01_abnormal() {
        byte[] bytes = new byte[]{-128, -112, -96, -80, -64};
        Binary binary = new Binary(bytes);
        bytes[0] = -16;
        byte[] actual = binary.getSource();
        Assert.assertEquals((int)bytes.length, (int)actual.length);
        int len = bytes.length;
        int i = 0;
        while (i < len) {
            if (i == 0) {
                Assert.assertNotSame((String)("(" + bytes[i] + ", " + actual[i] + ")"), (Object)bytes[i], (Object)actual[i]);
            } else {
                Assert.assertEquals((byte)bytes[i], (byte)actual[i]);
            }
            ++i;
        }
    }

    @Test
    public void testGetBinaryForm01() {
        byte[] bytes = new byte[]{-128, -49};
        Binary binary = new Binary(bytes);
        String binForm = binary.getBinaryForm();
        Assert.assertEquals((String)"1000000011001111", (String)binForm);
    }

    @Test
    public void testGetBinaryForm02() {
        Binary binary = new Binary(new byte[2]);
        String binForm = binary.getBinaryForm();
        Assert.assertEquals((String)"0000000000000000", (String)binForm);
    }

    @Test
    public void testLength01() {
        byte[] bytes = new byte[]{-128, -49};
        Binary binary = new Binary(bytes);
        Assert.assertEquals((int)16, (int)binary.length());
    }

    @Test
    public void testLength02() {
        Binary binary = new Binary(new byte[2]);
        Assert.assertEquals((int)16, (int)binary.length());
    }

    @Test
    public void testGetHexForm01() {
        byte[] bytes = new byte[]{-128, -49};
        Binary binary = new Binary(bytes);
        Assert.assertEquals((String)"80cf", (String)binary.getHexForm());
    }

    @Test
    public void testGetHexForm02() {
        Binary binary = new Binary(new byte[2]);
        Assert.assertEquals((String)"0000", (String)binary.getHexForm());
    }

    @Test
    public void testGetHexForm03() {
        byte[] bytes = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        Binary binary = new Binary(bytes);
        Assert.assertEquals((String)"0123456789abcdef", (String)binary.getHexForm());
    }

    @Test
    public void testGet32dForm01() {
        String expected = "028q5cu4qnjff";
        byte[] bytes = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        Binary binary = new Binary(bytes);
        Assert.assertEquals((String)expected, (String)binary.get32dForm());
    }

    public void testDecodeXXX() {
        byte[] bytes = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        String expected = "cmm_seq \t\tVARCHAR(45)\t\tCOLLATE utf8_bin NOT NULL COMMENT '\u30e6\u30cb\u30fc\u30af\u30ad\u30fc',";
        bytes = expected.getBytes(Charset.forName("UTF-8"));
        Binary bin = new Binary(bytes);
        String t = bin.getBinaryForm();
        String t2 = bin.getHexForm();
        String t3 = bin.get32dForm();
        String t4 = bin.get64dForm();
        Binary bin2 = Binary.decode64DFrom(t4);
        if (bin2 != null) {
            String _t = bin2.getBinaryForm();
            Assert.assertEquals((String)"\u30a8\u30e9\u30fc1(64d)", (String)t, (String)_t);
            Assert.assertEquals((String)expected, (String)new String(bin2.getSource(), Charset.forName("UTF-8")));
        } else {
            Assert.fail((String)"\u30a8\u30e9\u30fc1");
        }
        Binary bin3 = Binary.decode32DFrom(t3);
        if (bin3 != null) {
            String _t = bin3.getBinaryForm();
            Assert.assertEquals((String)"\u30a8\u30e9\u30fc2(32d)", (String)t, (String)_t);
            Assert.assertEquals((String)expected, (String)new String(bin3.getSource(), Charset.forName("UTF-8")));
        } else {
            Assert.fail((String)"\u30a8\u30e9\u30fc2");
        }
        Binary bin4 = Binary.decode16DFrom(t2);
        if (bin3 != null) {
            String _t = bin4.getBinaryForm();
            Assert.assertEquals((String)"\u30a8\u30e9\u30fc3(16d)", (String)t, (String)_t);
            Assert.assertEquals((String)expected, (String)new String(bin4.getSource(), Charset.forName("UTF-8")));
        } else {
            Assert.fail((String)"\u30a8\u30e9\u30fc3");
        }
        Binary bin5 = Binary.decode2DForm(t);
        if (bin3 != null) {
            String _t = bin5.getBinaryForm();
            Assert.assertEquals((String)"\u30a8\u30e9\u30fc4(2d)", (String)t, (String)_t);
            Assert.assertEquals((String)expected, (String)new String(bin5.getSource(), Charset.forName("UTF-8")));
        } else {
            Assert.fail((String)"\u30a8\u30e9\u30fc4");
        }
    }

    @Test
    public void testXXX() {
        byte[] bytes = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        bytes = "cmm_seq \t\tVARCHAR(45)\t\tCOLLATE utf8_bin NOT NULL COMMENT '\u30e6\u30cb\u30fc\u30af\u30ad\u30fc',".getBytes(Charset.forName("UTF-8"));
        Binary bin = new Binary(bytes);
        String t = bin.getBinaryForm();
        String t2 = bin.getHexForm();
        String t3 = bin.get32dForm();
        String t4 = bin.get64dForm();
        Binary bin2 = Binary.decode64DFrom(t4);
        if (bin2 != null) {
            String _t = bin2.getBinaryForm();
        } else {
            System.out.println("\u30a8\u30e9\u30fc1");
        }
        Binary bin3 = Binary.decode32DFrom(t3);
        if (bin3 != null) {
            String _t = bin3.getBinaryForm();
        } else {
            System.out.println("\u30a8\u30e9\u30fc2");
        }
        Binary bin4 = Binary.decode16DFrom(t2);
        if (bin3 != null) {
            String _t = bin4.getBinaryForm();
        } else {
            System.out.println("\u30a8\u30e9\u30fc3");
        }
        Binary bin5 = Binary.decode2DForm(t);
        if (bin3 != null) {
            String _t = bin5.getBinaryForm();
        } else {
            System.out.println("\u30a8\u30e9\u30fc4");
        }
        Assert.assertTrue((boolean)true);
    }
}

