package org.dyndns.nuda.tools.util;

import java.io.FileInputStream;
import java.security.MessageDigest;

public class Digest {
	public void printDigest(final byte[] digest) {//ダイジェストを16進数で表示する
		for (int i = 0; i < digest.length; i++) {
			int d = digest[i];
			if (d < 0) {//byte型では128～255が負値になっているので補正
				d += 256;
			}
			if (d < 16) {//0～15は16進数で1けたになるので、2けたになるよう頭に0を追加
				System.out.print("0");
			}
			System.out.print(Integer.toString(d, 16));//ダイジェスト値の1バイトを16進数2けたで表示
		}
		System.out.println();
	}
	
	public String outputDigest(final byte[] digest) {//ダイジェストを16進数で表示する
		StringBuilder b = new StringBuilder();
		for (int i = 0; i < digest.length; i++) {
			int d = digest[i];
			if (d < 0) {//byte型では128～255が負値になっているので補正
				d += 256;
			}
			if (d < 16) {//0～15は16進数で1けたになるので、2けたになるよう頭に0を追加
				b.append("0");
				//System.out.print("0");
			}
			b.append(Integer.toString(d, 16));
			//System.out.print(Integer.toString(d, 16));//ダイジェスト値の1バイトを16進数2けたで表示
		}
		return b.toString();
	}
	
	public byte[] getFileDigest(final String filename) throws Exception {//ファイルの中身からダイジェストを生成する
		MessageDigest md = MessageDigest.getInstance("MD5");
		FileInputStream in = new FileInputStream(filename);
		byte[] dat = new byte[256];
		int len;
		while ((len = in.read(dat)) >= 0) {
			md.update(dat, 0, len);//dat配列の先頭からlenまでのダイジェストを計算する
		}
		
		in.close();
		return md.digest();
	}
	
	public byte[] getStringDigest(final String data) throws Exception {//文字列からダイジェストを生成する
		MessageDigest md = MessageDigest.getInstance("MD5");
		byte[] dat = data.getBytes();
		md.update(dat);//dat配列からダイジェストを計算する
		return md.digest();
	}
	
	public static void main(final String args[]) throws Exception {
		Digest d = new Digest();
		//d.printDigest(d.getFileDigest("secret.txt"));
		d.printDigest(d.getStringDigest("dat配列の先頭からlenまでのダイジェストを計算する"));
	}
}