package org.dyndns.nuda.tools.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ReflectUtil {
	
	/**
	 * 
	 * @param field
	 * @return
	 */
	public static Class<?> getParameterGenericType(Field field) {
		if(field == null) {
			return null;
		}
		ParameterizedType paramType = (ParameterizedType) field
				.getGenericType();

		Type[] types = paramType.getActualTypeArguments();

		Class<?> result = (Class<?>) types[0];
		return result;
	}
	
	public static boolean isPresentedByInterface(final Class<?> target,
			final Class<?> intf) {
		Class<?> temp = target;
		
		boolean isValidClass = false;
		while (!temp.getName().equals(Object.class.getName())) {
			Class<?>[] interfaces = temp.getInterfaces();
			
			for (Class<?> intf0 : interfaces) {
				
				if (intf0.equals(intf0)) {
					isValidClass = true;
					break;
				}
			}
			
			if (isValidClass) {
				break;
			}
			temp = temp.getSuperclass();
		}
		
		return isValidClass;
	}
	
	public static List<Method> getAnnotationPresentedMethods(
			final Class<?> cls, final Class<? extends Annotation> annotation) {
		Method[] methods = cls.getMethods();
		
		List<Method> methodAry = new ArrayList<Method>();
		
		for (Method method : methods) {
			if (method.isAnnotationPresent(annotation)) {
				methodAry.add(method);
			}
		}
		return methodAry;
	}
	
	public static List<Field> getAnnotationPresentedField(final Class<?> cls,
			final Class<? extends Annotation> annotation) {
		Field[] fields = cls.getDeclaredFields();
		
		List<Field> fieldAry = new ArrayList<Field>();
		
		for (Field field : fields) {
			if (field.isAnnotationPresent(annotation)) {
				fieldAry.add(field);
			}
		}
		return fieldAry;
	}
	
	public static Class<?>[] getGenericTypeForMethodReturn(final Method method) {
		Class<?>[] resultTypes = null;
		
		Type aType = method.getGenericReturnType();
		
		if (aType != null) {
			ParameterizedType paramType = null;
			try {
				paramType = (ParameterizedType) aType;
			} catch (Exception e) {
				
			}
			
			if (paramType != null) {
				Type[] types = paramType.getActualTypeArguments();
				
				if (types != null && types.length > 0) {
					resultTypes = new Class[types.length];
					int count = 0;
					for (Type type : types) {
						resultTypes[count] = (Class<?>) type;
						count++;
					}
				}
			}
		}
		
		return resultTypes;
	}
	
	public static void main(final String[] args) {
		
	}
	
	/**
	 * 
	 * @author nkoseki
	 * 
	 */
	public static enum PREFIX {
		
		/**
		 * 
		 */
		GETTER {
			@Override
			public String prefix() {
				return GETTER_PREFIX;
			}
		},
		
		/**
		 * 
		 */
		GETTER_BOOL {
			@Override
			public String prefix() {
				// TODO 自動生成されたメソッド・スタブ
				return GETTER_BOOL_PREFIX;
			}
		},
		
		/**
		 * 
		 */
		SETTER {
			@Override
			public String prefix() {
				return SETTER_PREFIX;
			}
		},
		
		/**
		 * 
		 */
		OTHER {
			@Override
			public String prefix() {
				return "";
			}
		};
		private static String	GETTER_PREFIX		= "get";
		private static String	GETTER_BOOL_PREFIX	= "is";
		private static String	SETTER_PREFIX		= "set";
		
		/**
		 * 
		 * @return
		 */
		public abstract String prefix();
		
		/**
		 * 
		 * @param methodName
		 * @return
		 */
		public String camelCaseOf(final String methodName) {
			if (OTHER.equals(this)) {
				return methodName;
			} else if (GETTER_BOOL.equals(this)) {
				if (methodName.length() < 3) {
					return methodName;
				}
				String suffix = methodName.substring(2, methodName.length());
				
				String firstChar = suffix.substring(0, 1).toLowerCase();
				String otherChar = suffix.substring(1, suffix.length());
				
				String result = new StringBuilder().append(firstChar)
						.append(otherChar).toString();
				return result;
			} else {
				if (methodName.length() < 4) {
					return methodName;
				}
				String suffix = methodName.substring(3, methodName.length());
				
				String firstChar = suffix.substring(0, 1).toLowerCase();
				String otherChar = suffix.substring(1, suffix.length());
				
				String result = new StringBuilder().append(firstChar)
						.append(otherChar).toString();
				
				return result;
			}
		}
		
		/**
		 * 
		 * @param propertyName
		 * @return
		 */
		public String camelCaseTo(final String propertyName) {
			if (propertyName == null) {
				return "";
			}
			if (propertyName.isEmpty()) {
				return "";
			}
			
			if (OTHER.equals(this)) {
				return propertyName;
			} else {
				String pre = propertyName.substring(0, 1).toUpperCase();
				String other = propertyName.substring(1, propertyName.length());
				
				String result = new StringBuilder().append(this.prefix())
						.append(pre).append(other).toString();
				
				return result;
			}
			
		}
		
		/**
		 * 
		 * @param methodName
		 * @return
		 */
		public static PREFIX getPrefix(final String methodName) {
			if (methodName.startsWith(GETTER_PREFIX)) {
				return GETTER;
			} else if (methodName.startsWith(SETTER_PREFIX)) {
				return SETTER;
			} else if (methodName.startsWith(GETTER_BOOL_PREFIX)) {
				return GETTER_BOOL;
			} else {
				return OTHER;
			}
		}
	}
	
	public static class AttributeContext implements
			Comparator<AttributeContext>, Comparable<AttributeContext> {
		protected String	attributeName;
		protected Class<?>	presentedClass;
		protected boolean	isBoolPresend;
		protected boolean	hasGetter;
		protected boolean	hasSetter;
		
		public String getAttributeName() {
			return this.attributeName;
		}
		
		public String getGetterName() {
			return PREFIX.GETTER.camelCaseTo(this.attributeName);
		}
		
		public String getGetterBoolName() {
			return PREFIX.GETTER_BOOL.camelCaseTo(this.attributeName);
		}
		
		public String getSetterName() {
			return PREFIX.SETTER.camelCaseTo(this.attributeName);
		}
		
		public boolean isBoolPresend() {
			return this.isBoolPresend;
		}
		
		public boolean isHasGetter() {
			return this.hasGetter;
		}
		
		public boolean isHasSetter() {
			return this.hasSetter;
		}
		
		public Class<?> getPresentedClass() {
			return this.presentedClass;
		}
		
		public Object getInitialValue() {
			Object result = null;
			if (this.presentedClass.isPrimitive()) {
				if (this.presentedClass.equals(int.class)) {
					result = Integer.valueOf(0);
				} else if (this.presentedClass.equals(long.class)) {
					result = Long.valueOf(0);
				} else if (this.presentedClass.equals(float.class)) {
					result = Float.valueOf(0);
				} else if (this.presentedClass.equals(double.class)) {
					result = Double.valueOf(0);
				} else if (this.presentedClass.equals(byte.class)) {
					result = Byte.valueOf("");
				} else if (this.presentedClass.equals(short.class)) {
					result = Short.valueOf("");
				} else if (this.presentedClass.equals(char.class)) {
					// ブランク文字
					char val = 0x20;
					result = Character.valueOf(val);
				} else if (this.presentedClass.equals(boolean.class)) {
					result = Boolean.valueOf(false);
				}
			} else {
				result = null;
			}
			
			return result;
		}
		
		/**
		 * 引数に指定されたクラスオブジェクトを元にセッタメソッドの一覧を返します
		 * 
		 * @param cls
		 *            解析対象クラスオブジェクト
		 * @return セッタメソッド一覧
		 */
		public static AttributeContext[] getSetterSummary(final Class<?> cls) {
			AttributeContext[] contextAry = null;
			
			if (cls != null) {
				
			} else {
				contextAry = new AttributeContext[0];
			}
			
			return contextAry;
		}
		
		/**
		 * 引数に指定されたクラスオブジェクトをもとにゲッタメソッドの一覧を返します
		 * 
		 * @param cls
		 *            解析対象クラスオブジェクト
		 * @return ゲッタメソッド一覧
		 */
		public static AttributeContext[] getGetterSummary(final Class<?> cls) {
			AttributeContext[] contextAry = null;
			
			if (cls != null) {
				
			} else {
				contextAry = new AttributeContext[0];
			}
			
			return contextAry;
		}
		
		/**
		 * 引数に指定されたクラスオブジェクトをもとにアクセッサメソッドの一覧を返します
		 * 
		 * @param cls
		 *            解析対象クラスオブジェクト
		 * @return アクセッサメソッド一覧
		 */
		public static AttributeContext[] getAccessorSummary(final Class<?> cls) {
			AttributeContext[] contextAry = null;
			
			if (cls != null) {
				
			} else {
				contextAry = new AttributeContext[0];
			}
			
			return contextAry;
		}
		
		/**
		 * 引数に指定されたクラスオブジェクトをもとにオペレータ(セッタメソッドでもゲッタメソッドでもないメソッド)の一覧を返します
		 * 
		 * @param cls
		 *            解析対象クラスオブジェクト
		 * @return オペレータメソッド一覧
		 */
		public static AttributeContext[] getOperatorSummary(final Class<?> cls) {
			AttributeContext[] contextAry = null;
			
			if (cls != null) {
				
			} else {
				contextAry = new AttributeContext[0];
			}
			
			return contextAry;
		}
		
		public static Set<AttributeContext> getContexts(final Class<?> cls) {
			Set<AttributeContext> result = new TreeSet<AttributeContext>();
			
			if (cls == null) {
				return result;
			}
			
			for (Method method : cls.getDeclaredMethods()) {
				AttributeContext attr = new AttributeContext(method, cls);
				
				result.add(attr);
			}
			
			return result;
		}
		
		public AttributeContext(final Method method, final Class<?> cls) {
			String methodName = method.getName();
			PREFIX prefix = ReflectUtil.PREFIX.getPrefix(methodName);
			
			String propertyName = prefix.camelCaseOf(methodName);
			
			this.attributeName = propertyName;
			
			if (method == null || cls == null) {
				this.isBoolPresend = false;
				this.hasGetter = false;
				this.hasSetter = false;
				return;
			}
			
			// publicメソッドのみを対象とする
			if (method.getModifiers() != Modifier.PUBLIC && !cls.isInterface()) {
				//				LoggerFactory.getLogger(ReflectUtil.class).info(
				//						"invalid method<{}> {}", method.getName(),
				//						"method modifier is not <public>");
				this.isBoolPresend = false;
				this.hasGetter = false;
				this.hasSetter = false;
				return;
			}
			
			// staticメソッドは除外する
			if (method.getModifiers() == Modifier.STATIC) {
				//				LoggerFactory.getLogger(ReflectUtil.class).info(
				//						"invalid method<{}> {}", method.getName(),
				//						"method modifier is <static>");
				this.isBoolPresend = false;
				this.hasGetter = false;
				this.hasSetter = false;
				return;
			}
			
			String getterMethodName;
			String getterBoolMethodName;
			String setterMethodName;
			
			Class<?>[] parameterTypes;
			Class<?> parameterType;
			Class<?> returnType;
			
			switch (prefix) {
				case GETTER:

					parameterTypes = method.getParameterTypes();
					if (parameterTypes != null && parameterTypes.length > 0) {
						this.isBoolPresend = false;
						this.hasGetter = false;
						this.hasSetter = false;
						return;
					}
					
					this.hasGetter = true;
					setterMethodName = PREFIX.SETTER.camelCaseTo(propertyName);
					returnType = method.getReturnType();
					
					if (returnType.equals(boolean.class)) {
						
					}
					
					this.presentedClass = returnType;
					try {
						cls.getDeclaredMethod(setterMethodName,
								new Class[] { returnType });
						this.hasSetter = true;
					} catch (SecurityException e) {
						this.hasSetter = false;
					} catch (NoSuchMethodException e) {
						this.hasSetter = false;
					}
					
					break;
				case SETTER:

					parameterTypes = method.getParameterTypes();
					
					if (parameterTypes == null || parameterTypes.length != 1) {
						this.isBoolPresend = false;
						this.hasGetter = false;
						this.hasSetter = false;
						return;
					}
					
					parameterType = parameterTypes[0];
					
					this.presentedClass = parameterType;
					if (!parameterType.equals(boolean.class)) {
						getterMethodName = PREFIX.GETTER
								.camelCaseTo(propertyName);
						
						try {
							Method getterM = cls.getDeclaredMethod(
									getterMethodName, new Class<?>[] {});
							
							if (getterM.getParameterTypes().length == 0) {
								
								if (getterM.getReturnType().equals(
										this.presentedClass)) {
									this.isBoolPresend = false;
									this.hasGetter = true;
									this.hasSetter = true;
								} else {
									this.isBoolPresend = false;
									this.hasGetter = false;
									this.hasSetter = true;
								}
								
							} else {
								this.isBoolPresend = false;
								this.hasGetter = false;
								this.hasSetter = true;
							}
							
						} catch (SecurityException e) {
							this.isBoolPresend = false;
							this.hasGetter = false;
							this.hasSetter = true;
						} catch (NoSuchMethodException e) {
							this.isBoolPresend = false;
							this.hasGetter = false;
							this.hasSetter = true;
							
						}
					} else {
						getterBoolMethodName = PREFIX.GETTER_BOOL
								.camelCaseTo(propertyName);
						
						try {
							Method getterBoolM = cls.getDeclaredMethod(
									getterBoolMethodName, new Class<?>[] {});
							
							if (getterBoolM.getReturnType().equals(
									boolean.class)) {
								this.isBoolPresend = true;
								this.hasGetter = false;
								this.hasSetter = true;
							} else {
								this.isBoolPresend = false;
								this.hasGetter = false;
								this.hasSetter = true;
							}
							
						} catch (SecurityException e) {
							this.isBoolPresend = false;
							this.hasGetter = false;
							this.hasSetter = true;
						} catch (NoSuchMethodException e) {
							this.isBoolPresend = false;
							this.hasGetter = false;
							this.hasSetter = true;
						}
					}
					break;
				case GETTER_BOOL:

					parameterTypes = method.getParameterTypes();
					if (parameterTypes != null && parameterTypes.length > 0) {
						this.isBoolPresend = false;
						this.hasGetter = false;
						this.hasSetter = false;
						return;
					}
					
					returnType = method.getReturnType();
					
					this.presentedClass = returnType;
					if (returnType.equals(boolean.class)) {
						setterMethodName = PREFIX.SETTER
								.camelCaseTo(propertyName);
						
						try {
							Method getterBoolM = cls.getDeclaredMethod(
									setterMethodName,
									new Class<?>[] { returnType });
							
							if (getterBoolM.getReturnType().equals(void.class)) {
								this.isBoolPresend = true;
								this.hasGetter = false;
								this.hasSetter = true;
							} else {
								this.isBoolPresend = true;
								this.hasGetter = false;
								this.hasSetter = false;
							}
							
						} catch (SecurityException e) {
							this.isBoolPresend = true;
							this.hasGetter = false;
							this.hasSetter = false;
						} catch (NoSuchMethodException e) {
							this.isBoolPresend = true;
							this.hasGetter = false;
							this.hasSetter = false;
						}
						
					} else {
						this.isBoolPresend = false;
						this.hasGetter = false;
						this.hasSetter = false;
					}
					
					break;
				case OTHER:
					break;
			}
			
		}
		
		/**
		 * 対象のメソッドが正常なプロパティメソッドか検査します
		 * 
		 * @return
		 */
		public boolean isValidProperty() {
			return (this.hasGetter || this.hasSetter || this.isBoolPresend);
		}
		
		@Override
		public String toString() {
			String result = new StringBuilder().append("attribute name[")
					.append(this.attributeName).append("]")
					.append(" presented[")
					.append(this.presentedClass.getCanonicalName()).append("]")
					.append(" get[").append(this.hasGetter).append("]")
					.append(" set[").append(this.hasSetter).append("]")
					.append(" is[").append(this.isBoolPresend).append("]")
					.toString();
			return result;
		}
		
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime
					* result
					+ ((this.attributeName == null) ? 0 : this.attributeName
							.hashCode());
			result = prime * result + (this.hasGetter ? 1231 : 1237);
			result = prime * result + (this.hasSetter ? 1249 : 1259);
			result = prime * result + (this.isBoolPresend ? 1277 : 1279);
			result = prime
					* result
					+ ((this.presentedClass == null) ? 0 : this.presentedClass
							.hashCode());
			return result;
		}
		
		@Override
		public boolean equals(final Object obj) {
			if (this == obj) {
				return true;
			}
			if (obj == null) {
				return false;
			}
			if (this.getClass() != obj.getClass()) {
				return false;
			}
			AttributeContext other = (AttributeContext) obj;
			if (this.attributeName == null) {
				if (other.attributeName != null) {
					return false;
				}
			} else if (!this.attributeName.equals(other.attributeName)) {
				return false;
			}
			if (this.hasGetter != other.hasGetter) {
				return false;
			}
			if (this.hasSetter != other.hasSetter) {
				return false;
			}
			if (this.isBoolPresend != other.isBoolPresend) {
				return false;
			}
			if (this.presentedClass == null) {
				if (other.presentedClass != null) {
					return false;
				}
			} else if (!this.presentedClass.equals(other.presentedClass)) {
				return false;
			}
			return true;
		}
		
		@Override
		public int compare(final AttributeContext o1, final AttributeContext o2) {
			if (o1.equals(o2)) {
				return 0;
			}
			String s1 = o1.getAttributeName();
			String s2 = o2.getAttributeName();
			
			return s1.compareTo(s2);
		}
		
		@Override
		public int compareTo(final AttributeContext o) {
			return this.compare(this, o);
		}
	}
	
	public static class AttributeContextComparator implements
			Comparator<AttributeContext> {
		private static AttributeContextComparator	ME;
		
		private AttributeContextComparator() {
			
		}
		
		@Override
		public int compare(final AttributeContext o1, final AttributeContext o2) {
			if (o1.equals(o2)) {
				return 0;
			}
			String s1 = o1.getAttributeName();
			String s2 = o2.getAttributeName();
			
			return s1.compareTo(s2);
		}
		
		public static AttributeContextComparator getInstance() {
			if (ME == null) {
				ME = new AttributeContextComparator();
			}
			return ME;
		}
	}
	
	public static final int[]	PRIME	= { 31, 1231, 1237, 1249, 1259, 1277,
			1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319 };
}
