package org.dyndns.nuda.tools.xml;

import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public interface ScopeHandler<V> {
	
	public ScopeHandler<V> changeScope(Stack<ScopeHandler<V>> scopeStack,
			String qName);
	
	public ScopeHandler<V> defaultScope();
	
	public void startElement(final Context<V> ctx, final String uri,
			final String localName, final String qName,
			final Attributes attributes) throws SAXException;
	
	public void endElement(final Context<V> ctx, final String uri,
			final String localName, final String qName) throws SAXException;
	
	public void characters(final Context<V> ctx, final char[] ch,
			final int start, final int length) throws SAXException;
}
