/**************************************************************************
  This code is only a stub.
 **************************************************************************/


package org.omegat.gui.main;

import java.awt.Font;
import java.awt.HeadlessException;

/**
 * Interface for access to main window functionality.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 */
public interface IMainWindow {
    /**
     * Get main application font.
     */
    Font getApplicationFont();

    /**
     * Retrieve main manu instance.
     */
    IMainMenu getMainMenu();

    /**
     * shows a confirm dialog. For a GUI main window, this can be implemented as JOptionPane.showConfirmDialog
     *
     * @param message the Object to display
     * @param title   the title string for the dialog (can be null)
     * @param optionType an integer designating the JOptionPane options available on the dialog: YES_NO_OPTION, YES_NO_CANCEL_OPTION, or OK_CANCEL_OPTION
     * @param messageType an integer designating the kind of message this is; primarily used to determine the icon from the pluggable Look and Feel: (JOptionPane ERROR_MESSAGE, INFORMATION_MESSAGE, WARNING_MESSAGE, QUESTION_MESSAGE, or PLAIN_MESSAGE
     * @return an integer indicating the option selected by the user
     * @throws HeadlessException if GraphicsEnvironment.isHeadless returns true
     */
    int showConfirmDialog(Object message, String title, int optionType, int messageType) throws HeadlessException;

    /**
     * Shows message to user
     *
     * @param message the message to show
     */
    void showMessageDialog(String message);

}
