static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*
	cc -g -DLINUX -I../include testcache_time.c akxcom.a -o testcache_time
*/
#define CACHE_LIST
#include "akxcommon.h"

extern int akxs_cache_get();

static void _print_data(pCt)
tdtCacheCtl *pCt;
{
	int *p;
	char *pKey,*pCmp1,*pData;

	if (!(pKey  = pCt->ca_key))  pKey  = "(null)";
	if (!(pCmp1 = pCt->ca_cmp1)) pCmp1 = "(null)";
	if (!(pData = pCt->ca_data)) pData = "(null)";
	printf("cpCKey = [%s]  cpCCmp1 = [%s]\n",pKey, pCmp1);
	if (p = (int *)pCt->ca_cmp2) 
		printf("cpCCmp2 = %d %d %d %d",p[0],p[1],p[2],p[3]);
	else printf("cpCCmp2 = (null)");
	printf("  cpCData = [%s]\niCCmpNext = %d  iCChkTime = %d  %d.%06d\n",
	       pData, pCt->ca_cmpnext, pCt->ca_chktime,
	       pCt->tval.tv_sec,pCt->tval.tv_usec);
}

static void _list(pCH,_CacheGet)
tdtCacheCtlHead *pCH;
int (*_CacheGet)();
{
	int i,rc;
	tdtCacheCtl qCt;

	for (i=0;i<pCH->ch_imax;i++) {
		rc=_CacheGet(pCH,i+1,&qCt);
		printf("Get rc = %d\n",rc);
		if (rc >= 0) _print_data(&qCt);
	}
}

int main()
{
	tdtCacheCtlHead *pCHOrg,*pCHQue,*pCHList,*pCHXHas;
	tdtCacheCtl qCt,*pCt;
	char buf[128];
	int  max,rc,i,j,t1,hmax,intval,opt;
	char key[128],cmd[20],c;
	tdtListChain *pList,*pNext,*pCur,*pTop,*pPrev;
	tdtTimerCtlHead *pTC;
	struct timeval tval1,tval2,tvalf,tvalh,tvalx,tvall2,tvalha,tvalxh;
	HASHB *ha;
	XHASHB *xha;

	pTC = akxe_timer_new();
	printf("Enter cache max(>=8) : ");
	gets(buf);
	hmax=max=atoi(buf);
	printf("Enter cache no auto extend (y or n): ");
	gets(buf);
	if (*buf == 'y') max = -max;
	printf("Enter cache check interval(sec)(>=0): ");
	gets(buf);
	intval=atoi(buf);

	opt = AKX_CACHE_DATASAVE | AKX_CACHE_IGNCHKERR;

	pCHOrg=pCHQue=pCHList=pCHXHas=NULL;
/*
	if (max > 0) {
		pCHOrg = akxs_cache_new(max);
		if (!pCHOrg) exit(1);
		pCHOrg->ch_opt |= opt;
		pCHOrg->ch_cshlen = 0;
		pCHOrg->ch_interval = intval;

		pCHQue = akxs_cache_newQue(max);
		if (!pCHQue) exit(1);
		pCHQue->ch_opt |= opt;
		pCHQue->ch_cshlen = 0;
		pCHQue->ch_interval = intval;

		pCHList = akxs_cache_new_list(max);
		if (!pCHList) exit(1);
		pCHList->ch_opt |= opt;
		pCHList->ch_cshlen = 0;
		pCHList->ch_interval = intval;

		pCHXHas = akxs_cache_newXHas(max);
		if (!pCHXHas) exit(1);
		pCHXHas->ch_opt |= opt;
		pCHXHas->ch_cshlen = 0;
		pCHXHas->ch_interval = intval;
	}
*/
	ha = akxs_hasx_new(0,hmax,0);
	ha->ha_key = key;

	xha = akxs_xhash_new2(0,hmax,0,sizeof(tdtCacheCtl));

	memset(&qCt,0,sizeof(tdtCacheCtl));
	qCt.ca_key  = key;
	qCt.ca_cmp1 = "aaaa";
	qCt.ca_data = "ssssssssss";
	printf("\n count(s)  org       que      list      xhas      hasx      xhas\n");
	for (j=8;j<=hmax;) {
		/*** Org  ***/
		if (pCHOrg) {
			rc=akxscache_free(pCHOrg);
			if (rc) {
				printf("FreeORG :rc = %d\n",rc);
				exit(4);
			}
		}
		pCHOrg = akxs_cache_new(max);
		if (!pCHOrg) exit(1);
		pCHOrg->ch_opt |= opt;
		pCHOrg->ch_cshlen = 0;
		pCHOrg->ch_interval = intval;
		if (max < 0) {
			for (i=0;i<j;i++) {
				sprintf(key,"%d0000",i+j);
				rc=akxs_cache_set(pCHOrg,&qCt);
				if (rc <= 0) {
					printf("Pre SetOrg :rc = %d\n",rc);
					exit(3);
				}
			}
		}
		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_set(pCHOrg,&qCt);
			if (rc <= 0) {
				printf("SetOrg :rc = %d\n",rc);
				exit(5);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalf,&tval2,&tval1);

		/*** Que  ***/
		if (pCHQue) {
			rc=akxscache_freeQue(pCHQue);
			if (rc) {
				printf("FreeQue :rc = %d\n",rc);
				exit(4);
			}
		}
		pCHQue = akxs_cache_newQue(max);
		if (!pCHQue) exit(1);
		pCHQue->ch_opt |= opt;
		pCHQue->ch_cshlen = 0;
		pCHQue->ch_interval = intval;
		if (max < 0) {
			for (i=0;i<j;i++) {
				sprintf(key,"%d0000",i+j);
				rc=akxs_cache_setQue(pCHQue,&qCt);
				if (rc <= 0) {
					printf("Pre SetQue :rc = %d\n",rc);
					exit(3);
				}
			}
		}
		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_setQue(pCHQue,&qCt);
			if (rc <= 0) {
				printf("SetQue :rc = %d\n",rc);
				exit(5);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalh,&tval2,&tval1);

		/*** List ***/
		if (pCHList) {
			rc=akxscache_freeList(pCHList);
			if (rc) {
				printf("FreeList:rc = %d\n",rc);
				exit(4);
			}
		}
		pCHList = akxs_cache_new_list(max);
		if (!pCHList) exit(1);
		pCHList->ch_opt |= opt;
		pCHList->ch_cshlen = 0;
		pCHList->ch_interval = intval;
		if (max < 0) {
			for (i=0;i<j;i++) {
				sprintf(key,"%d0000",i+j);
				rc=akxs_cache_setList(pCHList,&qCt);
				if (rc <= 0) {
					printf("Pre SetList:rc = %d\n",rc);
					exit(3);
				}
			}
		}
		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_setList(pCHList,&qCt);
			if (rc <= 0) {
				printf("SetList:rc = %d\n",rc);
				exit(5);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalx,&tval2,&tval1);

		/*** XHas ***/
		if (pCHXHas) {
			rc=akxscache_freeXHas(pCHXHas);
			if (rc) {
				printf("FreeXHas:rc = %d\n",rc);
				exit(4);
			}
		}
		pCHXHas = akxs_cache_newXHas(max);
		if (!pCHXHas) exit(1);
		pCHXHas->ch_opt |= opt;
		pCHXHas->ch_cshlen = 0;
		pCHXHas->ch_interval = intval;
		if (max < 0) {
			for (i=0;i<j;i++) {
				sprintf(key,"%d0000",i+j);
				rc=akxs_cache_setXHas(pCHXHas,&qCt);
				if (rc <= 0) {
					printf("Pre SetXHas:rc = %d\n",rc);
					exit(3);
				}
			}
		}
		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_setXHas(pCHXHas,&qCt);
			if (rc <= 0) {
				printf("SetXHas:rc = %d\n",rc);
				exit(5);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvall2,&tval2,&tval1);

		/*** hasx ***/
		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxshasx('s',ha);
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalha,&tval2,&tval1);

		/*** xhas ***/
		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_xhash2(xha,'s',key,pCt);
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalxh,&tval2,&tval1);

		printf("%6d %2d.%06d %2d.%06d %2d.%06d %2d.%06d %2d.%06d %2d.%06d\n",
		j,tvalf.tv_sec,tvalf.tv_usec,tvalh.tv_sec,tvalh.tv_usec,
		tvalx.tv_sec,tvalx.tv_usec,tvall2.tv_sec,tvall2.tv_usec,
		tvalha.tv_sec,tvalha.tv_usec,tvalxh.tv_sec,tvalxh.tv_usec);

		j *= 2;
	}

	printf("\n count(s)  org       que      list      xhas      hasx      xhas\n");
	for (j=8;j<=hmax;) {

		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_chk(pCHOrg,key,&qCt);
			if (rc<0 && rc!=-22) {
				printf("ChkOrg :i=%d key=[%s] rc=%d\n",i,key,rc);
				_list(pCHOrg,akxs_cache_get);
				exit(2);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalf,&tval2,&tval1);

		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_chkQue(pCHQue,key,&qCt);
			if (rc<0 && rc!=-22) {
				printf("ChkQue :i=%d key=[%s] rc=%d\n",i,key,rc);
				exit(2);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalh,&tval2,&tval1);

		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_chkList(pCHList,key,&qCt);
			if (rc<0 && rc!=-22) {
				printf("ChkList:i=%d key=[%s] rc=%d\n",i,key,rc);
				exit(2);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalx,&tval2,&tval1);

		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_cache_chkXHas(pCHXHas,key,&qCt);
			if (rc<0 && rc!=-22) {
				printf("ChkXHas:i=%d key=[%s] rc=%d\n",i,key,rc);
				exit(2);
			}
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvall2,&tval2,&tval1);

		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxshasx('r',ha);
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalha,&tval2,&tval1);

		akxe_getm_sec(pTC,&tval1);
		for (i=0;i<j;i++) {
			sprintf(key,"%d0000",i);
			rc=akxs_xhash2(xha,'r',key,&pCt);
		}
		akxe_getm_sec(pTC,&tval2);
		t1 = akxe_timer_sub(&tvalxh,&tval2,&tval1);

		printf("%6d %2d.%06d %2d.%06d %2d.%06d %2d.%06d %2d.%06d %2d.%06d\n",
		j,tvalf.tv_sec,tvalf.tv_usec,tvalh.tv_sec,tvalh.tv_usec,
		tvalx.tv_sec,tvalx.tv_usec,tvall2.tv_sec,tvall2.tv_usec,
		tvalha.tv_sec,tvalha.tv_usec,tvalxh.tv_sec,tvalxh.tv_usec);

		j *= 2;
	}

	printf("FreeORG :rc = %d\n",akxscache_free(pCHOrg));
	printf("FreeQue :rc = %d\n",akxscache_freeQue(pCHQue));
	printf("FreeList:rc = %d\n",akxscache_freeList(pCHList));
	printf("FreeXHas:rc = %d\n",akxscache_freeXHas(pCHXHas));
	printf("HasxFree:rc = %d\n",akxs_hasx_free(ha));
	printf("HasxFree:rc = %d\n",akxs_xhash_free(xha));
	exit(0);
}
