/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.config;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.linkbuilder.AbstractLinkBuilder;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;

@Component
public class BastubLinkBuilder
extends AbstractLinkBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(BastubLinkBuilder.class);
    private final StandardLinkBuilder standardLinkBuilder = new StandardLinkBuilder();

    public String buildLink(IExpressionContext context, String base, Map<String, Object> parameters) {
        String repbase = base;
        if (base.startsWith("/") && context instanceof WebEngineContext) {
            WebEngineContext webcon = (WebEngineContext)context;
            repbase = this.getContextRootBase(base, webcon.getRequest().getRequestURI());
        }
        String link = this.standardLinkBuilder.buildLink(context, repbase, parameters);
        return link;
    }

    private String getContextRootBase(String base, String uri) {
        int n = uri.indexOf("/", 1);
        if (n > 0) {
            base = String.valueOf(uri.substring(0, n)) + base;
        }
        return base;
    }
}

