/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.config;

import java.util.Set;
import jp.nanah.bastub.config.BastubLinkBuilder;
import jp.nanah.bastub.service.PathService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@Import(value={ThymeleafAutoConfiguration.class})
public class BastubWebConfig {
    protected static final Logger logger = LoggerFactory.getLogger(BastubLinkBuilder.class);
    @Value(value="${pagedata.root:pagedata}")
    private String pagedataPath;
    @Autowired
    private SpringTemplateEngine templateEngine;
    @Autowired
    private BastubLinkBuilder bastubLinkBuilder;

    @Bean
    public SpringTemplateEngine customTemplateEngine() {
        this.templateEngine.setLinkBuilder((ILinkBuilder)this.bastubLinkBuilder);
        Set resolvers = this.templateEngine.getTemplateResolvers();
        for (ITemplateResolver resol : resolvers) {
            if (!(resol instanceof SpringResourceTemplateResolver)) continue;
            try {
                SpringResourceTemplateResolver srtr = (SpringResourceTemplateResolver)resol;
                srtr.setPrefix("file:" + PathService.pageDir.getAbsolutePath());
                logger.info("Resource Path set to {}", (Object)srtr.getPrefix());
            }
            catch (Exception e) {
                logger.error("Bad Prefix Path", (Throwable)e);
            }
        }
        this.templateEngine.setLinkBuilder((ILinkBuilder)this.bastubLinkBuilder);
        return this.templateEngine;
    }
}

