/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nanah.bastub.data.AppInfo;
import jp.nanah.bastub.service.JsonService;
import jp.nanah.bastub.service.PathService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AnyRestController {
    private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
    private static final Logger reqlog = LoggerFactory.getLogger((String)"REQLOG");
    @Autowired
    private AppInfo appService;
    @Autowired
    private JsonService jsonService;
    @Autowired
    private PathService pathService;

    @RequestMapping(path={"/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    public String path1(@RequestBody(required=false) ModelMap body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common((Map)body, model, req, res);
    }

    @RequestMapping(path={"/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE}, consumes={"application/x-www-form-urlencoded"})
    public String path1_multipart(@RequestParam(required=false) Map<String, String> paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common(paramMap, model, req, res);
    }

    private String path_common(Map paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        this.appService.setCurrentThreadName();
        String method = req.getMethod();
        String reqPath = req.getRequestURL().toString();
        String queryStr = req.getQueryString() == null ? "" : req.getQueryString();
        Object bodyData = paramMap == null ? "" : paramMap;
        reqlog.info("[{}] {} query={} body={}", new Object[]{method, reqPath, queryStr, bodyData});
        logger.info("== \u25bc == [{}] {}", (Object)method, (Object)reqPath);
        res.setContentType("application/json;charset=UTF-8");
        List<String> pathList = this.pathService.getPathList(req);
        String jsonText = this.jsonService.getAny(pathList, paramMap, model, req, res);
        logger.info("== \u25b3 ==");
        return jsonText;
    }
}

