/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nanah.bastub.data.AppInfo;
import jp.nanah.bastub.service.JsonService;
import jp.nanah.bastub.service.PathService;
import jp.nanah.bastub.util.BastubUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnyViewController {
    private static final Logger logger = LoggerFactory.getLogger(AnyViewController.class);
    private static final Logger reqlog = LoggerFactory.getLogger((String)"REQLOG");
    @Autowired
    private AppInfo appService = new AppInfo();
    @Autowired
    private JsonService jsonService;
    @Autowired
    private PathService pathService;

    @RequestMapping(value={"/**/*.$view"})
    public String path1(@RequestBody(required=false) ModelMap body, ModelMap model, HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.path_common((Map)body, model, req, res);
    }

    @RequestMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded"})
    public String path1_multipart(@RequestParam(required=false) Map<String, String> paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common(paramMap, model, req, res);
    }

    public String path_common(Map paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        this.appService.setCurrentThreadName();
        String method = req.getMethod();
        String reqPath = req.getRequestURL().toString();
        String queryStr = req.getQueryString() == null ? "" : req.getQueryString();
        Object bodyData = paramMap == null ? "" : paramMap;
        reqlog.info("[{}] {}, query={} body={}", new Object[]{method, reqPath, queryStr, bodyData});
        File pageDir = this.pathService.getPageDir();
        ArrayList<String> pathList = new ArrayList<String>(this.pathService.getPathList(req));
        int lastIdx = pathList.size() - 1;
        String lastPath = (String)pathList.get(lastIdx);
        pathList.set(lastIdx, BastubUtils.removeExtText(lastPath, ".$view"));
        pathList.add("");
        ++lastIdx;
        String viewName = this.getViewName(req);
        File file = new File(pageDir, viewName);
        if (file.isDirectory()) {
            File[] subDirFiles;
            File[] fileArray = subDirFiles = file.listFiles();
            int n = subDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String ext = BastubUtils.getExtText(f.getAbsolutePath());
                if (ext.equals(".json")) {
                    pathList.set(lastIdx, BastubUtils.removeExtText(f.getName(), ".json"));
                    String jsonText = this.jsonService.getAny(pathList, paramMap, model, req, res);
                    try {
                        Object response;
                        String modelKey = BastubUtils.removeExtText(f.getName(), null);
                        if (jsonText.trim().startsWith("[") && jsonText.endsWith("]")) {
                            response = (List)new ObjectMapper().readValue(jsonText, ArrayList.class);
                            model.addAttribute(modelKey, response);
                        } else {
                            response = (Map)new ObjectMapper().readValue(jsonText, HashMap.class);
                            model.addAttribute(modelKey, response);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5909\u63db\u7570\u5e38", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        logger.info("== \u25b3 ==");
        return viewName;
    }

    private String getViewName(HttpServletRequest req) {
        String path = req.getRequestURI();
        int n = path.lastIndexOf(".$view");
        String viewName = path.substring(0, n);
        return viewName;
    }
}

