/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.controller;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nanah.bastub.controller.AnyRestController;
import jp.nanah.bastub.data.UsingInfo;
import jp.nanah.bastub.service.PathService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class StaticController {
    private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
    static Map<String, MediaType> mediaTypeMap = new TreeMap<String, MediaType>();
    @Autowired
    private PathService pgService;
    @Value(value="${default.charset:UTF-8}")
    private String defaultCharset;

    static {
        mediaTypeMap.put(".html", MediaType.TEXT_HTML);
        mediaTypeMap.put(".htm", MediaType.TEXT_HTML);
        mediaTypeMap.put(".txt", MediaType.TEXT_PLAIN);
        mediaTypeMap.put(".js", new MediaType("application", "javascript"));
        mediaTypeMap.put(".css", new MediaType("text", "css"));
        mediaTypeMap.put(".jpg", MediaType.IMAGE_JPEG);
        mediaTypeMap.put(".jpeg", MediaType.IMAGE_JPEG);
        mediaTypeMap.put(".png", MediaType.IMAGE_PNG);
        mediaTypeMap.put(".gif", MediaType.IMAGE_GIF);
        mediaTypeMap.put(".pdf", MediaType.APPLICATION_PDF);
        mediaTypeMap.put(".ico", new MediaType("image", "vnd.microsoft.icon"));
        mediaTypeMap.put("", MediaType.TEXT_HTML);
    }

    @ResponseBody
    @RequestMapping(value={"/**/*.jpg", "/**/*.jpeg", "/**/*.png", "/**/*.gif", "/**/*.pdf", "/**/*.ico"})
    public HttpEntity<byte[]> getImageResource(HttpServletRequest req, HttpServletResponse res) throws IOException {
        File rootDir = this.pgService.getPageDir();
        File file = this.pgService.getPageDataFile(rootDir, req);
        MediaType mt = this.getMediaType(req, false);
        byte[] by = FileUtils.readFileToByteArray((File)file);
        HttpHeaders headers = this.createHeaders(mt, by);
        return new HttpEntity((Object)by, (MultiValueMap)headers);
    }

    @ResponseBody
    @RequestMapping(value={"/**/*.js", "/**/*.css", "/**/*.html", "/**/*.htm", "/**/*.txt"})
    public HttpEntity<byte[]> getTextResource(HttpServletRequest req, HttpServletResponse res) throws IOException {
        byte[] by;
        String org;
        File rootDir = this.pgService.getPageDir();
        File file = this.pgService.getPageDataFile(rootDir, req);
        MediaType mt = this.getMediaType(req, true);
        UsingInfo ui = UsingInfo.getInitInstance(req);
        String dst = ui.replaceSring(org = new String(by = FileUtils.readFileToByteArray((File)file), mt.getCharset()));
        if (dst != org) {
            by = dst.getBytes(mt.getCharset());
        }
        HttpHeaders headers = this.createHeaders(mt, by);
        return new HttpEntity((Object)by, (MultiValueMap)headers);
    }

    private MediaType getMediaType(HttpServletRequest req, boolean isText) {
        String id = req.getRequestURI();
        int n = id.lastIndexOf(46);
        String ext = n >= 0 ? id.substring(n).toLowerCase() : "";
        MediaType mt = mediaTypeMap.get(ext);
        if (isText) {
            String ac = req.getHeader("Accept-Charset");
            ac = StringUtils.isEmpty((CharSequence)ac) ? this.defaultCharset : ac;
            Charset charset = Charset.forName(ac);
            mt = new MediaType(mt, charset);
        }
        return mt;
    }

    private HttpHeaders createHeaders(MediaType mt, byte[] by) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mt);
        headers.setContentLength((long)by.length);
        return headers;
    }
}

