/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.data;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.nanah.bastub.util.BastubUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsingInfo {
    protected static final Logger logger = LoggerFactory.getLogger(UsingInfo.class);
    private List<Row> dataList;
    private Map<String, String> replaceConst = new HashMap<String, String>();
    private static SimpleDateFormat DF_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private int[] usedRow;

    public static UsingInfo getInitInstance(HttpServletRequest req) {
        String[] pathArray = req.getRequestURI().split("/");
        List<String> pathList = Arrays.asList(pathArray);
        return UsingInfo.getInitInstance(pathList, req, null);
    }

    public static UsingInfo getInitInstance(List<String> pathList, HttpServletRequest req, Map body) {
        UsingInfo ui = new UsingInfo();
        Map<String, String> map = ui.replaceConst;
        String ymdhms = DF_DATE.format(new Date());
        HttpSession session = req.getSession(true);
        map.put("${#SYSDATE#}", ymdhms);
        map.put("${#SYS_YMDHMS#}", ymdhms);
        map.put("${#SYS_YMD#}", ymdhms.substring(0, 10));
        map.put("${#SYS_HM#}", ymdhms.substring(11, 19));
        map.put("${#SYS_MSEC#}", String.valueOf(System.currentTimeMillis()));
        map.put("${#SYS_SEC#}", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("${#THREAD_ID#}", String.valueOf(Thread.currentThread().getId()));
        map.put("${#THREAD_NAME#}", Thread.currentThread().getName());
        map.put("${#SESSION_ID#}", session.getId());
        int i = 0;
        while (i < pathList.size()) {
            map.put("${#PATH" + i + "#}", pathList.get(i));
            ++i;
        }
        String url = req.getRequestURL().toString();
        map.put("${#URL#}", url);
        map.put("${#URL_#}", req.getContextPath());
        map.put("${#DOMAIN#}", BastubUtils.getUrlDomain(url));
        ui.putReplaceMap("", req.getParameterMap(), map);
        ui.putReplaceMap("", body, map);
        for (String mapkey : map.keySet()) {
            logger.info("\u5168\u7f6e\u304d\u63db\u3048\u6587\u5b57: [{}]=[{}]", (Object)mapkey, (Object)map.get(mapkey));
        }
        return ui;
    }

    public void putReplaceMap(String pkey, Map valMap, Map<String, String> replaceMap) {
        if (valMap == null) {
            return;
        }
        Set keys = valMap.keySet();
        for (Object k : keys) {
            String repkey;
            String key = String.valueOf(pkey.length() == 0 ? "" : String.valueOf(pkey) + ".") + k.toString();
            Object val = valMap.get(k);
            if (val == null) continue;
            if (val instanceof Map) {
                this.putReplaceMap(key, (Map)val, replaceMap);
                continue;
            }
            if (val instanceof List) {
                List list = (List)val;
                int i = 0;
                while (i < list.size()) {
                    repkey = this.getReplaceKey(String.valueOf(key) + i, "#", "#");
                    replaceMap.put(repkey, val.toString());
                    ++i;
                }
                continue;
            }
            if (val instanceof String[]) {
                String[] valary = (String[])val;
                if (valary.length == 1) {
                    String repkey2 = this.getReplaceKey(key, "#", "#");
                    replaceMap.put(repkey2, valary[0]);
                    continue;
                }
                int i = 0;
                while (i < valary.length) {
                    repkey = this.getReplaceKey(String.valueOf(key) + i, "#", "#");
                    replaceMap.put(repkey, valary[i]);
                    ++i;
                }
                continue;
            }
            String repkey3 = this.getReplaceKey(key, "#", "#");
            replaceMap.put(repkey3, val.toString());
        }
    }

    private String getReplaceKey(String inkey, String prefix, String suffix) {
        suffix = suffix == null ? prefix : suffix;
        return "${" + prefix + inkey + suffix + "}";
    }

    private UsingInfo() {
    }

    public UsingInfo(List<Row> dataList, UsingInfo ui) {
        this.dataList = dataList;
        short colMax = dataList.size() > 0 ? dataList.get(0).getLastCellNum() : (short)0;
        this.usedRow = new int[colMax];
        if (ui != null) {
            this.replaceConst = ui.getReplaceConst();
        }
    }

    public Map<String, String> getReplaceConst() {
        return this.replaceConst;
    }

    public String getDirectValue(List<String> keyList, String key, String orgval) {
        if (orgval == null) {
            return "";
        }
        String dstval = orgval;
        int colIndex = BastubUtils.getColumnNoForReplace(orgval, this.dataList, key);
        if (colIndex >= 0) {
            if (this.dataList.size() > 1) {
                int dataRow = this.usedRow[colIndex] + 1;
                if (dataRow < this.dataList.size()) {
                    dstval = BastubUtils.getCellText(this.dataList.get(dataRow).getCell(colIndex));
                    int n = colIndex;
                    this.usedRow[n] = this.usedRow[n] + 1;
                } else {
                    dstval = "";
                    logger.warn("[{}]: JSON\u5185\u3067\u30ad\u30fc {\"{}\" \u304c\u91cd\u8907\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u3042\u308a", keyList, (Object)key);
                }
            }
        } else {
            String rep = this.replaceConst.get(orgval);
            if (rep != null) {
                dstval = rep;
            }
        }
        return dstval;
    }

    public List<Row> getLoweredData() {
        if (this.dataList.size() < 2) {
            return this.dataList;
        }
        ArrayList<Row> loweredList = new ArrayList<Row>();
        Map<Integer, List<String>> usedDataMap = this.getUsedDataMap();
        if (usedDataMap.size() == 0) {
            return this.dataList;
        }
        int r = 0;
        while (r < this.dataList.size()) {
            Row rowVal = this.dataList.get(r);
            if (r == 0 || this.isUsedData(usedDataMap, rowVal)) {
                loweredList.add(rowVal);
            }
            ++r;
        }
        return loweredList;
    }

    Map<Integer, List<String>> getUsedDataMap() {
        LinkedHashMap<Integer, List<String>> usedDataMap = new LinkedHashMap<Integer, List<String>>();
        int c = 0;
        while (c < this.usedRow.length) {
            if (this.usedRow[c] > 0) {
                ArrayList<String> usedList = new ArrayList<String>();
                int r = 1;
                while (r <= this.usedRow[c]) {
                    Cell cell = this.dataList.get(r).getCell(c);
                    usedList.add(BastubUtils.getCellText(cell));
                    ++r;
                }
                usedDataMap.put(new Integer(c), usedList);
            }
            ++c;
        }
        return usedDataMap;
    }

    public boolean isUsedData(Map<Integer, List<String>> usedMap, Row rowVal) {
        for (Integer key : usedMap.keySet()) {
            String v = BastubUtils.getCellText(rowVal.getCell(key.intValue()));
            if (usedMap.get(key).contains(v)) continue;
            return false;
        }
        return true;
    }

    public String replaceSring(String s) {
        for (Map.Entry<String, String> ent : this.replaceConst.entrySet()) {
            String key = ent.getKey();
            while (s.contains(key)) {
                s = s.replace(key, ent.getValue());
            }
        }
        return s;
    }
}

