/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.filter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.nanah.bastub.filter.BastubHttpRequest;
import jp.nanah.bastub.service.PathService;
import jp.nanah.bastub.util.BastubUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReplaceFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(BastubHttpRequest.class);
    private File replaceFile = null;
    private long lastUpdated = 0L;
    private List<String[]> replaceList;

    public void init(FilterConfig filterConfig) throws ServletException {
        System.out.println("init!!");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri;
        File file;
        String orgurl;
        System.out.println("doFilter...");
        BastubHttpRequest req = new BastubHttpRequest((HttpServletRequest)request);
        String url = orgurl = req.getRequestURL().toString();
        List<String[]> pathList = this.getReplacePathList();
        String repurl = this.replacePath(pathList, orgurl);
        if (repurl != null) {
            logger.debug("replace1: [{}]-->[{}]", (Object)url, (Object)repurl);
            url = repurl;
        }
        if ((file = new File(PathService.pageDir, String.valueOf(uri = BastubUtils.getUriPath(url)) + ".html")).exists()) {
            url = String.valueOf(url) + ".$view";
            logger.debug("replace2: -->[{}]", (Object)url);
        }
        req.setUrl(url);
        chain.doFilter((ServletRequest)req, response);
    }

    public String replacePath(List<String[]> pathList, String src) {
        logger.debug("\u7f6e\u304d\u63db\u3048\u5b9a\u7fa9\u6570: [{}]", (Object)pathList.size());
        for (String[] path : pathList) {
            logger.debug("src=[{}]: path=[{}][{}]", new Object[]{src, path[0], path[1]});
            int n = src.indexOf(path[0]);
            if (n < 0) continue;
            return src.replace(path[0], path[1]);
        }
        return null;
    }

    public List<String[]> getReplacePathList() {
        if (this.replaceFile == null) {
            URL replaceFileUrl = this.getClass().getResource("/replace.properties");
            this.replaceFile = new File(replaceFileUrl.getFile());
        }
        if (this.replaceList != null && this.lastUpdated == this.replaceFile.lastModified()) {
            return this.replaceList;
        }
        try {
            List lines = FileUtils.readLines((File)this.replaceFile);
            TreeMap<String, String> sdMap = new TreeMap<String, String>();
            for (String s : lines) {
                int n;
                if (s.startsWith("#") || (n = (s = StringUtils.normalizeSpace((String)s)).indexOf(" ")) < 0) continue;
                String src = s.substring(0, n);
                String dst = s.substring(n).trim();
                sdMap.put(src, dst);
            }
            this.replaceList = new ArrayList<String[]>();
            for (String srcPath : sdMap.keySet()) {
                String dstPath = (String)sdMap.get(srcPath);
                this.replaceList.add(0, new String[]{srcPath, dstPath});
                logger.info("[{}] src=[{}] dst=[{}]", new Object[]{this.replaceList.size(), srcPath, dstPath});
            }
        }
        catch (IOException e) {
            logger.warn("read_error:{}", (Object)this.replaceFile.getAbsolutePath());
        }
        return this.replaceList;
    }
}

