/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nanah.bastub.data.FilterParam;
import jp.nanah.bastub.data.JsonInfo;
import jp.nanah.bastub.data.KvData;
import jp.nanah.bastub.data.UsingInfo;
import jp.nanah.bastub.service.PathService;
import jp.nanah.bastub.util.BastubUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.ui.ModelMap;

@Service
public class JsonService {
    protected static final Logger logger = LoggerFactory.getLogger(JsonService.class);
    public static final List<Row> NO_FILTERING_DATA_NONE = new ArrayList<Row>();
    public static final String JSON_DATA_NONE_TEXT = "{\"key\":\"auto created.\"}";
    @Value(value="${auto_create:false}")
    protected boolean isAutoCreate;
    @Autowired
    private PathService pathService;
    private Map<String, Object[]> workbookCache = new TreeMap<String, Object[]>();

    public String getAny(List<String> pathList, Map body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        try {
            File pageDir = this.pathService.getPageDir();
            if (!pageDir.exists()) {
                String errormsg = "Bastub\u306e\u8a2d\u5b9a\u30d5\u30a9\u30eb\u30c0[" + pageDir.getAbsolutePath() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002application.properties\u306epagedata.root\u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                logger.info(errormsg);
                return errormsg;
            }
            UsingInfo ui = UsingInfo.getInitInstance(pathList, req, body);
            String path = StringUtils.join(pathList, (String)"/");
            File dataFile = BastubUtils.getPagedataPath(pageDir, path, req.getMethod(), ".xlsx,.xls");
            File jsonFile = BastubUtils.getPagedataPath(pageDir, path, req.getMethod(), ".json");
            Sheet paramSheet = null;
            Sheet dataSheet = null;
            Workbook wb = this.readWorkbook(dataFile);
            if (wb == null) {
                logger.warn("Excel\u30d5\u30a1\u30a4\u30eb\u7121\u3057\u306e\u305f\u3081JSON\u3092\u56fa\u5b9a\u3067\u5fdc\u7b54 (ExcelFile=[{}])", (Object)dataFile.getAbsolutePath());
            } else {
                paramSheet = wb.getSheet("filter");
                dataSheet = wb.getSheet("data");
                wb.close();
                if (paramSheet == null) {
                    logger.debug("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb[{}]\u306b[filter]\u30b7\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)dataFile.getAbsolutePath());
                }
                if (dataSheet == null) {
                    logger.debug("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb[{}]\u306b[data]\u30b7\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)dataFile.getAbsolutePath());
                }
            }
            this.trimDataSheet(dataSheet);
            List<KvData> requestData = this.getRequestData(req.getParameterMap(), body);
            List<FilterParam> allFilter = this.getFilterParamList(paramSheet);
            List<FilterParam> validFilter = null;
            if (allFilter != null) {
                validFilter = this.getValidFilter(allFilter, requestData, pathList);
            }
            List<Row> resultTarget = this.pickupSheetData(dataSheet, validFilter);
            JsonInfo jsonInfo = this.readJsonFile(jsonFile);
            if (jsonInfo.getJsonObject() == null) {
                res.setStatus(404);
                String jsonPath = jsonFile.getAbsolutePath();
                logger.warn("## \u25c6 \u5fdc\u7b54JSON\u7570\u5e38: \u7406\u7531=[{}] \u30d1\u30b9=[{}]", (Object)jsonInfo.getErrorMessage(), (Object)jsonPath);
                String errorJson = "no_file - " + jsonPath.replaceAll("\\\\", "/") + "]";
                return errorJson;
            }
            this.setDataToJsonObject(null, jsonInfo.getJsonObject(), resultTarget, ui);
            String jsonText = jsonInfo.getJsonObject().toString(4);
            if (jsonInfo.isTopArray()) {
                int n1 = jsonText.indexOf(":");
                int n2 = jsonText.lastIndexOf("}");
                jsonText = jsonText.substring(n1 + 1, n2);
            }
            res.addHeader("Access-Control-Allow-Origin", "*");
            return jsonText;
        }
        catch (Throwable th) {
            logger.info("\u51e6\u7406\u7570\u5e38: {}", th);
            return th.toString();
        }
    }

    protected synchronized Workbook readWorkbook(File file) throws IOException {
        Long filetime;
        if (!file.exists()) {
            return null;
        }
        String key = file.getAbsolutePath();
        Object[] cache = this.workbookCache.get(key);
        if (cache != null && (filetime = (Long)cache[0]).longValue() == file.lastModified()) {
            return (Workbook)cache[1];
        }
        Workbook wb = WorkbookFactory.create((File)file, null, (boolean)true);
        this.workbookCache.put(key, new Object[]{file.lastModified(), wb});
        return wb;
    }

    protected void trimDataSheet(Sheet sheet) {
        if (sheet == null || sheet.getLastRowNum() == 0) {
            return;
        }
        Row topRow = sheet.getRow(0);
        int lastColNum = topRow.getLastCellNum() - 1;
        while (lastColNum >= 0) {
            Cell cell = topRow.getCell(lastColNum);
            String s = BastubUtils.getCellText(cell);
            if (StringUtils.isNotBlank((CharSequence)s)) break;
            --lastColNum;
        }
        int rowNum = sheet.getLastRowNum();
        while (rowNum >= 0) {
            Row row = sheet.getRow(rowNum);
            if (row != null) {
                if (BastubUtils.isBlankRow(row)) {
                    sheet.removeRow(row);
                } else {
                    int i = row.getLastCellNum() - 1;
                    while (i > lastColNum) {
                        Cell cell = row.getCell(i);
                        if (cell != null) {
                            row.removeCell(cell);
                        }
                        --i;
                    }
                }
            }
            --rowNum;
        }
    }

    public List<KvData> getRequestData(Map<String, String[]> paramMap, Map body) {
        ArrayList<KvData> paramList = new ArrayList<KvData>();
        if (paramMap != null) {
            int cnt = 0;
            for (Map.Entry<String, String[]> ent : paramMap.entrySet()) {
                if (BastubUtils.isJsonEntry(ent)) continue;
                List<String> key = Arrays.asList(ent.getKey());
                String[] stringArray = ent.getValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    KvData kv = this.appendKvParam(new KvData(key, val), paramList);
                    ++cnt;
                    ++n2;
                }
            }
        }
        if (body != null) {
            int startSize = paramList.size();
            this.appendEntryToParamList(body.entrySet(), null, paramList);
            int i = startSize;
            while (i < paramList.size()) {
                KvData kvData = (KvData)paramList.get(i);
                ++i;
            }
        }
        return paramList;
    }

    private KvData appendKvParam(KvData src, List<KvData> dstList) {
        KvData nowval = null;
        int i = 0;
        while (i < dstList.size()) {
            if (BastubUtils.equals(dstList.get(i).getKey(), src.getKey())) {
                nowval = dstList.get(i);
                break;
            }
            ++i;
        }
        if (nowval == null) {
            dstList.add(src);
            nowval = src;
        } else {
            nowval.addValue(src.getValueAsOne());
        }
        return nowval;
    }

    private void appendEntryToParamList(Set<Map.Entry<String, Object>> set, List<String> parentKeys, List<KvData> paramList) {
        int count = 0;
        for (Map.Entry<String, Object> ent : set) {
            String key = ent.getKey();
            Object val = ent.getValue() == null ? "" : ent.getValue();
            ArrayList<String> thisKeys = new ArrayList<String>();
            if (parentKeys != null) {
                thisKeys.addAll(parentKeys);
            }
            thisKeys.add(key);
            if (val instanceof Map) {
                Map vmap = (Map)val;
                this.appendEntryToParamList(vmap.entrySet(), thisKeys, paramList);
            } else if (val instanceof List) {
                List vlist = (List)val;
                this.appendListToParamList(vlist, thisKeys, paramList);
            } else {
                this.appendToParamList(val, thisKeys, paramList);
            }
            ++count;
        }
    }

    private void appendListToParamList(List<Object> list, List<String> parentKeys, List<KvData> paramList) {
        for (Object o : list) {
            if (o instanceof Map) {
                Map map = (Map)o;
                this.appendEntryToParamList(map.entrySet(), parentKeys, paramList);
                continue;
            }
            if (o instanceof List) {
                List vlist = (List)o;
                this.appendListToParamList(vlist, parentKeys, paramList);
                continue;
            }
            this.appendToParamList(o, parentKeys, paramList);
        }
    }

    private void appendToParamList(Object obj, List<String> parentKeys, List<KvData> paramList) {
        String valstr = obj.toString();
        KvData kv = new KvData(parentKeys, valstr);
        this.appendKvParam(kv, paramList);
    }

    private List<FilterParam> getFilterParamList(Sheet sheet) {
        ArrayList<FilterParam> filterList = null;
        if (sheet == null) {
            return filterList;
        }
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i);
            List<String> cellList = BastubUtils.getRowValueList(row, false);
            if (cellList.size() >= 3) {
                if (filterList == null) {
                    filterList = new ArrayList<FilterParam>();
                }
                String cellName = cellList.get(0);
                String compType = cellList.get(1);
                List<String> paramKey = cellList.subList(2, cellList.size());
                FilterParam fp = new FilterParam(cellName, compType, paramKey);
                filterList.add(fp);
            }
            ++i;
        }
        return filterList;
    }

    public List<FilterParam> getValidFilter(List<FilterParam> filterParamList, List<KvData> requestData, List<String> pathList) {
        ArrayList<FilterParam> validList = new ArrayList<FilterParam>();
        for (FilterParam fp : filterParamList) {
            int pathNumber;
            String key0;
            if (fp.getRequestKeys().size() > 0 && (key0 = fp.getRequestKeys().get(0)).startsWith("$") && (pathNumber = NumberUtils.toInt((String)key0.substring(1))) > 0 && pathNumber <= pathList.size()) {
                fp.setOneValue(pathList.get(pathNumber - 1));
                validList.add(fp);
                continue;
            }
            List<String> reqKey = fp.getRequestKeys();
            boolean isFound = false;
            String delimText = this.getDelimText(fp.getCompareType());
            for (KvData kv : requestData) {
                if (!BastubUtils.equalsTail(kv.getKey(), reqKey)) continue;
                List<String> fpValues = this.toFilterValue(delimText, kv.getValues());
                fp.setValues(fpValues);
                validList.add(fp);
                isFound = true;
            }
            if (!isFound) {
                logger.warn("HTTP\u30ea\u30af\u30a8\u30b9\u30c8\u5185\u306b\u3001\u9805\u76ee\u5024[{}]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", reqKey);
            }
            if (delimText == null) continue;
            fp.setCompareType("=");
        }
        return validList;
    }

    private String getDelimText(String compareType) {
        int n1 = compareType.indexOf("[");
        int n2 = compareType.indexOf("]");
        if (n1 < 0 || n2 < 0) {
            return null;
        }
        String delim = compareType.substring(n1 + 1, n2);
        return delim;
    }

    private List<String> toFilterValue(String delimText, List<String> org) {
        if (delimText == null) {
            return org;
        }
        ArrayList<String> dst = new ArrayList<String>();
        for (String s : org) {
            dst.addAll(Arrays.asList(s.split(delimText, 0)));
        }
        return dst;
    }

    public List<Row> pickupSheetData(Sheet sheet, List<FilterParam> validFilter) {
        int i;
        ArrayList noDatasheet = new ArrayList();
        if (sheet == null) {
            return NO_FILTERING_DATA_NONE;
        }
        ArrayList<Row> sheetData = new ArrayList<Row>();
        int i2 = sheet.getFirstRowNum();
        while (i2 <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i2);
            if (row != null) {
                sheetData.add(sheet.getRow(i2));
            }
            ++i2;
        }
        if (validFilter == null || validFilter.isEmpty()) {
            return sheetData;
        }
        Object[] columnNames = this.getColumnNames(sheet);
        for (FilterParam fp : validFilter) {
            int columnIndex = ArrayUtils.indexOf((Object[])columnNames, (Object)fp.getColumnName());
            if (columnIndex < 0) {
                logger.warn("***** data\u30b7\u30fc\u30c8\u306b\u3001\u5217\u540d[{}]\u304c\u3042\u308a\u307e\u305b\u3093\u3002", (Object)fp.getColumnName());
                continue;
            }
            i = 1;
            while (i < sheetData.size()) {
                Cell cell;
                String v;
                Row row = (Row)sheetData.get(i);
                if (row != null && (v = BastubUtils.getCellText(cell = row.getCell(columnIndex))) != null) {
                    boolean isMatch = false;
                    String ct = fp.getCompareType();
                    for (String fv : fp.getValues()) {
                        int n;
                        if (StringUtils.isEmpty((CharSequence)fv) && !ct.equals("==")) {
                            n = 0;
                        } else if (StringUtils.isNumeric((CharSequence)v) && StringUtils.isNumeric((CharSequence)fv)) {
                            logger.info("\u6570\u5024\u5909\u63db[{}]: [{}]<-->[{}]", new Object[]{columnIndex, v, fv});
                            Integer v1 = Integer.parseInt(v);
                            Integer v2 = Integer.parseInt(fv);
                            n = v1.compareTo(v2);
                        } else {
                            n = v.compareTo(fv);
                        }
                        if (ct.equals("=") || ct.equals("==")) {
                            isMatch = n == 0;
                        } else if (ct.equals("<")) {
                            isMatch = n < 0;
                        } else if (ct.equals("<=")) {
                            isMatch = n <= 0;
                        } else if (ct.equals(">")) {
                            isMatch = n > 0;
                        } else if (ct.equals(">=")) {
                            isMatch = n >= 0;
                        } else if (ct.equals("!=") || ct.equals("<>")) {
                            boolean bl = isMatch = n != 0;
                        }
                        if (isMatch) break;
                    }
                    if (!isMatch) {
                        sheetData.set(i, null);
                    }
                }
                ++i;
            }
        }
        sheetData.removeAll(Collections.singleton(null));
        for (Row row : sheetData) {
            StringBuilder sb = new StringBuilder();
            i = row.getFirstCellNum();
            while (i < row.getLastCellNum()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(BastubUtils.getCellText(row.getCell(i)));
                ++i;
            }
        }
        return sheetData;
    }

    private String[] getColumnNames(Sheet sheet) {
        Row row = sheet.getRow(sheet.getFirstRowNum());
        String[] columns = new String[row.getLastCellNum()];
        int i = row.getFirstCellNum();
        while (i < row.getLastCellNum()) {
            columns[i] = BastubUtils.getCellText(row.getCell(i));
            ++i;
        }
        return columns;
    }

    public JsonInfo readJsonFile(File file) {
        String text;
        FileInputStream fis;
        JsonInfo jsonInfo;
        block12: {
            jsonInfo = new JsonInfo();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                jsonInfo.setErrorMessage("JSON\u30d5\u30a1\u30a4\u30eb\u304c\u672a\u8a2d\u5b9a\u3067\u3059");
                try {
                    if (this.isAutoCreate) {
                        FileUtils.writeByteArrayToFile((File)file, (byte[])JSON_DATA_NONE_TEXT.getBytes());
                        file.setLastModified(0L);
                    }
                }
                catch (Exception e) {
                    logger.info("\u5fdc\u7b54JSON - \u81ea\u52d5\u751f\u6210 [\u5931\u6557]: path=[{}]", (Object)file.getAbsolutePath());
                }
                return jsonInfo;
            }
            fis = null;
            fis = new FileInputStream(file);
            byte[] buff = new byte[(int)file.length()];
            IOUtils.readFully((InputStream)fis, (byte[])buff);
            text = new String(buff, "UTF-8");
            if (!text.equals(JSON_DATA_NONE_TEXT)) break block12;
            jsonInfo.setErrorMessage("JSON\u30d5\u30a1\u30a4\u30eb\u304c\u672a\u8a2d\u5b9a\u3067\u3059");
            JsonInfo jsonInfo2 = jsonInfo;
            IOUtils.closeQuietly((InputStream)fis);
            return jsonInfo2;
        }
        try {
            try {
                String reptext = this.adjustReplaceNumberValue(text);
                String trimText = reptext.trim();
                if (trimText.substring(0, 1).equals("[")) {
                    reptext = "{\"dummy\":" + reptext + "}";
                    jsonInfo.setTopArray(true);
                }
                try {
                    JSONObject jsonObject = new JSONObject(reptext);
                    jsonInfo.setJsonObject(jsonObject);
                    logger.debug("reptext ==[{}]", (Object)reptext);
                    logger.debug("\u9006\u5909\u63db  ==[{}]", (Object)jsonInfo.getJsonObject().toString(2));
                }
                catch (Throwable th) {
                    jsonInfo.setErrorMessage("JSON\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u66f8\u5f0f\u304c\u6b63\u3057\u304f\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                }
            }
            catch (Throwable th) {
                logger.warn("\u5fdc\u7b54\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557: path=[{}]", (Object)file.getAbsolutePath(), (Object)th);
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return jsonInfo;
    }

    private String adjustReplaceNumberValue(String org) {
        int pos = 0;
        String dst = org;
        while (pos < dst.length()) {
            int top = dst.indexOf("${", pos);
            if (top < 0) break;
            int last = BastubUtils.getNumberLast(dst, top);
            if (last >= 0) {
                String v = String.valueOf(dst.substring(top, last)) + "#N";
                dst = String.valueOf(dst.substring(0, top)) + "\"" + v + "\"" + dst.substring(last);
                pos = last + 1;
                continue;
            }
            ++pos;
        }
        return dst;
    }

    public void setDataToJsonObject(List<String> keyList, JSONObject jsonObj, List<Row> dataList, UsingInfo ui) {
        if (keyList == null) {
            keyList = new ArrayList<String>();
        }
        if (dataList == null) {
            dataList = new ArrayList<Row>();
        }
        UsingInfo ud = new UsingInfo(dataList, ui);
        List<String> allkeys = BastubUtils.sortIterator(jsonObj.keys());
        for (String key : allkeys) {
            String orgval;
            if (key == null || jsonObj.optJSONArray(key) != null || jsonObj.optJSONObject(key) != null || (orgval = jsonObj.optString(key)) == null) continue;
            try {
                String dstval = ud.getDirectValue(keyList, key, orgval);
                jsonObj.put(key, (Object)dstval);
            }
            catch (Exception e) {
                logger.warn("\u7f6e\u63db\u7570\u5e38", (Throwable)e);
            }
        }
        List<Row> nextLayerTarget = ud.getLoweredData();
        if (nextLayerTarget == null) {
            return;
        }
        for (String key : allkeys) {
            if (key == null) continue;
            ArrayList<String> nextKeyList = new ArrayList<String>(keyList);
            nextKeyList.add(key);
            if (jsonObj.optJSONArray(key) != null) {
                JSONArray jsonAry = jsonObj.optJSONArray(key);
                JSONArray extendAry = this.getExtendJsonArray(nextKeyList, jsonAry, nextLayerTarget, ui);
                try {
                    jsonObj.put(key, (Object)extendAry);
                }
                catch (Throwable th) {
                    logger.warn("\u914d\u5217\u30c7\u30fc\u30bf\u8a2d\u5b9a\u7570\u5e38", th);
                }
                continue;
            }
            if (jsonObj.optJSONObject(key) == null) continue;
            JSONObject nextJson = jsonObj.optJSONObject(key);
            this.setDataToJsonObject(nextKeyList, nextJson, nextLayerTarget, ui);
        }
    }

    public JSONArray getExtendJsonArray(List<String> keyList, JSONArray jsonAry, List<Row> dataList, UsingInfo ui) {
        JSONArray extendAry = new JSONArray();
        UsingInfo ud = new UsingInfo(dataList, ui);
        int i = 0;
        while (i < jsonAry.length()) {
            try {
                if (jsonAry.optJSONObject(i) != null) {
                    String baseText = jsonAry.getJSONObject(i).toString();
                    ArrayList<String> extendedList = new ArrayList<String>();
                    if (dataList != NO_FILTERING_DATA_NONE) {
                        int r = 1;
                        while (r < dataList.size()) {
                            ArrayList<Row> lowerDataList = new ArrayList<Row>();
                            lowerDataList.add(dataList.get(0));
                            lowerDataList.add(dataList.get(r));
                            JSONObject extendJson = new JSONObject(baseText);
                            this.setDataToJsonObject(keyList, extendJson, lowerDataList, ui);
                            String extendText = extendJson.toString();
                            if (!extendedList.contains(extendText)) {
                                extendedList.add(extendText);
                                extendAry.put(extendAry.length(), (Object)extendJson);
                            }
                            ++r;
                        }
                    } else {
                        JSONObject extendJson = new JSONObject(baseText);
                        this.setDataToJsonObject(keyList, extendJson, dataList, ui);
                        extendAry.put(extendAry.length(), (Object)extendJson);
                    }
                } else if (jsonAry.optJSONArray(i) != null) {
                    JSONArray thisAry = jsonAry.getJSONArray(i);
                    JSONArray childAry = this.getExtendJsonArray(keyList, thisAry, dataList, ui);
                    extendAry.put(extendAry.length(), (Object)childAry);
                } else {
                    String orgval = jsonAry.getString(i);
                    if (orgval != null) {
                        try {
                            String dstval = ud.getDirectValue(keyList, "", orgval);
                            extendAry.put(extendAry.length(), (Object)dstval);
                        }
                        catch (Exception e) {
                            logger.warn("\u7f6e\u63db\u7570\u5e38", (Throwable)e);
                        }
                    }
                }
            }
            catch (Throwable th) {
                logger.warn("\u5fdc\u7b54\u30c7\u30fc\u30bf\u751f\u6210\u7570\u5e38", th);
            }
            ++i;
        }
        return extendAry;
    }
}

