/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.service;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import jp.nanah.bastub.controller.AnyRestController;
import nanah.oslib.ResUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PathService {
    private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
    @Value(value="${pagedata.root:pagedata}")
    private String pagedataPath;
    public static File pageDir;
    @Value(value="${path_last_slash_valid:1}")
    private int pathLastSlashValid;

    @PostConstruct
    public void setupDir() throws Exception {
        pageDir = this.getPageDir();
    }

    public File getPageDir() {
        if (pageDir != null) {
            return pageDir;
        }
        File dir = new File(this.pagedataPath);
        if (!dir.isAbsolute()) {
            File appRoot = ResUtils.getRootDirAs(this.getClass());
            dir = new File(appRoot, this.pagedataPath);
        }
        try {
            pageDir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            pageDir = dir.getAbsoluteFile();
        }
        return pageDir;
    }

    public File getPageDataFile(File dir, HttpServletRequest req) {
        File file = new File(dir, req.getRequestURI());
        logger.debug("Path=[{}]", (Object)file.getAbsolutePath());
        return file;
    }

    public List<String> getPathList(HttpServletRequest req) {
        String reqPath = req.getRequestURI();
        String[] pathArray = reqPath.substring(1).split("/");
        List<String> pathList = Arrays.asList(pathArray);
        if (this.pathLastSlashValid == 1) {
            logger.info("URL={}, URI={}", (Object)req.getRequestURL().toString(), (Object)reqPath);
            if (reqPath.endsWith("/")) {
                pathList.add("");
            }
        }
        return pathList;
    }
}

