#include <cstdlib>
#include <cstdio>
#include <cstring>

#include <vector>
#include <map>
#include <string>

#include "xlsxio_read.h"

typedef std::map<std::pair<size_t, size_t>, std::string> sheet_type;
typedef std::vector<std::pair<std::string, sheet_type>> sheets_type;

int main (int argc, char* argv[]) {
	if (argc == 1) return 0;
	xlsxioreader xlsxioread;
	if (!(xlsxioread = xlsxioread_open(argv[1]))){
		printf("file open error.\n");
		return 1;
	}

	sheets_type sheets;

	// list available sheets
	std::fprintf(stderr, "Available sheets:\n");
	xlsxioread_list_sheets(xlsxioread, [](const char* name, void* psheets_ptr){
		((sheets_type*)psheets_ptr)->push_back(std::make_pair(name, sheet_type()));
		std::fprintf(stderr, "%s\n", name);
		return 0;
	}, &sheets);
	std::fprintf(stderr, "Sheets found: %u\n", sheets.size());

	// read ID sheets
	for (size_t i = 0; i < sheets.size(); ++i){
		std::string &name = sheets[i].first;
		std::fprintf(stderr, "[Sheet %s]\n", name.c_str());
		xlsxioread_process(xlsxioread, name.c_str(), XLSXIOREAD_SKIP_ALL_EMPTY,
			[](size_t row, size_t col, const char* value, void* psheet_ptr){
				((sheet_type *)psheet_ptr)->insert(std::make_pair(std::make_pair(row, col), value));
				std::fprintf(stderr, "[%d,%d]:%s\n", (int)row, (int)col, value);
				return 0;
			}, NULL, &sheets[i].second
		);
	}

	//clean up
	xlsxioread_close(xlsxioread);

	// specific process
	const char *filename = argv[1] + std::strlen(argv[1]);
	while(filename > argv[1] && *filename != '\\') --filename; 
	if (*filename == '\\') ++filename;

	for (size_t k = 0; k < sheets.size(); ++k){
		std::string &name = sheets[k].first;
		sheet_type &sheet = sheets[k].second;
		// ...
	}

	return 0;
}
