#!/bin/bash
# Copyright (C) 2021 Jone Bontus
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# ``Software''), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

set -e

if [ -z "$EPOCROOT" ] ; then
	echo EPOCROOT not set.
	exit 1
fi

ARCH=armv5
SBS_GCCE1020BIN=C:/apps/gcc-10.2.0/bin
AR=$SBS_GCCE1020BIN/arm-none-symbianelf-ar
RANLIB=$SBS_GCCE1020BIN/arm-none-symbianelf-ranlib
OBJCOPY=$SBS_GCCE1020BIN/arm-none-symbianelf-objcopy

DFPAEABI_OBJS="libgcc/_arm_addsubdf3.o libgcc/_arm_addsubsf3.o libgcc/_arm_cmpdf2.o libgcc/_arm_cmpsf2.o libgcc/_arm_fixdfsi.o \
	libgcc/_arm_fixsfsi.o libgcc/_arm_fixunsdfsi.o libgcc/_arm_fixunssfsi.o libgcc/_arm_muldivdf3.o libgcc/_arm_muldivsf3.o \
	libgcc/_arm_negdf2.o libgcc/_arm_negsf2.o libgcc/_arm_truncdfsf2.o libgcc/_arm_unorddf2.o libgcc/_arm_unordsf2.o libgcc/_fixdfdi.o \
	libgcc/_fixsfdi.o libgcc/_fixunsdfdi.o libgcc/_fixunssfdi.o"
DRTAEABI_OBJS="libsupc++/array_type_info.o libsupc++/bad_cast.o libsupc++/bad_typeid.o libsupc++/class_type_info.o \
	libsupc++/del_ops.o libsupc++/dyncast.o libsupc++/eh_arm.o libsupc++/eh_aux_runtime.o libsupc++/eh_call.o \
	libsupc++/eh_catch.o libsupc++/eh_exception.o libsupc++/eh_personality.o libsupc++/eh_throw.o libsupc++/eh_type.o \
	libsupc++/enum_type_info.o libsupc++/function_type_info.o libsupc++/fundamental_type_info.o libsupc++/guard.o \
	libsupc++/guard_error.o libsupc++/pbase_type_info.o libsupc++/pmem_type_info.o libsupc++/pointer_type_info.o \
	libsupc++/pure.o libsupc++/si_class_type_info.o libsupc++/tinfo.o libsupc++/tinfo2.o libsupc++/vec.o \
	libsupc++/vmi_class_type_info.o libsupc++/bad_alloc.o libsupc++/bad_array_new.o libgcc/_aeabi_lcmp.o libgcc/_aeabi_ldivmod.o \
	libgcc/_aeabi_ulcmp.o libgcc/_aeabi_uldivmod.o libgcc/_ashldi3.o libgcc/_ashrdi3.o libgcc/_divsi3.o libgcc/_dvmd_tls.o libgcc/_lshrdi3.o \
	libgcc/_muldi3.o libgcc/_udivmoddi4.o libgcc/_udivsi3.o libgcc/libunwind.o libgcc/pr-support.o libgcc/unaligned-funcs.o libgcc/unwind-arm.o"
KERNEL_LIBGCC_OBJS="libgcc/_aeabi_lcmp.o libgcc/_aeabi_ldivmod.o libgcc/_aeabi_ulcmp.o libgcc/_aeabi_uldivmod.o libgcc/_ashldi3.o \
	libgcc/_ashrdi3.o libgcc/_divsi3.o libgcc/_dvmd_tls.o libgcc/_lshrdi3.o libgcc/_muldi3.o libgcc/_udivmoddi4.o libgcc/_udivsi3.o \
	libgcc/libunwind.o libgcc/pr-support.o libgcc/unaligned-funcs.o libgcc/unwind-arm.o"
KERNEL_LIBSUPCXX_OBJS="libsupc++/class_type_info.o libsupc++/del_ops.o libsupc++/guard.o libsupc++/guard_error.o \
	libsupc++/new_opnt.o libsupc++/new_opvnt.o libsupc++/pure.o libsupc++/si_class_type_info.o libsupc++/tinfo.o \
	libsupc++/vmi_class_type_info.o libsupc++/eh_catch.o libsupc++/eh_exception.o libsupc++/eh_globals.o \
	libsupc++/eh_personality.o libsupc++/eh_terminate.o libsupc++/eh_throw.o libsupc++/eh_unex_handler.o libsupc++/eh_arm.o \
	libsupc++/eh_call.o libsupc++/eh_term_handler.o"

WORKDIR=$(mktemp -d)
cd $WORKDIR
mkdir libgcc
mkdir libsupc++

(cd libgcc && $AR x "$SBS_GCCE1020BIN/../lib/gcc/arm-none-symbianelf/10.2.0/libgcc.a")
(cd libsupc++ && $AR x "$SBS_GCCE1020BIN/../arm-none-symbianelf/lib/libsupc++.a")

mkdir dfpaeabi
mkdir drtaeabi
mkdir kernel
mkdir kernel/libgcc
mkdir kernel/libsupc++

prep_gen_lib() {
	DEST_OBJS=
	for obj in $SRC_OBJS; do
		DEST_OBJS="$DEST_OBJS $(basename $obj)"
	done
	cp -Rp $SRC_OBJS $OBJS_DEST_DIR/
	for obj in $DEST_OBJS; do
		perl $EPOCROOT/epoc32/tools/elfexport.pl $DEFFILE $OBJS_DEST_DIR/$obj
	done
}

make_global() {
	SYMBOLS_MAKE_GLOBAL_ARGS=
	for sym in $SYMBOLS_MAKE_GLOBAL; do
		SYMBOLS_MAKE_GLOBAL_ARGS="$SYMBOLS_MAKE_GLOBAL_ARGS --localize-symbol $sym"
	done
	$OBJCOPY$SYMBOLS_MAKE_GLOBAL_ARGS $FROM_OBJ
	SYMBOLS_MAKE_GLOBAL_ARGS=
	for sym in $SYMBOLS_MAKE_GLOBAL; do
		SYMBOLS_MAKE_GLOBAL_ARGS="$SYMBOLS_MAKE_GLOBAL_ARGS --globalize-symbol $sym"
	done
	$OBJCOPY$SYMBOLS_MAKE_GLOBAL_ARGS $FROM_OBJ
}

# dfpaeabi.lib
DEFFILE=$EPOCROOT/sf/os/kernelhwsrv/kernel/eka/compsupp/eabi/dfpaeabiu.def
SRC_OBJS=$DFPAEABI_OBJS
OBJS_DEST_DIR=dfpaeabi
OUTPUT=dfpaeabi.lib
prep_gen_lib

(cd $OBJS_DEST_DIR && $AR cr "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT" $DEST_OBJS)
$RANLIB "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT"

# drtaeabi.lib
DEFFILE=$EPOCROOT/sf/os/kernelhwsrv/kernel/eka/compsupp/eabi/drtaeabiu.def
SRC_OBJS=$DRTAEABI_OBJS
OBJS_DEST_DIR=drtaeabi
OUTPUT=drtaeabi.lib
prep_gen_lib

SYMBOLS_MAKE_GLOBAL="_ZTIPKa _ZTIPKb _ZTIPKc _ZTIPKd _ZTIPKe _ZTIPKf _ZTIPKh _ZTIPKi _ZTIPKj _ZTIPKl _ZTIPKm _ZTIPKs _ZTIPKt _ZTIPKv \
	_ZTIPKw _ZTIPKx _ZTIPKy _ZTIPa _ZTIPb _ZTIPc _ZTIPd _ZTIPe _ZTIPf _ZTIPh _ZTIPi _ZTIPj _ZTIPl _ZTIPm _ZTIPs _ZTIPt _ZTIPv _ZTIPw _ZTIPx _ZTIPy _ZTIa \
	_ZTIb _ZTIc _ZTId _ZTIe _ZTIf _ZTIh _ZTIi _ZTIj _ZTIl _ZTIm _ZTIs _ZTIt _ZTIv _ZTIw _ZTIx _ZTIy"
FROM_OBJ=$OBJS_DEST_DIR/fundamental_type_info.o
make_global

SYMBOLS_MAKE_GLOBAL="__aeabi_idiv0 __aeabi_ldiv0"
FROM_OBJ=$OBJS_DEST_DIR/_dvmd_tls.o
make_global

SYMBOLS_MAKE_GLOBAL="__aeabi_unwind_cpp_pr1 __aeabi_unwind_cpp_pr2"
FROM_OBJ=$OBJS_DEST_DIR/unwind-arm.o
make_global

(cd $OBJS_DEST_DIR && $AR cr "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT" $DEST_OBJS)
$RANLIB "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT"

# libgcc.lib for kernel
DEFFILE=$EPOCROOT/sf/os/kernelhwsrv/kernel/eka/eabi/ekernu.def
SRC_OBJS=$KERNEL_LIBGCC_OBJS
OBJS_DEST_DIR=kernel/libgcc
OUTPUT=libgcc.lib
prep_gen_lib

SYMBOLS_MAKE_GLOBAL="__aeabi_idiv0 __aeabi_ldiv0"
FROM_OBJ=$OBJS_DEST_DIR/_dvmd_tls.o
make_global

(cd $OBJS_DEST_DIR && $AR cr "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT" $DEST_OBJS)
$RANLIB "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT"

# libsupc++.lib for kernel
DEFFILE=$EPOCROOT/sf/os/kernelhwsrv/kernel/eka/eabi/ekernu.def
SRC_OBJS=$KERNEL_LIBSUPCXX_OBJS
OBJS_DEST_DIR=kernel/libsupc++
OUTPUT=libsupc++.lib
prep_gen_lib

(cd $OBJS_DEST_DIR && $AR cr "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT" $DEST_OBJS)
$RANLIB "$EPOCROOT/epoc32/release/$ARCH/udeb/$OUTPUT"

cd ..
rm -rf $WORKDIR

cp -Rp "$EPOCROOT/epoc32/release/$ARCH/udeb/dfpaeabi.lib" "$EPOCROOT/epoc32/release/$ARCH/urel/dfpaeabi.lib"
cp -Rp "$EPOCROOT/epoc32/release/$ARCH/udeb/drtaeabi.lib" "$EPOCROOT/epoc32/release/$ARCH/urel/drtaeabi.lib"
cp -Rp "$EPOCROOT/epoc32/release/$ARCH/udeb/libgcc.lib" "$EPOCROOT/epoc32/release/$ARCH/urel/libgcc.lib"
cp -Rp "$EPOCROOT/epoc32/release/$ARCH/udeb/libsupc++.lib" "$EPOCROOT/epoc32/release/$ARCH/urel/libsupc++.lib"
