// Copyright (c) 2021 Jone Bontus
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Jone Bontus
//
// Contributors:
//
// Description:
// This file is part of usrt.lib and ksrt.lib.
//

#include <e32def.h>

extern "C" {

typedef void (*_PVFV)(void);

extern _PVFV SHT$$INIT_ARRAY$$Base[] __WEAK__;
extern _PVFV SHT$$INIT_ARRAY$$Limit[] __WEAK__;

void __cpp_initialize__aeabi_()
	{
	TInt *base = (TInt *)SHT$$INIT_ARRAY$$Base;
	TInt *limit = (TInt *)SHT$$INIT_ARRAY$$Limit;
	_PVFV entry;

	while (base != limit)
		{
		// Entries are relative to base.
		entry = (_PVFV)((TInt8 *)base + *base);
		entry();
		base++;
		}

#ifndef __KERNEL_MODE__
	asm(".cantunwind ");
#endif
	}

} // extern "C"

// Define std::nothrow as part of runtime startup code.
const std::nothrow_t std::nothrow = std::nothrow_t
	{
	};
