<?xml version="1.0"?>
<project name="SF-SOURCESPEC" default="all" xmlns:hlm="http://www.nokia.com/helium">

<#assign dollar = "$"/>

	<import file="${dollar}{sf.common.config.dir}/build.retry.xml"/>

	<!-- Convert \s in cache location, because otherwise they disappear entirely when used in a regex replacement! -->
	<propertyregex property="sf.spec.sourcesync.cachelocation.for.regex" input="${dollar}{sf.spec.sourcesync.cachelocation}" regexp="\\" replace="/" global="true" defaultValue="${dollar}{sf.spec.sourcesync.cachelocation}"/>

<#assign fileset = "" />
<#assign sync_list = "" />
<#assign bom_list  = "" />
<#assign change_list  = "" />
<#assign count = 0 />

<#list data as csv_file>
  <#list csv_file as pkg_detail>
	<target name="sf-prebuild-${count}">

		<!-- if defined the revision override take that as revision and change the url to point to FCL -->
		<if>
			<not><equals arg1="${ant['sf.spec.sources.revision']}" arg2="" trim="true"/></not>
			<then>
				<property name="sources.${count}.revision" value="${ant['sf.spec.sources.revision']}"/>
				<propertyregex property="sources.${count}.URL" input="${pkg_detail.source}" regexp="/MCL/" casesensitive="false" replace="/FCL/" defaultValue="${pkg_detail.source}"/>
			</then>
			<else>
				<property name="sources.${count}.revision" value="${pkg_detail.pattern}"/>
				<property name="sources.${count}.URL" value="${pkg_detail.source}"/>
			</else>
		</if>

		<!-- Create sf\layer dir on build dir -->
		<mkdir dir="${ant['build.drive']}${pkg_detail.dst}"/>
		<delete dir="${ant['build.drive']}${pkg_detail.dst}" failonerror="true" />

		<!-- Checksum -->
		<property name="sf.sourcesync.${count}.checksum" value="${pkg_detail.pattern}"/>

		<!-- Extract sources -->
		<propertyregex property="source.archive" override="true" input="${pkg_detail.dst}" regexp="/" casesensitive="false" replace="_" global="true" defaultValue="${pkg_detail.dst}"/>
		<propertyregex property="source.archive" override="true" input="${dollar}{source.archive}" regexp="^_sf_" casesensitive="false" replace="src_oss_" defaultValue="${dollar}{source.archive}"/>
		<propertyregex property="source.archive" override="true" input="${dollar}{source.archive}" regexp="^_sftools_depl_sdkcreationmdw_packaging" casesensitive="false" replace="src_oss_tools_sdkcreationmdw" defaultValue="${dollar}{source.archive}"/>
		<exec executable="7z" dir="${ant['build.drive']}/" failonerror="true">
			<arg value="x"/>
			<arg value="-y"/>
			<arg value="${dollar}{sf.spec.job.root.drive}/PDK/src/${dollar}{source.archive}.zip"/>
		</exec>

		<!-- Copy sources to build drive -->
		<!-- <copy tofile="${dollar}{prep.build.dir}${pkg_detail.dst}" file="${dollar}{sf.spec.job.root.drive}/PDK/src${pkg_detail.dst}" failonerror="true"/> -->
	</target>

	<target name="sf-bom-info-${count}">
		<!-- record info on source code repo/rev in BOM file and in BIT file -->
		<echo file="${ant['build.drive']}/output/logs/BOM/sources.csv" append="true" message="${dollar}{sources.${count}.URL},${pkg_detail.dst},changeset,${dollar}{sf.sourcesync.${count}.checksum},${pkg_detail.sysdef}${dollar}{line.separator}"/>
		<echo message="content&#x0009;sources,${dollar}{sources.${count}.URL},${dollar}{sf.sourcesync.${count}.checksum}&#x000d;&#x000a;" file="${ant['build.log.dir']}/bitinfo.txt" append="true"/>
	</target>

	<target name="sf-bom-change-info-${count}">
		<if><not><isset property="sf.sourcesync.${count}.checksum"/></not>
			<then>
				<exec executable="hg" dir="${ant['build.drive']}${pkg_detail.dst}" outputproperty="sf.sourcesync.${count}.checksum">
					<arg value="identify"/>
					<arg value="-i"/>
				</exec>
			</then>
		</if>
		<echo message="Writing BOM changes since ${dollar}{sf.previous.pdk.tag} for ${pkg_detail.dst}" />
	</target>

	<#assign fileset = "${fileset}" + "<fileset dir=\"${ant['build.drive']}${pkg_detail.dst}\" includes=\"${pkg_detail.sysdef}\"/>\r\n		  " />
	<#assign sync_list = "${sync_list}" + "<runtarget target=\"sf-prebuild-${count}\"/>\r\n			   "/>
	<#assign bom_list = "${bom_list}" + "<runtarget target=\"sf-bom-info-${count}\"/>\r\n		 "/>
	<#assign change_list = "${change_list}" + "<runtarget target=\"sf-bom-change-info-${count}\"/>\r\n		  "/>
	<#assign count = count + 1 />
  </#list>
</#list>

	<path id="system.definition.files">
		<fileset dir="${dollar}{sf.common.config.dir}/sysdefs" includes="*.sysdef.xml"/>
		${fileset}
	</path>

	<target name="all">
		<parallel threadsPerProcessor="1" failonany="true">
			${sync_list}
		</parallel>

		<echo message="Adding BOM header"/>
		<mkdir dir="${ant['build.drive']}/output/logs/BOM/"/>
		<echo file="${ant['build.drive']}/output/logs/BOM/sources.csv" message="source,dst,type,pattern,sysdef${dollar}{line.separator}"/>

		${bom_list}

		<delete file="${ant['build.drive']}/output/logs/BOM/changes.txt" quiet="true"/>

		${change_list}
	</target>

</project>
