# Copyright (c) 2021 Jone Bontus.
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Jone Bontus.
#
# Contributors:
#
# Description:
# epoc32\tools\listdef.pl
# Generate symbols listing from a .DEF file
# Syntax:
# perl listdef.pl [--asm] <input> <output>
#
#

use strict;
use warnings;
use Getopt::Long;

sub processDefFile ($$);

my %Options;

unless (GetOptions(\%Options, 'asm')) {
	exit 1;
}

unless (@ARGV==2) {
	die "perl listdef.pl [--asm] <input> <output>\n";
}
my ($infile, $outfile) = @ARGV;
my @exports;
processDefFile($infile, \@exports);

open OUT, ">$outfile" or die "Can't open $outfile for write\n";
foreach my $line (@exports) {
	if ($Options{asm}) {
		print OUT "\t.global $line\n";
	} else {
		print OUT "$line\n";
	}
}
close OUT;

sub processDefFile ($$)
{
	my ($defFile, $exportListRef) = @_;

	open DEFFILE, $defFile or die "Can't open $defFile for read\n";

	# Process exports section
	while (<DEFFILE>) {
		if (/EXPORTS/) {
			last;
		}
	}

	while (<DEFFILE>) {
		if ($_ =~ /^\s*(\S+)\s+@\s+\S+\s+NONAME(.*)/) {
			if ($2 !~ /\s+ABSENT/) {
				push @$exportListRef, $1;
			}
		}
	}
	close DEFFILE;
}
