static char sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************/
/*  Program name                                 */
/*       int       col_mn_tr_proc                */
/* --------------------------------------------- */
/*  (I/O)                                        */
/*       Out        0   :Normal                  */
/*                 -1   :AbNormal                */
/* --------------------------------------------- */
/*  Function :                                   */
/*     Justify no shori.                         */
/* --------------------------------------------- */
/*  Version                    1.00  2010/05/28  */
/*************************************************/
/* */

#include "colmn.h"

extern GlobalCt  *pGlobTable;
extern int giOptions[];
#if 0
extern condList CLcList;	/* 񃊃Xg */
extern CLNCB    CLSTCB;		/* ^O̍\͂s߂̗̈ */
#endif
/*********************************************/
/*                                           */
/*********************************************/
static int _add_stack_zero(y)
condList *y;
{
	parmList *lp;
	char buf[12],*pp;
	int  rc,cid,num,len;
	cmdInfo *cmd;

	cmd = y->cmd;
	lp  = cmd->prmp[0];
	num = cmd->prmnum;
	cid = cmd->cid;

	sprintf(buf,"%d",ECL_DO_STACK_ZERO);
	len = strlen(buf);
	cmd->prmnum  = 0;
	cmd->cid     = C_SLEEP;
	pp = cl_const_ct_malloc(y->ConstCt,len+1);
	if (pp) {
		memcpy(pp,buf,len+1);
		rc = clparmset(pp,len);
		rc = cl_tree_main();
	}
	else rc = ECL_MALLOC_ERROR;

	cmd->prmp[0] = lp;
	cmd->prmnum  = num;
	cmd->cid     = cid;
	return rc;
}

/*********************************************/
/*                                           */
/*********************************************/
int col_mn_tr_proc(y)
condList *y;
{
	static char *_fn_="col_mn_tr_proc";
	static char sep[]={" \t\"'()<"};
	int rc,len,n,i,num,opt,line_len,iEXTENDS,cmnd;
	char *name,*pnm,tag,*line,wrk[40];
	qSubCommand *sc;
	SSPL_S sspl;
	cmdInfo *cmd;

	cmd = y->cmd;
	if ((cmnd=cmd->cid) == C_PROC) {
		name = FORMAT(114);	/* "葱" */
		opt = 2;
		tag = CTAG_PROC;
	}
	else if (cmnd == C_FUNCTION) {
		name = FORMAT(115);	/* "֐" */
		opt = 0;
		tag = CTAG_FUNC;
	}
	else {
		if (cmd->cid == C_CLASS) {
			ERROROUT2(FORMAT(318),_fn_,cl_gets_cmd_name(cmnd));	/* %s: %s͎gpł܂B*/
		}
		return -1;
	}
	rc = 0;
	if (cmd->prmnum == 0) {
		ERROROUT2(FORMAT(111),_fn_,name);	/* %s: %sKvłB */
		rc = ECL_TR_PROC;
	}
	else {
		cl_tr_split(y,0,"(");
		pnm = cmd->prmp[0]->prp;
		len = cmd->prmp[0]->prmlen;
#if 1	/* 2017.6.2 */
		rc = cl_tr_chk_proc_name(pnm,len,opt,_fn_,name);
#else
		if (len > PR_NM_DEF) {
			/* %s: %s[%s]܂(len=%d > %d)B */
			ERROROUT5(FORMAT(112),_fn_,name,pnm,len,PR_NM_DEF);
			rc = ECL_TR_PROC;
		}
		if (cl_chk_name_opt(pnm,len,opt)) {
			ERROROUT3(FORMAT(113),_fn_,name,pnm);	/* %s: %s[%s]słB */
			rc = ECL_TR_PROC;
		}
#endif
		if (!rc && cmnd!=C_CLASS) {
			if ((rc = cl_tr_gather(y,1)) > 0) rc = 0;
		}
	}
	if (!rc) {
		rc = cl_make_push_leaf(y);
		y->clstcb->TopStack->cmdtag = tag;
	}
	return rc;
}

/*********************************************/
/*                                           */
/*********************************************/
int cl_tr_split(y,ip,sep)
condList *y;
int ip;
char *sep;
{
	int rc,len,n,i,num;
	char *pnm;
	cmdInfo *cmd;

	cmd = y->cmd;
	pnm = cmd->prmp[0]->prp;
	len = cmd->prmp[0]->prmlen;
	num = cmd->prmnum;
	if (ip<num && num<y->max_prmnum && (n=akxnskipto(pnm,len,sep))<len && n>=0) {
		for (i=num;i>ip+1;i--) cmd->prmp[i] = cmd->prmp[i-1];
		cmd->prmnum = 1;
		if (rc=clparmset(y,pnm+n,len-n)) return rc;
		*(pnm+n) = '\0';
		cmd->prmp[0]->prmlen = n;
		cmd->prmnum = num + 1;
/*
for (i=0;i<cmd->prmnum;i++) printf("split: prmp[%d]=[%s]\n",i,cmd->prmp[i]->prp);
*/
	}
	else n = 0;
	return n;
}

/*********************************************/
/*                                           */
/*********************************************/
int col_mn_tr_exception(y)
condList *y;
{
	int rc,len,n,i,num;
	char *name,*pnm;

	rc = 0;

	if (y->clstcb->nestLev1 != (Leaf *)NULL) {		/* ENDPROC̃`FbN  */
		/* %s: dmcoqnb܂͂dmcetmbݒ肳܂łB */
		ERROROUT1(FORMAT(36),"col_mn_tr_exception");
		rc = ECL_TR_PROC;
	}
	else {
		rc = cl_make_push_leaf(y);
	}
	return rc;
}

/********************************************/
/*											*/
/********************************************/
int cl_tr_chk_proc_name(pnm, len, opt, _fn_, name)
char *pnm,*_fn_,*name;
int len,opt;
{
	char *p;
	int rc;

	rc = 0;
	if (len > PR_NM_DEF) {
		/* %s: %s[%s]܂(len=%d > %d)B */
		ERROROUT5(FORMAT(112),_fn_,name,pnm,len,PR_NM_DEF);
		rc = ECL_TR_PROC;
	}
	if (cl_chk_name_opt(pnm,len,opt)) {
		ERROROUT3(FORMAT(113),_fn_,name,pnm);	/* %s: %s[%s]słB */
		rc = ECL_TR_PROC;
	}
	if (cl_is_yoyakugo(pnm)) {
		ERROROUT2(FORMAT(121),_fn_,pnm);
		rc = ECL_TR_PROC;
	}
	return rc;
}
