/*	GPLv3+	*/
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*-*
@_name	laptime
@auther momi-g
@brief	research interval times
@_synopsys
	void laptime(int num / void / const char* msg);
@_eg
	#include <unistd.h>		//sleep()
	#include "laptime.h"

	int main(int argc, char** argv) {
		laptime(0);	//reset
		sleep(1);	
		laptime();		//>> real 1009ms	: src.c 4:func(): msg:-
		laptime("hw");	//>> real 1010ms	: src.c 5:func(): msg:hw

		laptime(0);	// reset
		laptime();	//>> real 5ms	: src.c 4:func(): msg:-	
		return 0;
	}
	// ~$ cc src.c

@param num	only 0. init timer.
@param void/msg	disp spend times from init. 
@details
	save times to static val when set laptime(0). thread-unsafe.
	time precision is 'ms'.
@_note
@conforming posix-2001+
@version 1.0.2, 2021-06-22
-*/
#ifndef e56c45531f01
#define e56c45531f01

#include <stdio.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "needs compiler posix-2001 or upper(c99+)"
#endif

#define laptime(...)		laptime_sub(#__VA_ARGS__, __FILE__,__LINE__, __func__, __VA_ARGS__+0)
void laptime_sub(const char* s, const char* fname, int lnum, const char* fcname, const char* msg);

#endif
