#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'     ;O=${0##*[/]};R=`dirname $0`;R=${R%/}/;R0=$R$O;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGsuffix"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d
:l;n;p;bl"<$R0>$Rm;$Rp"$Rm"';RB=$($R"s/${C}OP//p"<$R0|(F=mw;while read -r a b;do
B=${a%:};F=`$Rp"$F"|$R"s#$B:*##1;p"`${a%_};$Rp"C$B=\$(cat<<'E'$O$b${O}E$O)";done
$Rp"R1=$F"));Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;bl"<$R0';Cw="(R=LS;$Rw;$Rw>&3;R=HD
$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';Re=eval\ ;$Re"$RB";while getopts $R1\
 R;do case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac
done;[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit   #END GPL3+*/

/*SH_LS*/
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=*SH_bn* section=3 repnl=\040

@name *SH_bn*
@_brief grep comments from c-lang srccode
@_syno
#include "ccmt.h"

char* ccmt(void* src [, const char* mode] );
char* ccmt_v(void* src [, const char* mode] );
//needs free rtnptr

@tl_dr
		@(code)@
	#include "ccmt.h"
	
	int main(int argc, char** argv) {
	  const char* src = "//1.cmt\n 2."//nocmt"\n /*3.cmt\n *" "/\n";
	  char* p = ccmt(src);
	  puts(p); free(p);		//: 1. (2.removed) 3.
	
	  char* p = ccmt_v(src);	//: grep -v
	  puts(p); free(p);		//: (1.) 2. (3.)
  
	  p = ccmt(stdin, "fp");	//: ag1 == filepointer
	  free(p);
	  p = ccmt("mysrc.c", "file");	//: ag1 == filename
	  free(p);
	  return 0;
	}
	//~$ gcc src.c
	//~$ printf '//1\n 2\n' | ./a.out
		@()
@_desc
	ccmt greps c-lang cmt(// or /*..+/) using posix-ERE/BRE regex from src 
	and rtn malloc()ed ptr.
	param is:
	--
	@(list)
	`_src`: src str/fp/filename pointer. treat as strptr if ag2 isnt.
	`_mode`: optional. set ag1 pointer type with string. --
		"p"/"str"/noset >> src is literal string, cosnt char* --
		"fp" >> src is opened file pointer, FILE* --
		"file" >> src is filename. do open-read-close sequence. --
	@()
	--
	ccmt_v() gets cmt removed string as 'grep -v XXX'.--
	ccmt assumes the src doesnt holds trigraphs ??X and long-line syntax \(\n).
	
@return_value
	malloc()ed pointer. rtn NULL + set errno if error.
@conforming_to posix-2001+
@copyright Copyright 2022 momi-g, GPLv3+
@_ver 2022-03-20 v1.0.1 (2022-03-16 v1.0.0)
@_see `regex(3)` --
	https://gcc.gnu.org/onlinedocs/gcc-3.2.3/cpp/Initial-processing.html --
	https://math.stackexchange.com/questions/2482191/how-do-you-draw-a-dfa-from-a-regular-expression --
	https://cs.stackexchange.com/questions/311/deriving-the-regular-expression-for-c-style-comments --
	https://cyberzhg.github.io/toolbox/nfa2dfa?regex=KChiKikoYWIpKGIqKSkq --
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef *SH_bn*_346b432fd64a
#define *SH_bn*_346b432fd64a

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#define ccmt(p, ...)	ccmt_impl(p, 0, __VA_ARGS__ +0)
#define ccmt_v(p, ...)	ccmt_impl(p, 1, __VA_ARGS__ +0)
char* ccmt_impl(void* p, int vflg, const char* mode);
#include <stdlib.h>

#endif /* inc grd */
/*SH_ED*/

/*SH_SC*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#ifdef TEST
	#include <assert.h>
	#include "*SH_bn*.h"	//*SH_co*	*
	#include "hcut.h"
	#include "msgp.h"
	#include "laptime.h"
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__
#endif

#include "*SH_bn*.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>		//exit()
#include <errno.h>
#include <unistd.h>	//getpid()	fd, STDERR_FILENO.  FILE* ... stdout stream.
#include <stdint.h>	//intptr_t type

#include <regex.h>

static int ccmt_flg=0;
static char* ccmt_search(char* str, int vflg){
	//rtnbuff
	char* res = strdup(str);
	STOP( res==NULL, "fatal: strcpy() failed");
	size_t reslen=strlen(res);
	memset(res, 0, reslen+1);

	//re_compile:
	int flg = REG_EXTENDED;
	const char* ptnc = "/[*]([^*]*[/]|[*]*[^*/])*[*]+/";
	if(ccmt_flg== -1){ ptnc = "/[*](([^*]*[/])*([*]*[^*/])*)*[*]+/"; }
	// ptn:
	// yx((a|b|y)*y|x*(a|b))*x+y
	// yx(  [^x]*[y]  |  [x]*[^xy] )*  x+y		>> ERE only
	// yx(  ([^x]*[y]){0,1}  ([x]*[^xy]){0,1} )*  x+y	>> conv to BRE
	// yx(  ([^x]*[y])*  ([x]*[^xy])* )*  x+y		>> use repeat op '|' >> *

	const char* ptnl = "\"([\\].|[^\"])*\"";
	const char* ptncc = "//[^\n]*\n";
	
	// regex valid test 
	// https://math.stackexchange.com/questions/2482191/how-do-you-draw-a-dfa-from-a-regular-expression
	// https://cs.stackexchange.com/questions/311/deriving-the-regular-expression-for-c-style-comments
	// https://cyberzhg.github.io/toolbox/nfa2dfa?regex=KChiKikoYWIpKGIqKSkq

	//switch ERE<>BRE
	if(ccmt_flg==1){
		flg = 0;
//	/[*] (  [^*]*[/]  |  [*]*[^*/]  )*  [*]+/
//	/[*]  \(  \([^*]*[/]\)*  \([*]*[^/*]\)  \)*  [*]\{1,\}/
		ptnc = "/[*]\\(\\([^*]*[/]\\)*\\([*]*[^/*]\\)*\\)*[*]\\{1,\\}/";
		ptnl = "\"\\(\\([\\].\\)*[^\"\\]*\\)*\"";
	}
	if(ccmt_flg==2){
		flg = 0;
//	/[*] \( \([^*]*[/]\)\{0,\}  \([*]*[^/*]\)\{0,\} \)\{0,\} [*]\{1,\}/
		ptnc = "/[*]\\(\\([^*]*[/]\\)\\{0,\\}\\([*]*[^/*]\\)\\{0,\\}\\)\\{0,\\}[*]\\{1,\\}/";
		ptnl = "\"\\(\\([\\].\\)\\{0,1\\}[^\"\\]\\{0,1\\}\\)*\"";
	}
ccmt_flg?
printf("mode, %d-v%d\n", ccmt_flg, vflg),puts(ptnc),puts(ptnl):0;	//dbg

	regex_t cobj, lobj, ccobj;
	int rc =  regcomp(&cobj, ptnc, flg);
	rc +=  regcomp(&lobj, ptnl, flg);
	rc +=  regcomp(&ccobj, ptncc, flg);
	STOP( rc, "fatal: reptn comp failed");

	//search
	regmatch_t robj_c[1], robj_l[1], robj_cc[1];
	flg=0;
	char* np = str;
	int ee = strlen(str) +1;
	char* wptr = res;
	for(;;){
		//1:posbuff size, [0] only
		char* rptr = np;
		int cp = regexec(&cobj, rptr, 1, robj_c, flg) ? ee: robj_c[0].rm_so;
		int lp = regexec(&lobj, rptr, 1, robj_l, flg) ? ee: robj_l[0].rm_so;
		int ccp= regexec(&ccobj, rptr, 1, robj_cc,flg) ? ee: robj_cc[0].rm_so;
//dbg(cp, lp, ccp, ee*3);		
		//code only, break
		if(cp+lp+ccp==ee*3){
//dbg(vflg, rptr, wptr-1);
			if(vflg){ strcpy(wptr, rptr); }
			break;
		}
		//hit
		char* p;
		regoff_t sz;
		//lit
		if(lp<cp && lp<ccp){
			p = rptr + robj_l[0].rm_eo;	//skip
			sz = 0;
		}
		// lcmt
		else if(ccp<cp){
			p = rptr + robj_cc[0].rm_so;	//hit start
			sz = robj_cc[0].rm_eo - robj_cc[0].rm_so;
		}
		// mcmt
		else{
			p = rptr + robj_c[0].rm_so;	//hit start
			sz = robj_c[0].rm_eo  - robj_c[0].rm_so;
		}
		np = p+sz;
		if(vflg==0){
			strncpy(wptr, p, sz);
		}else{
//dbg(p, rptr);
			int nflg = sz && ccp<cp;
			sz = p - rptr;
			strncpy(wptr, rptr, p-rptr);
			if(nflg){ wptr[sz]='\n'; sz++; }	// //..\n eats \n for maincode
		}
		wptr = wptr + sz;
	}
	regfree(&cobj);
	regfree(&lobj);
	regfree(&ccobj);
	return res;
}

static char* mload(FILE* fp, const char* fname){
	if( (fp && fname) || (!fp&&!fname) ){
		STOP(1, "fatal: fp/fname is seletive");
	}

	if(fp==NULL){
		fp = fopen(fname, "r");
		if(fp==NULL){ return NULL; }
	}
	
	size_t msz=128;
	size_t cur = 0;
	char* p = malloc(msz);
	STOP(p==NULL, "fatal: malloc failed");
	while(1){
		size_t n = fread(p+cur, 1, msz-cur, fp);
		cur += n;
		if( feof(fp) ){ break; }
		if(ferror(fp) ){
			free(p);
			errno = EIO;
			break;
		}
		if(cur == msz){
			p = realloc(p, msz*2);
			msz = msz *2;
		}
	}
	if(p){ p[cur] = 0;}
	if(fname){fclose(fp);}
	return p;
}


char* ccmt_impl(void* srcp, int vflg, const char* mode){
	char* resp=NULL;
	if(mode==NULL||strcmp(mode, "p")==0 || strcmp(mode, "str")==0){
		resp = ccmt_search(srcp, vflg);
		goto lb_RTN;
	}
	if(strcmp(mode, "fp")==0){
		srcp = mload(srcp, NULL);
		if(srcp){
			resp = ccmt_search(srcp, vflg);
			free(srcp);
		}
		goto lb_RTN;
	}
	if(strcmp(mode, "file")==0){
		srcp = mload(NULL, srcp);
		if(srcp){
			resp = ccmt_search(srcp, vflg);
			free(srcp);
		}
		goto lb_RTN;
	}
	STOP(1 , "invalid ag2: str/p, fp, file only");
lb_RTN:;
	return resp;
}

#ifdef TEST
HCUT_ADD(t_0) {
	eq_i(errno, 0);
}
#endif


#ifdef TEST_
HCUT_ADD(t_*SH_bn*) {
	eq_i(errno, 0);
	
	char* s = "abc \n \"hw\" //1.0\"nest\"\n 2.\n /*3. \n*/\n 4.\n";
puts(s);
	char* ret = ccmt(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	ret = ccmt_v(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");

	ccmt_flg= -1;
	ret = ccmt(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	ret = ccmt_v(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	
	ccmt_flg=1;
	ret = ccmt(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	ret = ccmt_v(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	
	ccmt_flg=2;
	ret = ccmt(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	ret = ccmt_v(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");

}
#endif

#ifdef TEST_
HCUT_ADD(t_stdin) {
	puts("*SH_bn*.c");
	char* ret = ccmt("*SH_bn*.c", "file");
	ret ? puts(ret), free(ret), 1 : puts("nohit");
}
#endif


#ifdef TEST_
HCUT_ADD(t_speed) {
	laptime(0);
	laptime("Tree");
	dbg(1);
}
#endif

/*SH_SMP
#include "*SH_bn*.h"
int main(){
	char* s = "abc\n \"hw//\" //1.0\"a\"\n 2.\n /*3. \n*""/\n 4.\n";
	puts(s);
	char* ret = ccmt(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	ret = ccmt_v(s);
	ret ? puts(ret), free(ret), 1 : puts("nohit");
	return 0;
}
//	~$ gcc smpl.c *SH_bn*.c

//SH_SMPE*/

#ifdef TEST
HCUT_RUN("stderr", 1,	/* keep newline. use for SH sed edit, -t test.*/
t_ccmnt);
#endif

/*
 change log
 --
2022-03-20  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c (ccmt_impl): add ere/bre regex, min-dfa check@doc_see

2022-03-16  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c (all): init

*/
/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 -static -Wall -pedantic -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s $e"$CB";fgr0 "${C}SMP" "${C}SMPE"<$Rs|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o"	#*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$Cb";$p"cc -shared -fPIC -o lib$bn.so $bn.o `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/

/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 #fgr0 '${C}doc' '${C}docE'<$1|amn -Dzwsp=1 >$Rm
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
# /*SH_OP y $e"$CW";fy
# /*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)
fy()(
cat<<'EEE'|fv
f0 "${C}YACC" "${C}YACCE"<$Rs>myyacc.y
f0 "${C}LEX" "${C}LEXE"<$Rs>mylex.l
lex mylex.l; yacc -p zz -dv myyacc.y
cat y.tab.c lex.yy.c > $Rs
gcc -c y.tab.c lex.yy.c -lfl `fA $Rs $Rh`
rm mylex.l myyacc.y lib$bn.a
ar r lib$bn.a `fo $Rs` y.tab.o lex.yy.o
$p"lib$bn.a"
EEE
)

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte(){
 cat > $Rm-
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 sed -ne "p;/_RUN/bl;d;:l;/[)]/{c\\$O $a)$O p;d};n;bl" $Rm-
 rm $Rm-
}
ftt()(fte "$@"<$tf>$Rm;mv $Rm $tf; cat $Rs $tf>$Rm)
fborn(){
 fgr0 "^#ifdef TEST" "^#endif"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif"<$R0 |fgr0 "^#ifdef TEST" "^#endif"|fbn|fte>tests.code
 fgR "^#ifdef TEST" "^#endif"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
