/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=ccmt section=3 repnl=\040

@name ccmt
@_brief grep comments from c-lang srccode
@_syno
#include "ccmt.h"

char* ccmt(void* src [, const char* mode] );
char* ccmt_v(void* src [, const char* mode] );
//needs free rtnptr

@tl_dr
		@(code)@
	#include "ccmt.h"
	
	int main(int argc, char** argv) {
	  const char* src = "//1.cmt\n 2."//nocmt"\n /*3.cmt\n *" "/\n";
	  char* p = ccmt(src);
	  puts(p); free(p);		//: 1. (2.removed) 3.
	
	  char* p = ccmt_v(src);	//: grep -v
	  puts(p); free(p);		//: (1.) 2. (3.)
  
	  p = ccmt(stdin, "fp");	//: ag1 == filepointer
	  free(p);
	  p = ccmt("mysrc.c", "file");	//: ag1 == filename
	  free(p);
	  return 0;
	}
	//~$ gcc src.c
	//~$ printf '//1\n 2\n' | ./a.out
		@()
@_desc
	ccmt greps c-lang cmt(// or /*..+/) using posix-ERE/BRE regex from src 
	and rtn malloc()ed ptr.
	param is:
	--
	@(list)
	`_src`: src str/fp/filename pointer. treat as strptr if ag2 isnt.
	`_mode`: optional. set ag1 pointer type with string. --
		"p"/"str"/noset >> src is literal string, cosnt char* --
		"fp" >> src is opened file pointer, FILE* --
		"file" >> src is filename. do open-read-close sequence. --
	@()
	--
	ccmt_v() gets cmt removed string as 'grep -v XXX'.--
	ccmt assumes the src doesnt holds trigraphs ??X and long-line syntax \(\n).
	
@return_value
	malloc()ed pointer. rtn NULL + set errno if error.
@conforming_to posix-2001+
@copyright Copyright 2022 momi-g, GPLv3+
@_ver 2022-03-20 v1.0.1 (2022-03-16 v1.0.0)
@_see `regex(3)` --
	https://gcc.gnu.org/onlinedocs/gcc-3.2.3/cpp/Initial-processing.html --
	https://math.stackexchange.com/questions/2482191/how-do-you-draw-a-dfa-from-a-regular-expression --
	https://cs.stackexchange.com/questions/311/deriving-the-regular-expression-for-c-style-comments --
	https://cyberzhg.github.io/toolbox/nfa2dfa?regex=KChiKikoYWIpKGIqKSkq --
//SH_docE*/
#ifndef ccmt_346b432fd64a
#define ccmt_346b432fd64a

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#define ccmt(p, ...)	ccmt_impl(p, 0, __VA_ARGS__ +0)
#define ccmt_v(p, ...)	ccmt_impl(p, 1, __VA_ARGS__ +0)
char* ccmt_impl(void* p, int vflg, const char* mode);
#include <stdlib.h>

#endif /* inc grd */
