/************************************************************************/
/*																		*/
/*		akxlog.h														*/
/*																		*/
/*			Coded by Akito Kobayashi	2010.5.28						*/
/*																		*/
/************************************************************************/
#define X_LOG_NO_MAX        10
#define X_LOG_NO_MAX_RESV   5
#define X_LOG_NO_ERROR      0
#define X_LOG_NO_PRINT      1
#define X_LOG_NO_DEBUG      2
#define X_LOG_NO_STATI      3
#define X_LOG_NO_TRACE      4

#define AKX_LOG_GROUP		0x40000000

#define XERROR_LOG_FILE		"xerror_log"	/* use log_no = 0 */
#define XPRINT_LOG_FILE		"xprint_log"	/* use log_no = 1 */
#define XDEBUG_LOG_FILE		"xdebug_log"	/* use log_no = 2 */
#define XSTATI_LOG_FILE		"xstati_log"	/* use log_no = 3 */
#define XTRACE_LOG_FILE		"xtrace_log"	/* use log_no = 4 */

#define XERROROUTL5(l,fmt,a1,a2,a3,a4,a5) \
	akx_error_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,a4,a5)
#define XERROROUTL4(l,fmt,a1,a2,a3,a4) \
	akx_error_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,a4,NULL)
#define XERROROUTL3(l,fmt,a1,a2,a3) \
	akx_error_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,NULL,NULL)
#define XERROROUTL2(l,fmt,a1,a2) \
	akx_error_out_level(l,__FILE__,__LINE__,fmt,a1,a2,NULL,NULL,NULL)
#define XERROROUTL1(l,fmt,a1) \
	akx_error_out_level(l,__FILE__,__LINE__,fmt,a1,NULL,NULL,NULL,NULL)

#define XPRINTOUTL5(l,fmt,a1,a2,a3,a4,a5) \
	akx_print_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,a4,a5)
#define XPRINTOUTL4(l,fmt,a1,a2,a3,a4) \
	akx_print_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,a4,NULL)
#define XPRINTOUTL3(l,fmt,a1,a2,a3) \
	akx_print_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,NULL,NULL)
#define XPRINTOUTL2(l,fmt,a1,a2) \
	akx_print_out_level(l,__FILE__,__LINE__,fmt,a1,a2,NULL,NULL,NULL)
#define XPRINTOUTL1(l,fmt,a1) \
	akx_print_out_level(l,__FILE__,__LINE__,fmt,a1,NULL,NULL,NULL,NULL)

#define XDEBUGOUTL5(l,fmt,a1,a2,a3,a4,a5) \
	akx_debug_out_level(l,__FILE__,__LINE__,fmt,a1,a2,a3,a4,a5)

#define XLOGFLG(i,f) akx_log_flg(i,f)
#define XLOGLEVEL(i,level) akx_log_level(i,level)
#define XLOGLEVELCHK(i,level) (XLOGLEVEL(i,D_LOG_LEVEL_CHECK)>=level)

int akx_log_flg(/*i,f*/);
int akx_log_set_parm2(/*argc,argv,nparm,iParm*/);
char *akx_log_set_file_name(/*int i, char *cpFile*/);
tdtLogCtlHead *akx_log_get_object(/*void*/);
int akx_log_set_command_parm(/*opt_c,parm_string*/);

#define XLOGFOUT(logfile,data,len) \
	akxa_logfout(logfile,__FILE__,__LINE__,data,len)

