static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************
*																		*
*	ړI	F t												*
*																		*
*	Tv	F 														*
*																		*
*************************************************************************/
/*	25 akxcdate.c		-18750101 ` -18759999	*/
#include "akxcommon.h"

static char *month[]={"January","Jan","February","Feb","March","Mar","April","Apr",
	"May","May","June","Jun","July","Jul","August","Aug","September","Sep",
	"October","Oct","November","Nov","December","Dec",NULL,NULL};
static char *week[]={"Sunday","Sun","j","Monday","Mon","j",
	"Tuesday","Tue","Ηj","Wednesday","Wed","j","Thursday","Thu","ؗj",
	"Friday","Fri","j","Saturday","Sat","yj",NULL,NULL,NULL};
static char char2ix[]={0,0,0,3,0,0,0,4,0,12,0,0,2,5,0,10,0,0,6,0,7,0,0,0,1,0};

/****************************************/
/*	01									*/
/****************************************/
int akxc_chk_date(d,s)
char *s, *d;
{
	static int y0=AKX_TIME_BASE;
	int len,ssp,n,ret,y,m,dm;
	char wd[20],c,yyyy[5],mm[3],dd[3],c1,c2;

	if (!s || !d) return -1;
	*d = yyyy[4] = mm[2] = dd[2] = '\0';
	ssp = 0;
	len = akxtgetw(s, &ssp, wd, sizeof(wd));	/* YYYY/MM/DD */
/*
printf("chk_date:1: len=%d wd=[%s]\n",len,wd);
*/
	ret = 0;
	if (len <= 0) {
		memcpy(yyyy,"0",2);
		memcpy(mm,"0",2);
		memcpy(dd,"0",2);
	}
	else if (len == 10) {	/* YYYY/MM/DD */
		if ((c1=wd[4])>='0' && c1<='9') return -2;
		if ((c2=wd[7])>='0' && c2<='9') return -2;
		sprintf(d,"%s ",wd);
		if (c1 != '/') ret  = 0x01;
		if (c2 != '/') ret |= 0x02;
		memcpy(yyyy,wd,4);
		memcpy(mm,wd+5,2);
		memcpy(dd,wd+8,2);
	}
	else {
		if (len == 8) {	/* YY/MM/DD or YYYYMMDD */
			if ((c=wd[2])<'0' || c>'9') {	/* YY/MM/DD */
				ret = akxccvn(10,wd,2,&n);
				if (ret) return -10;
				if (n >= 51) strcpy(yyyy,"19");
				else         strcpy(yyyy,"20");
				memcpy(yyyy+2,wd,2);
				memcpy(mm,wd+3,2);
				memcpy(dd,wd+6,2);
			}
			else {	/* YYYYMMDD */
				memcpy(yyyy,wd,4);
				memcpy(mm,wd+4,2);
				memcpy(dd,wd+6,2);
			}
		}
		else if (len == 7) {	/* YYYY/MM */
			if ((c=wd[4])<'0' || c>'9') {
				memcpy(yyyy,wd,4);
				memcpy(mm,wd+5,2);
				memcpy(dd,"01",2);
			}
			else return -3;
		}
		else if (len == 6) {	/* YYMMDD */
			ret = akxccvn(10,wd,2,&n);
			if (ret) return ret;
			if (n >= 51) strcpy(yyyy,"19");
			else         strcpy(yyyy,"20");
			memcpy(yyyy+2,wd,2);
			memcpy(mm,wd+2,2);
			memcpy(dd,wd+4,2);
		}
		else if (len == 5) {	/* YY/MM */
			if ((c=wd[2])<'0' || c>'9') {
				ret = akxccvn(10,wd,2,&n);
				if (ret) return ret;
				if (n >= 51) strcpy(yyyy,"19");
				else         strcpy(yyyy,"20");
				memcpy(yyyy+2,wd,2);
				memcpy(mm,wd+3,2);
				memcpy(dd,"01",2);
			}
			else return -4;
		}
		else if (len == 4) {	/* YYYY */
			memcpy(yyyy,wd,4);
			memcpy(mm,"01",2);
			memcpy(dd,"01",2);
		}
		else return -5;
	}
	/* Ñ`FbN */
	ret = akxccvn(10,yyyy,strlen(yyyy),&y);
/*
printf("chk_date:y: ret=%d y=%d\n",ret,y);
*/
	if (ret < 0) return ret;
	else if (ret > 0) return -ret-100;
	if (y < y0) {
		y = y0;
		akxcitoa(y,yyyy,10,5);
	}
	/* ̃`FbN */
	ret = akxccvn(10,mm,strlen(mm),&m);
/*
printf("chk_date:m: ret=%d m=%d\n",ret,m);
*/
	if (ret < 0) return ret;
	else if (ret > 0) return -ret-100;
	if (m <= 0) {
		m = 1;
		memcpy(mm,"01",2);
	}
	else if (m > 12) {
		m = 12;
		memcpy(mm,"12",2);
	}
	/* ̃`FbN */
	ret = akxccvn(10,dd,strlen(dd),&n);
/*
printf("chk_date:d: ret=%d d=%d\n",ret,n);
*/
	if (ret < 0) return ret;
	else if (ret > 0) return -ret-100;
	if (n <= 0) memcpy(dd,"01",2);
	else {
		dm = akxc_days_of_month(y,m);
		if (n > dm) akxcitoa(dm,dd,10,3);
	}
	sprintf(d,"%s/%s/%s ",yyyy,mm,dd);

	len = akxtgetw(s, &ssp, wd, sizeof(wd));	/* HH:MM:SS */
/*
printf("chk_date:2: len=%d wd=[%s]\n",len,wd);
*/
	if (len <= 0) {
		strcpy(wd,"00:00:00");
	}
	else if (len == 8) {
		if ((c1=wd[2])>='0' && c1<='9') return -6;
		if ((c2=wd[5])>='0' && c2<='9') return -6;
		if (c1 != ':') ret |= 0x04;
		if (c2 != ':') ret |= 0x08;
	}
	else return -7;

	strcpy(d+11,wd);
/*
printf("chk_date:2: d=[%s]\n",d);
*/
	return ret;
}

/****************************************/
/*	02									*/
/****************************************/
static int _bin2byte(num,usec,n)
uchar *num;
int usec,n;
{
	int w;
	uchar *x=num+n-1;

	w = usec;
	*x-- = w & 0xff;
	w >>= 8;
	*x-- = w & 0xff;
	if (n >= 3) {
		w >>= 8;
		*x = w & 0xff;
	}
	return 0;
}

/****************************************/
/*	03									*/
/****************************************/
int akxc_tm2mpa(ma,stm,usec)
MPA *ma;
struct tm *stm;
int usec;
{
	int w;

	if (!ma || !stm) return -1;
	*ma = *m_get_i(1);
	ma->num[6] = stm->tm_sec;			/* b */
	ma->num[5] = stm->tm_min;			/*  */
	ma->num[4] = stm->tm_hour;			/*  */
	ma->num[3] = stm->tm_mday;			/*  */
	ma->num[2] = stm->tm_mon + 1;		/*  */
#if 1	/* 2021.5.8 */
	w = stm->tm_year + AKX_TM_YEAR_BASE;
	ma->num[1] = w % 100;	/* __YYN */
	ma->num[0] = w/100;		/* YY__N */
#else
	ma->num[1] = stm->tm_year % 100;	/* N */
	ma->num[0] = stm->tm_year/100 + 19;	/* N */
#endif
	_bin2byte(&ma->num[7],usec,3);		/* }CNb */
	ma->num[10] = stm->tm_hour<12 ? 0 : 1;	/* AM / PM */
	ma->num[11] = stm->tm_wday;			/* j (0-6, j = 0) */
	_bin2byte(&ma->num[12],stm->tm_yday,2);	/* NʎZ (0-365, 1  1  = 0) */
	ma->exp = 6;
	ma->len = AKX_LEN_DATE;
/*
printf("akxc_tm2mpa: num7=%02x %02x %02x\n",ma->num[7],ma->num[8],ma->num[9]);
*/
	return 0;
}

/****************************************/
/*	04									*/
/****************************************/
static int _byte2bin(num,n)
uchar *num;
int n;
{
	int w;
	uchar *x=num;

	w = *x++;
	w <<= 8;
	w |= *x++;
	if (n >= 3) {
		w <<= 8;
		w |= *x;
	}
	return w;
}

/****************************************/
/*	05									*/
/****************************************/
int akxc_mpa2tm(stm,ma)
struct tm *stm;
MPA *ma;
{
	int w;

	if (!ma || !stm) return -1;
	memset(stm,0,sizeof(struct tm));
	stm->tm_sec  = ma->num[6];		/* b */
	stm->tm_min  = ma->num[5];		/*  */
	stm->tm_hour = ma->num[4];		/*  */
	stm->tm_mday = ma->num[3];		/*  */
	stm->tm_mon  = ma->num[2] - 1;	/*  */
#if 1	/* 2021.5.8 */
	w = ma->num[0]*100 + ma->num[1] - AKX_TM_YEAR_BASE;	/* N */
	if (w < 0) w = 0; 
	stm->tm_year = w;	/* N */
#else
	stm->tm_year = (ma->num[0]-19)*100 + ma->num[1];	/* N */
#endif
	stm->tm_wday = ma->num[11];		/* j (0-6, j = 0) */
	stm->tm_yday = ma->num[12]*100 + ma->num[13];		/* NʎZ (0-365)*/
	return _byte2bin(&ma->num[7],3);
}
/* 06 */
/****************************************************/
/*	OSEX1N11̌oߓ߂	*/
/****************************************************/
static time_t get_days(int y, int m, int d)
{
	time_t dy,c,dl,dm;

	/* 1E2 ==> ON13E14 */
	if (m <= 2) {
		y--;
		m += 12;
	}
	dy = 365 * ((time_t)y - 1);				/* oߔN~365 */
	c  = y / 100;
	dl = (y >> 2) - c + (c >> 2);	/* 邤N */
	dm = (m * 979 - 1033) >> 5;		/* 11m1܂ł̓ */
	return dy + dl + dm + d - 1;
}

/****************************************/
/*	07									*/
/****************************************/
static time_t get_seconds(int h, int m, int s)
{
	return ((time_t)h*60 + (time_t)m)*60 + (time_t)s;
}

/****************************************/
/*	08									*/
/****************************************/
int akxc_date2uxstr(p2,len,p1,ma)
char *p1,*p2;
int  len;
MPA  *ma;
{
	struct tm stm;
/*
printf("akxc_date2str: len=%d p1=%08x\n",len,p1);
*/
	if (!p2 || !ma || len<1) return -1;
	if (!p1) p1 = AKX_UNX_DATE_FORMAT;
	akxc_mpa2tm(&stm,ma);
	strftime(p2,len,p1,&stm);
/*
printf("akxc_date2str: p2=[%s]\n",p2);
*/
	return strlen(p2);
}

/****************************************/
/*	09									*/
/****************************************/
char akxc_get_term_char(index)
int index;
{
	static char *term="YMDHNS";
	char c;

	if (index>=1 && index<=6) c = *(term+index-1);
	else c = 'D';
	return c;
}

/****************************************/
/*	10									*/
/****************************************/
int akxc_date_add(MPA *ma, long lValue, int n)
{
	struct tm stm,*ptm;
	time_t tt;

	akxc_mpa2tm(&stm,ma);

	switch (n) {
		case 1:	stm.tm_year += lValue;	break;
		case 2:	stm.tm_mon  += lValue;	break;
		case 3:	stm.tm_mday += lValue;	break;
		case 4:	stm.tm_hour += lValue;	break;
		case 5:	stm.tm_min  += lValue;	break;
		case 6:	stm.tm_sec  += lValue;	break;
		case 7:	stm.tm_mon  += lValue*3;	break;
		case 8:	stm.tm_mday += lValue*7;	break;
		default: return -18751001;
	}
	tt = mktime(&stm);
	if (!(ptm = localtime(&tt))) return -18751002;
	akxc_tm2mpa(ma,ptm);

	return 0;
}

/****************************************/
/*	11									*/
/****************************************/
int akxc_date_add_term(MPA *ma, long lValue, int n)
{
	return akxc_date_add(ma,lValue,n);
}

/****************************************/
/*	12									*/
/****************************************/
int akxc_date_diff_sub(ptt,n,ma1,ma2)
#if 1	/* 2018.7.23 */
double *ptt;
#else
time_t *ptt;
#endif
int n;
MPA *ma1,*ma2;
{
	int rc,y1,y2,t;
#if 1	/* 2018.7.23 */
	time_t  ss1,ss2;
	double  tt1,tt2,tt;
#else
	time_t  tt1,tt2,tt,ss1,ss2;
#endif

	if (!ptt || !ma1 || !ma2) return -1;
	tt = 0;
	y1 = ma1->num[0]*100 + ma1->num[1];
	y2 = ma2->num[0]*100 + ma2->num[1];
	if (n >= 3) {
		tt1 = get_days(y1,ma1->num[2],ma1->num[3]);
		tt2 = get_days(y2,ma2->num[2],ma2->num[3]);
	}
	if (n <= 3) {
		ss1 = get_seconds(ma1->num[4],ma1->num[5],ma1->num[6]);
		ss2 = get_seconds(ma2->num[4],ma2->num[5],ma2->num[6]);
		if (n == 1) {
			tt = y1 - y2;
			tt1 = get_days(1,ma1->num[2],ma1->num[3]);
			tt2 = get_days(1,ma2->num[2],ma2->num[3]);
			tt1 -= tt2;
			if (ss1 < ss2) tt1--;
			if (tt1 < 0) tt--;
		}
		else if (n == 2) {
			tt = (y1*12 + ma1->num[2]) - (y2*12 + ma2->num[2]);
			tt1 = get_days(1,1,ma1->num[3]);
			tt2 = get_days(1,1,ma2->num[3]);
			tt1 -= tt2;
			if (ss1 < ss2) tt1--;
			if (tt1 < 0) tt--;
		}
		else {
			tt = tt1 - tt2;
			if (ss1 < ss2) tt--;
		}
	}
	else {
#if 1	/* 2018.7.23 */
		if (n == 4) {
			ss1 = get_seconds(0,ma1->num[5],ma1->num[6]);
			ss2 = get_seconds(0,ma2->num[5],ma2->num[6]);
			tt = (tt1 - tt2)*24.0 + ma1->num[4] - ma2->num[4];
			if (ss1 < ss2) tt--;
		}
		else if (n == 5) {
			tt = ((tt1 - tt2)*24.0 + ma1->num[4] - ma2->num[4])*60.0
			   + ma1->num[5] - ma2->num[5];
			if (ma1->num[6] < ma2->num[6]) tt--;
		}
		else if (n == 6) {
			tt = (((tt1 - tt2)*24.0 + ma1->num[4] - ma2->num[4])*60.0
			       + ma1->num[5] - ma2->num[6])*60.0 + ma1->num[6] - ma2->num[6];
		}
#else
		if (n == 4) {
			ss1 = get_seconds(0,ma1->num[5],ma1->num[6]);
			ss2 = get_seconds(0,ma2->num[5],ma2->num[6]);
			tt = (tt1*24 + ma1->num[4]) - (tt2*24 + ma2->num[4]);
			if (ss1 < ss2) tt--;
		}
		else if (n == 5) {
			tt = ((tt1*24 + ma1->num[4])*60 + ma1->num[5])
			   - ((tt2*24 + ma2->num[4])*60 + ma2->num[5]);
			if (ma1->num[6] < ma2->num[6]) tt--;
		}
		else if (n == 6) {
			tt = (((tt1*24 + ma1->num[4])*60 + ma1->num[5])*60 + ma1->num[6])
			   - (((tt2*24 + ma2->num[4])*60 + ma2->num[5])*60 + ma2->num[6]);
		}
#endif
		else {
			return -18751201;
		}
	}
	*ptt = tt;
	return 0;
}

/****************************************/
/*	13									*/
/****************************************/
int akxc_is_leap_year(y)
int y;
{
	int rc;

	rc = 0;
	if (!(y % 400)) rc = 1;
	else if (!(y % 4)) {
		if (y % 100) rc = 1;
	}
	return rc;
}

/****************************************/
/*	14									*/
/****************************************/
int akxc_days_of_month(yyyy,mm)
int yyyy,mm;
{
	static uchar mon[12]={31,28,31,30,31,30,31,31,30,31,30,31};
	int dd;

	if (yyyy < 0) yyyy = 0;
	if (mm < 1) mm = 1;
	else if (mm > 12) mm = 12;
	dd = mon[mm-1];
	if (mm == 2) {
		if (akxc_is_leap_year(yyyy)) dd++;
	}
	return dd;
}

/****************************************/
/*	15									*/
/****************************************/
static int _date2str(ix,len,opt,p,ma)
int  ix,len,opt;
char *p;
MPA  *ma;
{
	int t,n;
	char *form,w[7],ww[13];
/*
printf("_date2str: ix=%d len=%d opt=%d\n",ix,len,opt);
*/
	if (ix == 1) {
		t = ma->num[1];
		if (len >= 3) {
			if (len > 3) form = "%04d";
			else form = "%d";
			t += ma->num[0]*100;
		}
		else {
			if (len > 1) form = "%02d";
			else form = "%d";
		}
		sprintf(p,form,t);
	}
	else if (ix <= 6) {
		if (len > 1) form = "%02d";
		else form = "%d";
		t = ma->num[ix];
		if (opt) t %= 12;
		sprintf(p,form,t);
	}
	else  if (ix == 7){
#if 1	/* 2021.6.1 */
		if (len > 6) len = 6;
		sprintf(w,"%d",_byte2bin(&ma->num[ix],3));
		n = strlen(w);
/*
printf("_date2str: len=%d n=%d\n",len,n);
*/
		if (n >= len) strcpy(p,w);
		else {
			strcpy(ww,"000000");
			strcpy(ww+6,w);
			memzcpy(p,ww+6+n-len,len);
		}
#else
		sprintf(w,"%06d",_byte2bin(&ma->num[ix],3));
		memnzcpy(p,w,len,7);
#endif
	}
	else  if (ix == 10){
		if (ma->num[ix]) form = "PM";
		else form = "AM";
		strcpy(p,form);
	}
	else {	/* if (ix == 12) */
		sprintf(p,"%d",_byte2bin(&ma->num[ix],2));
	}
/*
printf("_date2str: p=[%s]\n",p);
*/
	return strlen(p);
}

/****************************************/
/*	16									*/
/****************************************/
static char _chk_YMDHNS(char *s0,int slen0,int val[],char **p0)
{
	static char *keya[]={"MONTH","MON","HH24","H24","HH12","H12","DAY","DY",NULL};
	static char keyx[]={0,0, 0,1, 2,0, 1,0, 2,1, 1,1, 0,0, 0,1};
	char *s,cc,c,**key,*keyn,*p;
	int  opt,n,slen,klen;

	s = s0;
	slen = slen0;
	cc = *s;
	key = keya;
	keyn = keyx;
	opt = n = 0;
	while (p=*key++) {
		klen = strlen(p);
		if (!memcmp(s,p,klen)) {
/*
printf("akxc_date2str: p=[%s]\n",p);
*/
			if (!strcmp(p,"DY") && slen>klen && *(s+klen)=='Y') ;
			else {
				s += klen;
				slen -= klen;
				n = *keyn++;
				opt = *keyn++;
				break;
			}
		}
		keyn += 2;
	}
/*
printf("akxc_date2str: n=%d opt=%d\n",n,opt);
*/
	if (!p && !n) {
		opt = 0;
		s++;
		slen--;
		n = 1;
		while (slen > 0) {
			c = *s;
			if (c != cc) break;
			s++;
			slen--;
			n++;
		}
		if (cc == 'M') {
			if (n == 1) {
				if (slen>0) {
					if (c == 'I') {
						cc = 'N';
						slen--;
						n++;	/* add 2021.6.1 */
					}
				}
			}
		}
		else if (cc=='D' && n==3) cc = 'J';
	}
	val[0] = slen0 - slen;
	val[1] = n;
	val[2] = opt;
	*p0 = p;
	return cc;
}
/* 17 */
/****************************************/
/*	p2		: o̓GA				*/
/*	len2	: p2̃TCY(byte) I['\0'܂܂Ȃ	*/
/*	s0		: ttH[}bg			*/
/*	slen0	: s0̃TCY(byte)			*/
/*	ma		: tf[^				*/
/****************************************/
int akxc_date2str(p2,len2,s0,slen0,ma)
char *s0,*p2;
int  len2,slen0;
MPA  *ma;
{
	static char wrk[256],*p0=NULL;
	char *dp,*p,c,cc,*d,*s,c1,**key,*keyn,*form,*ss,cs;
	int i,len,n,slen,opt,klen,val[3];
	SSPL_S ssp;

	if (!p2 || len2<=0 || !s0 || slen0<=0) return -1;
	if ((len=akxmemwork(slen0+1,&dp,&p0,wrk,sizeof(wrk))) < 0) return -1;
/*
printf("akxc_date2str: slen0=%d s0=[%s]\n",slen0,s0);
*/
	ss = s0;
	akxcuppern(dp,ss,slen0);
	s = dp;
/*
printf("akxc_date2str: s=[%s]\n",s);
*/
	d = p2;
	slen = slen0;
	len = len2;
	while (slen>0 && len>0) {
		if ((n=akxqkanjilen(s)) == 1) {
			c1 = *s;
			cs = *ss;
			c = c1;
			if (c1=='\\' || c1=='`') {
				s++;
				ss++;
				if ((n=akxqkanjilen(s)) > 1) continue;
				*d++ = *ss++;
				s++;
				slen--;
				len--;
			}
			else if (c1=='"' || c1=='\'') {
				ssp.wdmax = slen0;
				ssp.wd = dp + slen0*2;
				ssp.sp = 0;
				n = akxtgwnsl(ss,slen,&ssp,NULL,0x07);
				memcpy(d,ssp.wd,n);
				ss += ssp.sp;
				s += ssp.sp;
				slen -= ssp.sp;
				d += n;
				len -= n;
			}
			else if (strchr("YMDHNSPU",c)) {
/*
printf("akxc_date2str: s=[%s]\n",s);
*/
				cc = _chk_YMDHNS(s,slen,val,&p);
				n = val[1];
				slen -= val[0];
				s += val[0];
				ss += val[0];
				opt = val[2];
				if (p && !n) {
					if (cc == 'M') p = month[(ma->num[2]-1)*2+opt];
					else           p = week[ma->num[11]*3+opt];
					klen = strlen(p);
					memcpy(d,p,klen);
					d += klen;
					len -= klen;
				}
				else {
					n = _date2str(char2ix[cc-'A'],n,opt,d,ma);
					d += n;
					len -= n;
				}
			}
			else {
				s++;
				ss++;
				slen--;
				*d++ = cs;
				len--;
			}
		}
		else {
			memcpy(d,ss,n);
			d += n;
			s += n;
			ss += n;
			slen -= n;
			len -= n;
		}
	}
	*d = '\0';
/*
printf("akxc_date2str=[%s]\n",p2);
*/
	return 0;
}

/****************************************/
/*	18									*/
/****************************************/
static int _str2date(ix,n,len,opt,p,ma)
int  ix,n,len,opt;
char *p;
MPA  *ma;
{
	int t1,t2,ret;
	char *form;
/*
printf("_str2date: ix=%d n=%d len=%d opt=%d p=[%s]\n",ix,n,len,opt,p);
*/
	if (ix == 10) {
		ret = 3;
		t1 = 0;
		if (!memcmp(p,"PM",2)) t1 = 1;
		else if (memcmp(p,"AM",2)) ret = -2;
		ma->num[ix] = t1;
	}
	else {
		ret = akxccvn(10,p,len,&t1);
/*
printf("_str2date: akxccvn ret=%d t1=%d\n",ret,t1);
*/
		if (ret < 0) {
			return ret;
		}
		if (ix == 1) {
			t2 = t1 % 100;
			t1 /= 100;
			if (n <= 2) {
				if (t2 >= 51) t1 = 20;
				else t1 = 19;
			}
			ma->num[0] = t1;
			ma->num[1] = t2;
/*
printf("_str2date: YY=%d YY=%d\n",ma->num[0],ma->num[1]);
*/
		}
		else if (ix <= 6) {
			t2 = t1 % 100;
			ma->num[ix] = t2;
		}
		else  if (ix == 7){
			_bin2byte(&ma->num[ix],t1,3);
		}
		else {	/* if (ix == 12) */
			ma->num[2] = 1;
			ma->num[3] = 1;
			ret = akxc_date_add(ma,t1,3);
		}
	}

	return ret;
}

/****************************************/
/*	19									*/
/****************************************/
int akxc_str2date(p2,len2,s0,slen0,ma)
char *s0,*p2;
int  len2,slen0;
MPA  *ma;
{
	static char wrk[256],*p0=NULL;
	char *dp,*p,c,cc,*d,*s,c1,**key,*keyn,*form,*ss,cs;
	int i,len,n,slen,opt,klen,m,ret,ix,set_h,set_ampm,max_ix,mod_h,val[3],iCLEAR;
	SSPL_S ssp;

	if (!p2 || len2<=0 || !s0 || slen0<=0) return -1;
	if ((len=akxmemwork(slen0+1,&dp,&p0,wrk,sizeof(wrk))) < 0) return -1;
/*
printf("akxc_str2date: len2=%d p2=[%s]\n",len2,p2);
printf("akxc_str2date: slen0=%d s0=[%s]\n",slen0,s0);
*/
	iCLEAR = ma->num[AKX_LEN_DATE] & 0x01;
	ss = s0;
	akxcuppern(dp,ss,slen0);
	s = dp;
/*
printf("akxc_str2date: s=[%s]\n",s);
*/
	d = p2;
	slen = slen0;
	len = len2;
	set_ampm = set_h = max_ix = ret = 0;
	while (slen>0 && len>0) {
		if ((n=akxqkanjilen(s)) == 1) {
			c1 = *s;
			cs = *ss;
/*
printf("akxc_str2date: slen=%d len=%d n=%d c1=[%c] cs=[%c] *d=[%c]\n",slen,len,n,c1,cs,*d);
*/
			c = c1;
			if (c1=='\\' || c1=='`') {
				s++;
				ss++;
				if ((n=akxqkanjilen(s)) > 1) continue;
				if (*d++ != *ss++) break;
				s++;
				slen--;
				len--;
			}
			else if (c1=='"' || c1=='\'') {
				ssp.wdmax = slen0;
				ssp.wd = dp + slen0*2;
				ssp.sp = 0;
				n = akxtgwnsl(ss,slen,&ssp,NULL,0x07);
				if (memcmp(d,ssp.wd,n)) break;
				ss += ssp.sp;
				s += ssp.sp;
				slen -= ssp.sp;
				d += n;
				len -= n;
			}
			else if (strchr("YMDHNSPU",c)) {
/*
printf("akxc_date2str: s=[%s]\n",s);
*/
				cc = _chk_YMDHNS(s,slen,val,&p);
				n = val[1];
				slen -= val[0];
				s += val[0];
				ss += val[0];
				opt = val[2];
/*
printf("akxc_date2str: cc=[%c] n=%d opt=%d p=%08x\n",cc,n,opt,p);
*/
				if (p && !n) {
					if (cc == 'M') {
						key = month + opt;
						m = 2;
						ix = 2;
						i = 1;
					}
					else {
						break;
					}
					while (p=*key++) {
						klen = strlen(p);
						if (!memcmp(d,p,klen)) {
							break;
						}
						key += m;
						i++;
					}
					if (!p) break;
					d += klen;
					len -= klen;
					ma->num[ix] = i;
					if (max_ix < ix) max_ix = ix;
					
				}
				else {
/*
printf("akxc_str2date: slen=%d len=%d c=[%c]\n",slen,len,*s);
*/
					if (slen<=0 || !strchr("YMDHNSPU",*s)) m = len;
					else m = n;
					ix = char2ix[cc-'A'];
					ret = _str2date(ix,n,m,opt,d,ma);
					if (ret < 0) break;
					else if (ret > 0) n = ret - 1;
					else n = m;
					d += n;
					len -= n;
					mod_h = 0;
					if (ix == 10) {	/* AM/PM */
						set_ampm = 1;
						if (set_h) mod_h = 1;
					}
					else if (ix == 4) {	/* H */
						set_h = 1;
						if (set_ampm) mod_h = 1;
					}
					if (mod_h) {
						if (ma->num[10]) {	/* PM */
							if (ma->num[4] <= 12) ma->num[4] += 12;
						}
						else {
							if (ma->num[4] > 12) break;
						}
					}
					if (ix<=7 && max_ix<ix) max_ix = ix;
					if (ix==12 && max_ix<3) max_ix = 3;
				}
			}
			else {
				if (*d != cs) break;	/* move 2021.5.9 */
				s++;
				ss++;
				slen--;
			/*	if (*d != cs) break;	*/
				d++;
				len--;
			}
		}
		else {
			if (memcmp(d,ss,n)) break;
			d += n;
			s += n;
			ss += n;
			slen -= n;
			len -= n;
		}
	}
	if (slen>0 && len>0) {
				/* akxc_str2date: t(%c)Ə(%c)vȂƂ낪܂B*/
	/*	ERROROUT2(FORMAT(609),*d,cs);	*/
		ret = -1;
	}
	else if (iCLEAR) {
		if (!max_ix) {
			ma->num[0] = AKX_TIME_BASE/100;
			ma->num[1] = AKX_TIME_BASE % 100;
			max_ix = 1;
		}
		for (i=max_ix+1;i<=6;i++) {
			n = i<=3 ? 1 : 0;
			ma->num[i] = n;
		}
		if (max_ix == 6) _bin2byte(&ma->num[7],0,3);		/* }CNb */
	}
/*
printf("akxc_str2date: slen=%d len=%d ret=%d]\n",slen,len,ret);
*/
	return ret;
}

/****************************************/
/*	20									*/
/****************************************/
/* opt=1 : 1h60 */
/* opt=2 : 1h100 */
int akxc_hmchar2hma(hma,hmchar,hmcharlen,opt)
int hma[],hmcharlen,opt;
char *hmchar;
{
	int pos,h,m;
	char c;

	if (!hma || !hmchar || hmcharlen<0) return -1;

	h = m = 0;
	if (hmcharlen > 0) {
		pos = inmemchars(hmchar,hmcharlen,":.");
		if (pos > 0) {
			pos--;
			c = *(hmchar+pos);
			m = atoi(hmchar+pos+1);
			if (opt==1 && c=='.') m = (m*60)/100;
			else if (opt==2 && c==':') m = (m*100)/60;
		}
		h = atoi(hmchar);
	}
	hma[0] = h;
	hma[1] = m;
	return 0;
}

/****************************************/
/*	21									*/
/****************************************/
int akxc_add_hms(hms,hms_add)
int hms[],hms_add[];
{
	int i,n,m,d;

	if (!hms || !hms_add) return -1;

	for (i=0;i<=2;i++) {
		hms[i] += hms_add[i];
	}

	m = 60;
	for (i=2;i>=0;i--) {
		if (!i) m = 24;
		n = hms[i];
		d = n / m;
		n = n % m;
		if (n < 0) n += m;
		hms[i] = n;
		if (i > 0) hms[i-1] += d;
	}
	return d;
}
