#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# https://doitu.info/blog/5aabc92d31e68500964d9255
# PythonとBottleでWebSocketサーバ/クライアントを実装
#    https://bottlepy.org/docs/dev/async.html
#    Primer to Asynchronous Applications
#
#	$ pip3 install gevent
#	$ pip3 install gevent-websocket
#

from bottle import request, Bottle, abort, static_file, template
from gevent import sleep					# ③
from gevent.pywsgi import WSGIServer
from geventwebsocket import WebSocketError
from geventwebsocket.handler import WebSocketHandler, Client
# from geventwebsocket.websocket import WebSocket
# from typing import Any, Dict, List, Callable, Tuple, Type

import time

########## ｻｰﾊﾞｰのIPｱﾄﾞﾚｽを求めます。 ##########
import socket
def get_ip_address():
	with socket.socket(socket.AF_INET, socket.SOCK_DGRAM) as s:
		s.connect(("8.8.8.8", 80))
		return s.getsockname()[0]

################################################
def main():
	try:
		app = Bottle()
#		server = WSGIServer(("0.0.0.0", 8088), app, handler_class=WebSocketHandler)
		ip = get_ip_address()								# IPｱﾄﾞﾚｽ を取得

		# トップページ
		@app.route('/')
		def top():
#			return static_file('index2.html', root='./')

			params = dict( { "IP":ip } )						# IPｱﾄﾞﾚｽ を設定

			return template('main2.html',params)				# ﾃﾝﾌﾟﾚｰﾄの初期ﾌｫﾙﾀﾞは､views

		# WebSocketの処理
		@app.route('/websocket')
		def handle_websocket() :
			websocket = request.environ.get('wsgi.websocket')

			if not websocket:
				abort(400, 'Expected WebSocket request.')

			#予想だけど、WebSocketHandlerはクライアントごとに生成される？
			handler = websocket.handler
#			message = websocket.receive()		# ① ｸﾗｲｱﾝﾄからの送信を 1回だけ受ける。

			cnt = 0
			while True:
				try:
	#				handler = websocket.handler
	#				message = websocket.receive()		# ② ｸﾗｲｱﾝﾄからの送信が無いと、待ち状態になる。
														# これが無いと、新しいｸﾗｲｱﾝﾄからのｱｸｾｽを受け付けない。

					# 実際の動作に必要でないけど、以下のようなクラスのインスタンスが入ってるのが解る
			#		assert type(websocket.handler) == WebSocketHandler
			#		assert type(websocket.handler.server) == WSGIServer

					# WSGIServerには本来、clientというプロパティは無いけど、コレを継承しているWebSocketHandlerで動的に追加されてる。
					# なので、型ヒントが利用できない（？）のでignoreするように
					for client in handler.server.clients.values(): # type: ignore
		#				if client.ws.environ:
		#					print(client.ws.environ.get('HTTP_SEC_WEBSOCKET_KEY', ''))
		#				else:
		#					print('空。ブラウザを閉じたり画面を更新したりすると、クライアントから「切断したよ」、という情報が飛んでくる。')

			#			client.ws.send('message: %s, (client_address :%s)' % (message, client.address))
		#				client.ws.send('address=[{}] , count={} , message={}'.format( client.address,cnt,message ))
						client.ws.send('address=[{}] , count={}'.format( client.address,cnt ))


					cnt += 1
			#		time.sleep(3)			# このsleep では、あらたなリクエストを受け付けられない。
					sleep(3)				# gevent.sleep なら、受信をﾛｯｸしない
					# ただし、client の for ループ内に入れると、ﾙｰﾌﾟ処理中に新たな受信を
					# 受け取るので、イテレータエラーになる。fot が一通り終わるまで、新規受付しない。
					# RuntimeError: dictionary changed size during iteration

					# どうも、タイミングだけの様で、sleep(0.1) にすると、上記エラーが発生する。

				except WebSocketError:
					break

		server = WSGIServer(("0.0.0.0", 8088), app, handler_class=WebSocketHandler)
		server.serve_forever()

	except KeyboardInterrupt:
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( datetime.today().strftime( '%Y/%m/%d %H:%M:%S' ) )
		print( ex )								# 例外処理の内容をコンソールに表示
		import traceback
		traceback.print_exc()					# Exception のトレース
	finally :
		print( "終了" )

################################################
if __name__=='__main__':
	main()
